/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.test;

import io.lettuce.core.RedisClient;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.resp.RespServer;
import org.infinispan.server.resp.configuration.RespServerConfigurationBuilder;

public class RespTestingUtil {
    private static final Log log = (Log)LogFactory.getLog(RespTestingUtil.class, Log.class);
    private static final String host = "127.0.0.1";

    public static RedisClient createClient(long timeout, int port) {
        RedisClient client = RedisClient.create((String)("redis://127.0.0.1:" + port));
        client.setDefaultTimeout(Duration.ofMillis(timeout));
        return client;
    }

    public static RespServer startServer(EmbeddedCacheManager cacheManager) {
        return RespTestingUtil.startServer(cacheManager, (Integer)UniquePortThreadLocal.INSTANCE.get());
    }

    public static RespServer startServer(EmbeddedCacheManager cacheManager, int port) {
        RespServer server = new RespServer();
        String serverName = TestResourceTracker.getCurrentTestShortName();
        server.start((ProtocolServerConfiguration)((RespServerConfigurationBuilder)((RespServerConfigurationBuilder)((RespServerConfigurationBuilder)new RespServerConfigurationBuilder().name(serverName)).host(host)).port(port)).build(), cacheManager);
        return server;
    }

    public static RespServer startServer(EmbeddedCacheManager cacheManager, String cacheName) {
        return RespTestingUtil.startServer(cacheManager, (Integer)UniquePortThreadLocal.INSTANCE.get(), cacheName);
    }

    public static RespServer startServer(EmbeddedCacheManager cacheManager, int port, String cacheName) {
        return RespTestingUtil.startServer(cacheManager, port, cacheName, MediaType.APPLICATION_OCTET_STREAM);
    }

    public static RespServer startServer(EmbeddedCacheManager cacheManager, int port, final String cacheName, MediaType valueMediaType) {
        RespServer server = new RespServer(){

            protected void startCaches() {
                this.getCacheManager().getCache(cacheName);
            }
        };
        String serverName = TestResourceTracker.getCurrentTestShortName();
        server.start((ProtocolServerConfiguration)((RespServerConfigurationBuilder)((RespServerConfigurationBuilder)((RespServerConfigurationBuilder)new RespServerConfigurationBuilder().name(serverName)).host(host)).port(port)).build(), cacheManager);
        return server;
    }

    public static void killClient(RedisClient client) {
        try {
            if (client != null) {
                client.shutdown();
            }
        }
        catch (Throwable t) {
            log.error((Object)"Error stopping client", t);
        }
    }

    public static void killServer(RespServer server) {
        if (server != null) {
            server.stop();
        }
    }

    private static final class UniquePortThreadLocal
    extends ThreadLocal<Integer> {
        static UniquePortThreadLocal INSTANCE = new UniquePortThreadLocal();
        private static final AtomicInteger uniqueAddr = new AtomicInteger(16211);

        private UniquePortThreadLocal() {
        }

        @Override
        protected Integer initialValue() {
            return uniqueAddr.getAndAdd(100);
        }
    }
}

