/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.websocket.handlers;

import io.netty.channel.ChannelHandlerContext;
import org.codehaus.jackson.node.ObjectNode;
import org.infinispan.Cache;
import org.infinispan.manager.CacheContainer;
import org.infinispan.server.websocket.OpHandler;
import org.infinispan.server.websocket.handlers.GetHandler;
import org.infinispan.server.websocket.handlers.NotifyHandler;
import org.infinispan.server.websocket.handlers.PutHandler;
import org.infinispan.server.websocket.handlers.RemoveHandler;
import org.infinispan.server.websocket.json.JsonObject;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.websocket.MockChannel;
import org.infinispan.websocket.MockChannelHandlerContext;

public class MockClient {
    private String cacheName;
    private CacheContainer cacheContainer;
    private Cache<Object, Object> cache;
    private OpHandler putHandler = new PutHandler();
    private OpHandler getHandler = new GetHandler();
    private OpHandler removeHandler = new RemoveHandler();
    private OpHandler notifyHandler = new NotifyHandler();
    private MockChannelHandlerContext ctx;

    public MockClient(String cacheName, MockChannel mockChannel) {
        this.cacheName = cacheName;
        this.ctx = new MockChannelHandlerContext(mockChannel);
        this.cacheContainer = TestCacheManagerFactory.createCacheManager();
        this.cache = this.cacheContainer.getCache(cacheName);
    }

    public void put(String key, String value) {
        this.callHandler(this.putHandler, this.toPut(key, value, "text/plain"));
    }

    public void put(String key, ObjectNode value) {
        this.callHandler(this.putHandler, this.toPut(key, value.getTextValue(), "application/json"));
    }

    public void get(String key) {
        this.callHandler(this.getHandler, this.toGet(key));
    }

    public void remove(String key) {
        this.callHandler(this.removeHandler, this.toRemove(key));
    }

    public void notify(String key) {
        this.callHandler(this.notifyHandler, this.toNotify(key));
    }

    public void unnotify(String key) {
        this.callHandler(this.notifyHandler, this.toUnnotify(key));
    }

    public Cache<Object, Object> getCache() {
        return this.cache;
    }

    private void callHandler(OpHandler handler, JsonObject jsonObj) {
        handler.handleOp(jsonObj, this.cache, (ChannelHandlerContext)this.ctx);
    }

    private JsonObject toPut(String key, String value, String mimeType) {
        JsonObject jsonObj = JsonObject.createNew();
        jsonObj.put("opCode", (Object)"put");
        jsonObj.put("cacheName", (Object)this.cacheName);
        jsonObj.put("key", (Object)key);
        jsonObj.put("value", (Object)value);
        jsonObj.put("mime", (Object)mimeType);
        return jsonObj;
    }

    private JsonObject toGet(String key) {
        JsonObject jsonObj = JsonObject.createNew();
        jsonObj.put("opCode", (Object)"get");
        jsonObj.put("cacheName", (Object)this.cacheName);
        jsonObj.put("key", (Object)key);
        return jsonObj;
    }

    private JsonObject toRemove(String key) {
        JsonObject jsonObj = JsonObject.createNew();
        jsonObj.put("opCode", (Object)"remove");
        jsonObj.put("cacheName", (Object)this.cacheName);
        jsonObj.put("key", (Object)key);
        return jsonObj;
    }

    private JsonObject toNotify(String key) {
        JsonObject jsonObj = JsonObject.createNew();
        jsonObj.put("opCode", (Object)"notify");
        jsonObj.put("cacheName", (Object)this.cacheName);
        jsonObj.put("key", (Object)key);
        return jsonObj;
    }

    private JsonObject toUnnotify(String key) {
        JsonObject jsonObj = JsonObject.createNew();
        jsonObj.put("opCode", (Object)"unnotify");
        jsonObj.put("cacheName", (Object)this.cacheName);
        jsonObj.put("key", (Object)key);
        return jsonObj;
    }

    public void stop() {
        this.cache.clear();
        this.cacheContainer.stop();
    }
}

