/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.provider.sample.service;

import org.infinispan.spring.provider.sample.dao.JdbcBookDao;
import org.infinispan.spring.provider.sample.entity.Book;
import org.infinispan.spring.provider.sample.service.CachedBookService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class CachedBookServiceImpl
implements CachedBookService {
    @Autowired
    private JdbcBookDao baseDao;

    @Override
    @Cacheable(value={"books"}, key="#bookId")
    public Book findBook(Integer bookId) {
        return this.baseDao.findBook(bookId);
    }

    @Override
    @CacheEvict(value={"books"}, key="#bookId")
    public void deleteBook(Integer bookId) {
        this.baseDao.deleteBook(bookId);
    }

    @Override
    @CacheEvict(value={"books"}, key="#book.id", condition="#book.id != null")
    public Book updateBook(Book book) {
        return this.baseDao.updateBook(book);
    }

    @Override
    @CachePut(value={"books"}, key="#book.id")
    public Book createBook(Book book) {
        return this.baseDao.createBook(book);
    }

    @Override
    @Cacheable(value={"books"}, key="#bookId", condition="#bookId > 1")
    public Book findBookCondition(Integer bookId) {
        return this.baseDao.findBook(bookId);
    }

    @Override
    @Cacheable(value={"books"}, key="#bookId", unless="#bookId > 1")
    public Book findBookUnless(Integer bookId) {
        return this.baseDao.findBook(bookId);
    }

    @Override
    @Cacheable(value={"books"}, keyGenerator="singleArgKeyGenerator")
    public Book findBookCustomKeyGenerator(Integer bookId) {
        return this.baseDao.findBook(bookId);
    }

    @Override
    @Cacheable(value={"books"}, key="#bookId", cacheResolver="customCacheResolver")
    public Book findBookCustomCacheResolver(Integer bookId) {
        return this.baseDao.findBook(bookId);
    }

    @Override
    @Cacheable(value={"backup"}, key="#bookId")
    public Book findBookBackup(Integer bookId) {
        return this.baseDao.findBook(bookId);
    }

    @Override
    @CachePut(value={"books"}, key="#book.id", condition="#book.title == 'Path to Infinispan Enlightenment'")
    public Book createBookCondition(Book book) {
        return this.baseDao.createBook(book);
    }

    @Override
    @CachePut(value={"books"}, key="#book.id", unless="#book.isbn == '112-358-132'")
    public Book createBookUnless(Book book) {
        return this.baseDao.createBook(book);
    }

    @Override
    @CachePut(value={"books"}, keyGenerator="singleArgKeyGenerator")
    public Book createBookCustomKeyGenerator(Book book) {
        return this.baseDao.createBook(book);
    }

    @Override
    @CachePut(value={"books"}, key="#book.id", cacheResolver="customCacheResolver")
    public Book createBookCustomCacheResolver(Book book) {
        return this.baseDao.createBook(book);
    }

    @Override
    @CachePut(value={"books"}, key="#book.id", cacheManager="cacheManager")
    public Book createBookCustomCacheManager(Book book) {
        return this.baseDao.createBook(book);
    }

    @Override
    @CacheEvict(value={"books"}, key="#bookId", condition="#bookId > 1")
    public void deleteBookCondition(Integer bookId) {
        this.baseDao.deleteBook(bookId);
    }

    @Override
    @CacheEvict(value={"books"}, keyGenerator="singleArgKeyGenerator")
    public void deleteBookCustomKeyGenerator(Integer bookId) {
        this.baseDao.deleteBook(bookId);
    }

    @Override
    @CacheEvict(value={"books"}, key="#bookId", cacheResolver="customCacheResolver")
    public void deleteBookCustomCacheResolver(Integer bookId) {
        this.baseDao.deleteBook(bookId);
    }

    @Override
    @CacheEvict(value={"books"}, key="#bookId", allEntries=true)
    public void deleteBookAllEntries(Integer bookId) {
        this.baseDao.deleteBook(bookId);
    }

    @Override
    @Caching(put={@CachePut(value={"books"}, key="#book.id"), @CachePut(value={"backup"}, key="#book.id")})
    public Book createBookCachingBackup(Book book) {
        return this.baseDao.createBook(book);
    }

    @Override
    @Caching(cacheable={@Cacheable(value={"books"}, key="#bookId"), @Cacheable(value={"backup"}, key="#bookId")})
    public Book findBookCachingBackup(Integer bookId) {
        return this.baseDao.findBook(bookId);
    }

    @Override
    @Cacheable(value={"books"}, cacheManager="cacheManager")
    public Book findBookCustomCacheManager(Integer bookId) {
        return this.baseDao.findBook(bookId);
    }

    @Override
    @Caching(evict={@CacheEvict(value={"books"}), @CacheEvict(value={"backup"})})
    public void deleteBookCachingBackup(Integer bookId) {
        this.baseDao.deleteBook(bookId);
    }

    @Override
    @CacheEvict(value={"books"}, cacheManager="cacheManager")
    public void deleteBookCustomCacheManager(Integer bookId) {
        this.baseDao.deleteBook(bookId);
    }

    @Override
    @CacheEvict(value={"books"}, beforeInvocation=true)
    public void deleteBookBeforeInvocation(Integer bookId) {
        throw new IllegalStateException("This method throws exception by default.");
    }
}

