/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.provider.sample.service;

import javax.cache.annotation.CacheKey;
import javax.cache.annotation.CachePut;
import javax.cache.annotation.CacheRemove;
import javax.cache.annotation.CacheRemoveAll;
import javax.cache.annotation.CacheResult;
import javax.cache.annotation.CacheValue;
import org.infinispan.spring.provider.sample.dao.BaseBookDao;
import org.infinispan.spring.provider.sample.entity.Book;
import org.infinispan.spring.provider.sample.service.CachedBookServiceJsr107;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class CachedBookServiceJsr107Impl
implements CachedBookServiceJsr107 {
    @Autowired
    private BaseBookDao baseDao;

    @Override
    @CacheResult(cacheName="books")
    public Book findBook(Integer bookId) {
        return this.baseDao.findBook(bookId);
    }

    @Override
    @CacheRemove(cacheName="books")
    public void deleteBook(Integer bookId) {
        this.baseDao.deleteBook(bookId);
    }

    @Override
    @CacheRemove(cacheName="books")
    public Book updateBook(Book book) {
        return this.baseDao.updateBook(book);
    }

    @Override
    @CachePut(cacheName="books")
    public Book createBook(@CacheKey @CacheValue Book book) {
        return this.baseDao.createBook(book);
    }

    @Override
    @CacheRemoveAll(cacheName="books")
    public void deleteBookAllEntries(Integer bookId) {
        this.baseDao.deleteBook(bookId);
    }
}

