/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.provider.sample.dao;

import java.lang.invoke.MethodHandles;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import javax.sql.DataSource;
import org.infinispan.spring.provider.sample.dao.BaseBookDao;
import org.infinispan.spring.provider.sample.entity.Book;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;
import org.springframework.stereotype.Repository;

@Repository(value="jdbcBookDao")
public class JdbcBookDao
implements BaseBookDao {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private NamedParameterJdbcTemplate jdbcTemplate;
    private SimpleJdbcInsert bookInsert;

    @Autowired(required=true)
    public void initialize(DataSource dataSource) {
        this.jdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
        this.bookInsert = new SimpleJdbcInsert(dataSource).withTableName("books").usingGeneratedKeyColumns(new String[]{"id"});
    }

    @Override
    public Book findBook(Integer bookId) {
        try {
            log.infof("Loading book [ID = %d]", (Object)bookId);
            return (Book)this.jdbcTemplate.queryForObject("SELECT * FROM books WHERE id = :id", (SqlParameterSource)new MapSqlParameterSource("id", (Object)bookId), (RowMapper)new BookRowMapper());
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public void deleteBook(Integer bookId) {
        log.infof("Deleting book [ID = %d]", (Object)bookId);
        this.jdbcTemplate.update("DELETE FROM books WHERE id = :id", (SqlParameterSource)new MapSqlParameterSource("id", (Object)bookId));
    }

    public Collection<Book> getBooks() {
        return this.jdbcTemplate.query("SELECT * FROM books", (RowMapper)new BookRowMapper());
    }

    @Override
    public Book updateBook(Book bookToUpdate) {
        log.infof("Updating book [%s]", (Object)bookToUpdate);
        this.jdbcTemplate.update("UPDATE books SET isbn = :isbn, author = :author, title = :title WHERE id = :id", this.createParameterSourceFor(bookToUpdate));
        log.infof("Book [%s] updated", (Object)bookToUpdate);
        return bookToUpdate;
    }

    @Override
    public Book createBook(Book bookToCreate) {
        Number newBookId = this.bookInsert.executeAndReturnKey(this.createParameterSourceFor(bookToCreate));
        bookToCreate.setId(newBookId.intValue());
        log.infof("Book [%s] persisted for the first time", (Object)bookToCreate);
        return bookToCreate;
    }

    private SqlParameterSource createParameterSourceFor(Book book) {
        return new MapSqlParameterSource().addValue("id", (Object)book.getId()).addValue("isbn", (Object)book.getIsbn()).addValue("author", (Object)book.getAuthor()).addValue("title", (Object)book.getTitle());
    }

    private static final class BookRowMapper
    implements RowMapper<Book> {
        private BookRowMapper() {
        }

        public Book mapRow(ResultSet rs, int rowNum) throws SQLException {
            Book mappedBook = new Book();
            mappedBook.setId(rs.getInt("id"));
            mappedBook.setIsbn(rs.getString("isbn"));
            mappedBook.setAuthor(rs.getString("author"));
            mappedBook.setTitle(rs.getString("title"));
            return mappedBook;
        }
    }
}

