/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.provider.sample;

import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class SampleHotrodServerLifecycleBean
implements InitializingBean,
DisposableBean {
    private EmbeddedCacheManager cacheManager;
    private HotRodServer hotrodServer;
    private String remoteCacheName;
    private String remoteBackupCacheName;
    private String customCacheName;

    public void setRemoteCacheName(String remoteCacheName) {
        this.remoteCacheName = remoteCacheName;
    }

    public void setRemoteBackupCacheName(String remoteBackupCacheName) {
        this.remoteBackupCacheName = remoteBackupCacheName;
    }

    public void setCustomCacheName(String customCacheName) {
        this.customCacheName = customCacheName;
    }

    public void afterPropertiesSet() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cacheManager.defineConfiguration(this.remoteCacheName, HotRodTestingUtil.hotRodCacheConfiguration().build());
        this.cacheManager.defineConfiguration(this.remoteBackupCacheName, HotRodTestingUtil.hotRodCacheConfiguration().build());
        this.cacheManager.defineConfiguration(this.customCacheName, HotRodTestingUtil.hotRodCacheConfiguration().build());
        HotRodServerConfigurationBuilder hcb = new HotRodServerConfigurationBuilder();
        this.hotrodServer = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManager, (int)15233, (HotRodServerConfigurationBuilder)hcb);
    }

    public void destroy() throws Exception {
        this.cacheManager.stop();
        this.hotrodServer.stop();
    }
}

