/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.provider;

import java.io.IOException;
import java.util.Collection;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.admin.embeddedserver.EmbeddedServerAdminOperationHandler;
import org.infinispan.server.core.test.ServerTestingUtil;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.spring.provider.SpringCache;
import org.infinispan.spring.provider.SpringRemoteCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(testName="spring.provider.SpringRemoteCacheManagerTest", groups={"functional", "smoke"})
public class SpringRemoteCacheManagerTest
extends SingleCacheManagerTest {
    private static final String TEST_CACHE_NAME = "spring.remote.cache.manager.Test";
    private RemoteCacheManager remoteCacheManager;
    private HotRodServer hotrodServer;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cacheManager.defineConfiguration(TEST_CACHE_NAME, this.cacheManager.getDefaultCacheConfiguration());
        this.cache = this.cacheManager.getCache(TEST_CACHE_NAME);
        return this.cacheManager;
    }

    @BeforeClass
    public void setupRemoteCacheFactory() {
        HotRodServerConfigurationBuilder serverBuilder = new HotRodServerConfigurationBuilder();
        serverBuilder.adminOperationsHandler((AdminOperationsHandler)new EmbeddedServerAdminOperationHandler());
        this.hotrodServer = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManager, (int)ServerTestingUtil.findFreePort(), (HotRodServerConfigurationBuilder)serverBuilder);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("localhost").port(this.hotrodServer.getPort().intValue());
        this.remoteCacheManager = new RemoteCacheManager(builder.build());
    }

    @AfterClass
    public void destroyRemoteCacheFactory() {
        this.remoteCacheManager.stop();
        this.hotrodServer.stop();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public final void springRemoteCacheManagerConstructorShouldRejectNullRemoteCacheManager() {
        new SpringRemoteCacheManager(null);
    }

    @Test
    public final void springRemoteCacheManagerShouldProperlyCreateCache() {
        SpringRemoteCacheManager objectUnderTest = new SpringRemoteCacheManager(this.remoteCacheManager);
        SpringCache defaultCache = objectUnderTest.getCache(TEST_CACHE_NAME);
        AssertJUnit.assertNotNull((String)"getCache(spring.remote.cache.manager.Test) should have returned a default cache. However, it returned null.", (Object)defaultCache);
        AssertJUnit.assertEquals((String)"getCache(spring.remote.cache.manager.Test) should have returned a cache name \"spring.remote.cache.manager.Test\". However, the returned cache has a different name.", (String)TEST_CACHE_NAME, (String)defaultCache.getName());
    }

    @Test
    public final void getCacheNamesShouldReturnAllCachesDefinedInConfigurationFile() {
        SpringRemoteCacheManager objectUnderTest = new SpringRemoteCacheManager(this.remoteCacheManager);
        Collection cacheNames = objectUnderTest.getCacheNames();
        AssertJUnit.assertTrue((String)"SpringRemoteCacheManager should load all named caches found in the native cache manager. However, it does not know about the cache named spring.remote.cache.manager.Test defined in said cache manager.", (boolean)cacheNames.contains(TEST_CACHE_NAME));
    }

    @Test
    public final void startShouldStartTheNativeRemoteCacheManager() throws IOException {
        RemoteCacheManager nativeCacheManager = new RemoteCacheManager(true);
        SpringRemoteCacheManager objectUnderTest = new SpringRemoteCacheManager(nativeCacheManager);
        objectUnderTest.start();
        AssertJUnit.assertTrue((String)"Calling start() on SpringRemoteCacheManager should start the enclosed Infinispan RemoteCacheManager. However, it is still not running.", (boolean)nativeCacheManager.isStarted());
    }

    @Test
    public final void stopShouldStopTheNativeRemoteCacheManager() throws IOException {
        RemoteCacheManager nativeCacheManager = new RemoteCacheManager(true);
        SpringRemoteCacheManager objectUnderTest = new SpringRemoteCacheManager(nativeCacheManager);
        objectUnderTest.stop();
        AssertJUnit.assertFalse((String)"Calling stop() on SpringRemoteCacheManager should stop the enclosed Infinispan RemoteCacheManager. However, it is still running.", (boolean)nativeCacheManager.isStarted());
    }

    @Test
    public final void getNativeCacheShouldReturnTheRemoteCacheManagerSuppliedAtConstructionTime() throws IOException {
        RemoteCacheManager nativeCacheManager = new RemoteCacheManager(true);
        SpringRemoteCacheManager objectUnderTest = new SpringRemoteCacheManager(nativeCacheManager);
        RemoteCacheManager nativeCacheManagerReturned = objectUnderTest.getNativeCacheManager();
        AssertJUnit.assertSame((String)"getNativeCacheManager() should have returned the RemoteCacheManager supplied at construction time. However, it retuned a different one.", (Object)nativeCacheManager, (Object)nativeCacheManagerReturned);
    }
}

