/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Properties;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.spring.ConfigurationPropertiesOverrides;
import org.springframework.core.io.Resource;

public abstract class AbstractRemoteCacheManagerFactory {
    protected static final Log logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    protected boolean startAutomatically = true;
    private Properties configurationProperties;
    private Resource configurationPropertiesFileLocation;
    private final ConfigurationPropertiesOverrides configurationPropertiesOverrides = new ConfigurationPropertiesOverrides();

    protected void assertCorrectlyConfigured() throws IllegalStateException {
        if (this.configurationProperties != null && this.configurationPropertiesFileLocation != null) {
            throw new IllegalStateException("You may only use either \"configurationProperties\" or \"configurationPropertiesFileLocation\" to configure the RemoteCacheManager, not both.");
        }
        if (this.configurationProperties != null && !this.configurationPropertiesOverrides.isEmpty()) {
            throw new IllegalStateException("You may only use either \"configurationProperties\" or setters on this FactoryBean to configure the RemoteCacheManager, not both.");
        }
    }

    protected Properties configurationProperties() throws IOException {
        Properties answer;
        if (this.configurationProperties != null) {
            answer = this.configurationPropertiesOverrides.override(this.configurationProperties);
            logger.debug((Object)("Using user-defined properties [" + this.configurationProperties + "] for configuring RemoteCacheManager"));
        } else if (this.configurationPropertiesFileLocation != null) {
            answer = this.loadPropertiesFromFile(this.configurationPropertiesFileLocation);
            logger.debug((Object)("Loading properties from file [" + this.configurationProperties + "] for configuring RemoteCacheManager"));
        } else if (!this.configurationPropertiesOverrides.isEmpty()) {
            answer = this.configurationPropertiesOverrides.override(new Properties());
            logger.debug((Object)("Using explicitly set configuration settings [" + answer + "] for configuring RemoteCacheManager"));
        } else {
            logger.debug((Object)"No configuration properties. RemoteCacheManager will use default configuration.");
            answer = new RemoteCacheManager().getConfiguration().properties();
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadPropertiesFromFile(Resource propertiesFileLocation) throws IOException {
        InputStream propsStream = null;
        try {
            propsStream = propertiesFileLocation.getInputStream();
            Properties answer = new Properties();
            answer.load(propsStream);
            Properties properties = answer;
            return properties;
        }
        finally {
            if (propsStream != null) {
                try {
                    propsStream.close();
                }
                catch (IOException e) {
                    logger.warn((Object)("Failed to close InputStream used to load configuration properties: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    public void setConfigurationProperties(Properties configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    public void setConfigurationPropertiesFileLocation(Resource configurationPropertiesFileLocation) {
        this.configurationPropertiesFileLocation = configurationPropertiesFileLocation;
    }

    public void setStartAutomatically(boolean startAutomatically) {
        this.startAutomatically = startAutomatically;
    }

    @Deprecated
    public void setTransportFactory(String TransportFactory) {
        this.configurationPropertiesOverrides.setTransportFactory(TransportFactory);
    }

    public void setServerList(Collection<InetSocketAddress> serverList) {
        this.configurationPropertiesOverrides.setServerList(serverList);
    }

    public void setMarshaller(String marshaller) {
        this.configurationPropertiesOverrides.setMarshaller(marshaller);
    }

    public void setAsyncExecutorFactory(String asyncExecutorFactory) {
        this.configurationPropertiesOverrides.setAsyncExecutorFactory(asyncExecutorFactory);
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.configurationPropertiesOverrides.setTcpNoDelay(tcpNoDelay);
    }

    public void setTcpKeepAlive(boolean tcpKeepAlive) {
        this.configurationPropertiesOverrides.setTcpKeepAlive(tcpKeepAlive);
    }

    public void setRequestBalancingStrategy(String requestBalancingStrategy) {
        this.configurationPropertiesOverrides.setRequestBalancingStrategy(requestBalancingStrategy);
    }

    public void setKeySizeEstimate(int keySizeEstimate) {
        this.configurationPropertiesOverrides.setKeySizeEstimate(keySizeEstimate);
    }

    public void setValueSizeEstimate(int valueSizeEstimate) {
        this.configurationPropertiesOverrides.setValueSizeEstimate(valueSizeEstimate);
    }

    public void setForceReturnValues(boolean forceReturnValues) {
        this.configurationPropertiesOverrides.setForceReturnValues(forceReturnValues);
    }
}

