/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.session;

import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.spring.provider.SpringCache;
import org.infinispan.spring.session.AbstractInfinispanSessionRepository;
import org.infinispan.spring.session.InfinispanApplicationPublishedBridgeTCK;
import org.infinispan.spring.session.InfinispanRemoteSessionRepository;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="spring.session.RemoteApplicationPublishedBridgeTest", groups={"unit"})
public class RemoteApplicationPublishedBridgeTest
extends InfinispanApplicationPublishedBridgeTCK {
    private EmbeddedCacheManager embeddedCacheManager;
    private HotRodServer hotrodServer;
    private RemoteCacheManager remoteCacheManager;

    @BeforeClass
    public void beforeClass() {
        this.embeddedCacheManager = TestCacheManagerFactory.createCacheManager();
        this.hotrodServer = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)this.embeddedCacheManager, (int)19723);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("localhost").port(this.hotrodServer.getPort().intValue());
        this.remoteCacheManager = new RemoteCacheManager(builder.build());
    }

    @AfterMethod
    public void afterMethod() {
        this.remoteCacheManager.getCache().clear();
    }

    @AfterClass
    public void afterClass() {
        this.remoteCacheManager.stop();
        this.hotrodServer.stop();
        this.embeddedCacheManager.stop();
    }

    @BeforeMethod
    public void beforeMethod() throws Exception {
        super.init();
    }

    protected SpringCache createSpringCache() {
        return new SpringCache((BasicCache)this.remoteCacheManager.getCache());
    }

    protected void callEviction() {
        this.embeddedCacheManager.getCache().getAdvancedCache().getExpirationManager().processExpiration();
    }

    protected AbstractInfinispanSessionRepository createRepository(SpringCache springCache) throws Exception {
        InfinispanRemoteSessionRepository sessionRepository = new InfinispanRemoteSessionRepository(springCache);
        sessionRepository.afterPropertiesSet();
        return sessionRepository;
    }

    public void testEventBridge() throws Exception {
        super.testEventBridge();
    }

    public void testUnregistration() throws Exception {
        super.testUnregistration();
    }
}

