/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.support.remote;

import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.spring.test.InfinispanTestExecutionListener;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_CLASS)
@ContextConfiguration(value={"classpath:/org/infinispan/spring/support/remote/InfinispanRemoteCacheManagerFactoryBeanContextTest.xml"})
@Test(testName="spring.support.remote.InfinispanRemoteCacheManagerFactoryBeanContextTest", groups={"unit"})
@TestExecutionListeners(value={InfinispanTestExecutionListener.class})
public class InfinispanRemoteCacheManagerFactoryBeanContextTest
extends AbstractTestNGSpringContextTests {
    private static final String INFINISPAN_REMOTE_CACHE_MANAGER_WITH_DEFAULT_CONFIGURATION_BEAN_NAME = "infinispanRemoteCacheManagerWithDefaultConfiguration";
    private static final String INFINISPAN_REMOTE_CACHE_MANAGER_CONFIGURED_FROM_CONFIGURATION_PROPERTIES_FILE_BEAN_NAME = "infinispanRemoteCacheManagerConfiguredFromConfigurationPropertiesFile";
    private static final String INFINISPAN_REMOTE_CACHE_MANAGER_CONFIGURED_FROM_CONFIGURATION_PROPERTIES_BEAN_NAME = "infinispanRemoteCacheManagerConfiguredFromConfigurationProperties";
    private static final String INFINISPAN_REMOTE_CACHE_MANAGER_CONFIGURED_USING_SETTERS_BEAN_NAME = "infinispanRemoteCacheManagerConfiguredUsingSetters";

    @Test
    public final void shouldCreateARemoteCacheManagerWithDefaultSettingsIfNoFurtherConfigurationGiven() {
        RemoteCacheManager infinispanRemoteCacheManagerWithDefaultConfiguration = (RemoteCacheManager)this.applicationContext.getBean(INFINISPAN_REMOTE_CACHE_MANAGER_WITH_DEFAULT_CONFIGURATION_BEAN_NAME, RemoteCacheManager.class);
        AssertJUnit.assertNotNull((String)"Spring application context should contain a RemoteCacheManager with default settings having bean name = \"infinispanRemoteCacheManagerWithDefaultConfiguration\". However, it doesn't.", (Object)infinispanRemoteCacheManagerWithDefaultConfiguration);
    }

    @Test
    public final void shouldCreateARemoteCacheManagerConfiguredFromConfigurationPropertiesFileIfConfigurationPropertiesFileLocationGiven() {
        RemoteCacheManager infinispanRemoteCacheManagerConfiguredFromConfigurationFile = (RemoteCacheManager)this.applicationContext.getBean(INFINISPAN_REMOTE_CACHE_MANAGER_CONFIGURED_FROM_CONFIGURATION_PROPERTIES_FILE_BEAN_NAME, RemoteCacheManager.class);
        AssertJUnit.assertNotNull((String)"Spring application context should contain a RemoteCacheManager configured from configuration properties file having bean name = \"infinispanRemoteCacheManagerConfiguredFromConfigurationPropertiesFile\". However, it doesn't.", (Object)infinispanRemoteCacheManagerConfiguredFromConfigurationFile);
    }

    @Test
    public final void shouldCreateARemoteCacheManagerConfiguredFromConfigurationPropertiesIfConfigurationPropertiesGiven() {
        RemoteCacheManager infinispanRemoteCacheManagerConfiguredFromConfigurationProperties = (RemoteCacheManager)this.applicationContext.getBean(INFINISPAN_REMOTE_CACHE_MANAGER_CONFIGURED_FROM_CONFIGURATION_PROPERTIES_BEAN_NAME, RemoteCacheManager.class);
        AssertJUnit.assertNotNull((String)"Spring application context should contain a RemoteCacheManager configured from configuration properties having bean name = \"infinispanRemoteCacheManagerConfiguredFromConfigurationProperties\". However, it doesn't.", (Object)infinispanRemoteCacheManagerConfiguredFromConfigurationProperties);
    }

    @Test
    public final void shouldCreateARemoteCacheManagerConfiguredUsingSettersIfPropertiesAreDefined() {
        RemoteCacheManager infinispanRemoteCacheManagerConfiguredUsingSetters = (RemoteCacheManager)this.applicationContext.getBean(INFINISPAN_REMOTE_CACHE_MANAGER_CONFIGURED_USING_SETTERS_BEAN_NAME, RemoteCacheManager.class);
        AssertJUnit.assertNotNull((String)"Spring application context should contain a SpringRemoteCacheManager configured using properties having bean name = \"infinispanRemoteCacheManagerConfiguredUsingSetters\". However, it doesn't.", (Object)infinispanRemoteCacheManagerConfiguredUsingSetters);
    }
}

