/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.file;

import java.util.Properties;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfigurationBuilder;
import org.infinispan.tools.store.migrator.AbstractReaderTest;
import org.infinispan.tools.store.migrator.Element;
import org.infinispan.tools.store.migrator.StoreType;
import org.infinispan.tools.store.migrator.TestUtil;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(testName="tools.store.migrator.file.SoftIndexFileStoreReaderTest", groups={"functional"})
public class SoftIndexFileStoreReaderTest
extends AbstractReaderTest {
    private static final String SOURCE_DIR = "target/test-classes/softindex/";

    public String getTargetDataDirectory() {
        return "target/test-classes/softindex//target-softindex/data/" + this.segmentCount + "/";
    }

    public String getTargetIndexDirectory() {
        return "target/test-classes/softindex//target-softindex/index/" + this.segmentCount + "/";
    }

    @Factory
    public Object[] factory() {
        return new Object[]{new SoftIndexFileStoreReaderTest().segmented(37), new SoftIndexFileStoreReaderTest()};
    }

    @Override
    public ConfigurationBuilder getTargetCacheConfig() {
        ConfigurationBuilder builder = super.getTargetCacheConfig();
        ((SoftIndexFileStoreConfigurationBuilder)((SoftIndexFileStoreConfigurationBuilder)((SoftIndexFileStoreConfigurationBuilder)builder.persistence().addStore(SoftIndexFileStoreConfigurationBuilder.class)).dataLocation(this.getTargetDataDirectory()).indexLocation(this.getTargetIndexDirectory()).preload(true)).ignoreModifications(true)).segmented(this.segmentCount > 0);
        return builder;
    }

    @Override
    protected void configureStoreProperties(Properties properties, Element type) {
        super.configureStoreProperties(properties, type);
        properties.put(TestUtil.propKey(type, Element.TYPE), StoreType.SOFT_INDEX_FILE_STORE.toString());
        if (type == Element.SOURCE) {
            properties.put(TestUtil.propKey(type, Element.LOCATION), SOURCE_DIR);
        } else {
            properties.put(TestUtil.propKey(type, Element.LOCATION), this.getTargetDataDirectory());
            properties.put(TestUtil.propKey(type, Element.INDEX_LOCATION), this.getTargetIndexDirectory());
        }
    }
}

