/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.sampledomain.marshallers;

import java.io.IOException;
import java.util.Date;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.sampledomain.Transaction;

public class TransactionMarshaller
implements MessageMarshaller<Transaction> {
    public String getFullName() {
        return "sample_bank_account.Transaction";
    }

    public Transaction readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        int id = reader.readInt("id");
        String description = reader.readString("description");
        int accountId = reader.readInt("accountId");
        long date = reader.readLong("date");
        double amount = reader.readDouble("amount");
        boolean isDebit = reader.readBoolean("isDebit");
        Transaction transaction = new Transaction();
        transaction.setId(id);
        transaction.setDescription(description);
        transaction.setAccountId(accountId);
        transaction.setDate(new Date(date));
        transaction.setAmount(amount);
        transaction.setDebit(isDebit);
        return transaction;
    }

    public void writeTo(MessageMarshaller.ProtoStreamWriter writer, Transaction transaction) throws IOException {
        writer.writeInt("id", transaction.getId());
        writer.writeString("description", transaction.getDescription());
        writer.writeInt("accountId", transaction.getAccountId());
        writer.writeLong("date", transaction.getDate());
        writer.writeDouble("amount", transaction.getAmount());
        writer.writeBoolean("isDebit", transaction.isDebit());
    }
}

