/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.sampledomain.marshallers;

import java.io.IOException;
import java.util.Date;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.sampledomain.Account;

public class AccountMarshaller
implements MessageMarshaller<Account> {
    public String getTypeName() {
        return "sample_bank_account.Account";
    }

    public Class<? extends Account> getJavaClass() {
        return Account.class;
    }

    public Account readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        int id = reader.readInt("id");
        String description = reader.readString("description");
        long creationDate = reader.readLong("creationDate");
        Account account = new Account();
        account.setId(id);
        account.setDescription(description);
        account.setCreationDate(new Date(creationDate));
        return account;
    }

    public void writeTo(MessageMarshaller.ProtoStreamWriter writer, Account account) throws IOException {
        writer.writeInt("id", account.getId());
        writer.writeString("description", account.getDescription());
        writer.writeLong("creationDate", account.getCreationDate().getTime());
    }
}

