/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.sampledomain.marshallers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.sampledomain.Account;

public class AccountMarshaller
implements MessageMarshaller<Account> {
    public String getTypeName() {
        return "sample_bank_account.Account";
    }

    public Class<? extends Account> getJavaClass() {
        return Account.class;
    }

    public Account readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        int id = reader.readInt("id");
        String description = reader.readString("description");
        Date creationDate = reader.readDate("creationDate");
        Account.Limits limits = (Account.Limits)((Object)reader.readObject("limits", Account.Limits.class));
        List blurb = (List)reader.readCollection("blurb", new ArrayList(), byte[].class);
        Account.Currency[] currencies = (Account.Currency[])reader.readArray("currencies", Account.Currency.class);
        Account account = new Account();
        account.setId(id);
        account.setDescription(description);
        account.setCreationDate(creationDate);
        account.setLimits(limits);
        account.setBlurb(blurb);
        account.setCurrencies(currencies);
        return account;
    }

    public void writeTo(MessageMarshaller.ProtoStreamWriter writer, Account account) throws IOException {
        writer.writeInt("id", account.getId());
        writer.writeString("description", account.getDescription());
        writer.writeDate("creationDate", account.getCreationDate());
        writer.writeObject("limits", (Object)account.getLimits(), Account.Limits.class);
        writer.writeCollection("blurb", account.getBlurb(), byte[].class);
        writer.writeArray("currencies", (Object[])account.getCurrencies(), Account.Currency.class);
    }
}

