/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.sampledomain;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.infinispan.protostream.BaseMessage;

public class Account
extends BaseMessage {
    private int id;
    private String description;
    private Date creationDate;
    private Limits limits;
    private Limits hardLimits = new Limits();
    private List<byte[]> blurb;
    private Currency[] currencies;

    public Account() {
        this.hardLimits.setMaxTransactionLimit(5000.0);
        this.hardLimits.setMaxDailyLimit(10000.0);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Limits getLimits() {
        return this.limits;
    }

    public void setLimits(Limits limits) {
        this.limits = limits;
    }

    public Limits getHardLimits() {
        return this.hardLimits;
    }

    public void setHardLimits(Limits hardLimits) {
        this.hardLimits = hardLimits;
    }

    public List<byte[]> getBlurb() {
        return this.blurb;
    }

    public void setBlurb(List<byte[]> blurb) {
        this.blurb = blurb;
    }

    private boolean blurbEquals(List<byte[]> otherBlurbs) {
        if (otherBlurbs == this.blurb) {
            return true;
        }
        if (otherBlurbs == null || this.blurb == null || otherBlurbs.size() != this.blurb.size()) {
            return false;
        }
        for (int i = 0; i < this.blurb.size(); ++i) {
            if (Arrays.equals(this.blurb.get(i), otherBlurbs.get(i))) continue;
            return false;
        }
        return true;
    }

    public Currency[] getCurrencies() {
        return this.currencies;
    }

    public void setCurrencies(Currency[] currencies) {
        this.currencies = currencies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        Account account = (Account)((Object)o);
        return this.id == account.id && Objects.equals(this.description, account.description) && Objects.equals(this.creationDate, account.creationDate) && Objects.equals((Object)this.limits, (Object)account.limits) && Objects.equals((Object)this.hardLimits, (Object)account.hardLimits) && this.blurbEquals(account.blurb) && Arrays.equals((Object[])this.currencies, (Object[])account.currencies);
    }

    public int hashCode() {
        int blurbHash = 0;
        if (this.blurb != null) {
            for (byte[] b : this.blurb) {
                blurbHash = 31 * blurbHash + Arrays.hashCode(b);
            }
        }
        return Objects.hash(new Object[]{this.id, this.description, this.creationDate, this.limits, this.hardLimits, blurbHash, Arrays.hashCode((Object[])this.currencies)});
    }

    public String toString() {
        return "Account{id=" + this.id + ", description='" + this.description + '\'' + ", creationDate='" + this.creationDate + '\'' + ", limits=" + (Object)((Object)this.limits) + ", hardLimits=" + (Object)((Object)this.hardLimits) + ", blurb=" + (this.blurb != null ? this.blurb.stream().map(Arrays::toString).collect(Collectors.toList()) : "null") + ", currencies=" + Arrays.toString((Object[])this.currencies) + ", unknownFieldSet=" + this.unknownFieldSet + '}';
    }

    public static class Limits
    extends BaseMessage {
        private Double maxDailyLimit;
        private Double maxTransactionLimit;
        private String[] payees = new String[0];

        public Double getMaxDailyLimit() {
            return this.maxDailyLimit;
        }

        public void setMaxDailyLimit(Double maxDailyLimit) {
            this.maxDailyLimit = maxDailyLimit;
        }

        public Double getMaxTransactionLimit() {
            return this.maxTransactionLimit;
        }

        public void setMaxTransactionLimit(Double maxTransactionLimit) {
            this.maxTransactionLimit = maxTransactionLimit;
        }

        public String[] getPayees() {
            return this.payees;
        }

        public void setPayees(String[] payees) {
            this.payees = payees;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Limits limits = (Limits)((Object)o);
            return Objects.equals(this.maxDailyLimit, limits.maxDailyLimit) && Objects.equals(this.maxTransactionLimit, limits.maxTransactionLimit) && Arrays.equals(this.payees, limits.payees);
        }

        public int hashCode() {
            return Objects.hash(this.maxDailyLimit, this.maxTransactionLimit, Arrays.hashCode(this.payees));
        }

        public String toString() {
            return "Limits{maxDailyLimit=" + this.maxDailyLimit + ", maxTransactionLimit=" + this.maxTransactionLimit + ", payees=" + Arrays.toString(this.payees) + '}';
        }
    }

    public static enum Currency {
        EUR,
        GBP,
        USD,
        BRL;

    }
}

