/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.context;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import org.jboss.as.naming.ContextListAndJndiViewManagedReferenceFactory;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.as.security.SecurityMessages;
import org.jboss.as.security.context.SecurityActions;
import org.jboss.as.security.plugins.DefaultAuthenticationCacheFactory;
import org.jboss.as.security.plugins.JNDIBasedSecurityManagement;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jboss.security.ISecurityManagement;

public class SecurityDomainJndiInjectable
implements InvocationHandler,
ContextListAndJndiViewManagedReferenceFactory {
    private final InjectedValue<ISecurityManagement> securityManagementValue = new InjectedValue();

    public String getInstanceClassName() {
        return this.getReference().getInstance().getClass().getName();
    }

    public String getJndiViewInstanceValue() {
        return String.valueOf(this.getReference().getInstance());
    }

    public ManagedReference getReference() {
        ModuleClassLoader loader;
        try {
            loader = SecurityActions.getModuleClassLoader();
        }
        catch (ModuleLoadException e) {
            throw SecurityMessages.MESSAGES.unableToGetModuleClassLoader(e);
        }
        Class[] interfaces = new Class[]{Context.class};
        return new ValueManagedReference((Value)new ImmediateValue(Proxy.newProxyInstance((ClassLoader)loader, interfaces, (InvocationHandler)this)));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        InitialContext ctx = new InitialContext();
        NameParser parser = ctx.getNameParser("");
        String securityDomain = null;
        Name name = null;
        JNDIBasedSecurityManagement securityManagement = (JNDIBasedSecurityManagement)JNDIBasedSecurityManagement.class.cast(this.securityManagementValue.getValue());
        ConcurrentHashMap<String, SecurityDomainContext> securityManagerMap = securityManagement.getSecurityManagerMap();
        String methodName = method.getName();
        if (methodName.equals("toString")) {
            return "java:jboss/jaas/ Context proxy";
        }
        if (methodName.equals("list")) {
            return new DomainEnumeration(securityManagerMap.keys(), securityManagerMap);
        }
        if (methodName.equals("bind") || methodName.equals("rebind")) {
            name = args[0] instanceof String ? parser.parse((String)args[0]) : (Name)args[0];
            securityDomain = name.get(0);
            SecurityDomainContext val = (SecurityDomainContext)args[1];
            securityManagerMap.put(securityDomain, val);
            return proxy;
        }
        if (!methodName.equals("lookup")) {
            throw SecurityMessages.MESSAGES.operationNotSupported(method);
        }
        name = args[0] instanceof String ? parser.parse((String)args[0]) : (Name)args[0];
        securityDomain = name.get(0);
        SecurityDomainContext securityDomainCtx = this.lookupSecurityDomain(securityManagement, securityManagerMap, securityDomain);
        Object binding = securityDomainCtx.getAuthenticationManager();
        if (name.size() == 2) {
            String request = name.get(1);
            binding = securityDomainCtx.lookup(request);
        }
        return binding;
    }

    private SecurityDomainContext lookupSecurityDomain(JNDIBasedSecurityManagement securityManagement, ConcurrentHashMap<String, SecurityDomainContext> securityManagerMap, String securityDomain) throws Exception {
        SecurityDomainContext sdc = securityManagerMap.get(securityDomain);
        if (sdc == null) {
            sdc = securityManagement.createSecurityDomainContext(securityDomain, new DefaultAuthenticationCacheFactory());
            securityManagerMap.put(securityDomain, sdc);
        }
        return sdc;
    }

    public Injector<ISecurityManagement> getSecurityManagementInjector() {
        return this.securityManagementValue;
    }

    class DomainEnumeration
    implements NamingEnumeration<NameClassPair> {
        Enumeration<String> domains;
        Map<String, SecurityDomainContext> ctxMap;

        DomainEnumeration(Enumeration<String> domains, Map<String, SecurityDomainContext> ctxMap) {
            this.domains = domains;
            this.ctxMap = ctxMap;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasMoreElements() {
            return this.domains.hasMoreElements();
        }

        @Override
        public boolean hasMore() {
            return this.domains.hasMoreElements();
        }

        @Override
        public NameClassPair next() {
            String name = this.domains.nextElement();
            SecurityDomainContext value = this.ctxMap.get(name);
            String className = value.getClass().getName();
            NameClassPair pair = new NameClassPair(name, className);
            return pair;
        }

        @Override
        public NameClassPair nextElement() {
            return this.next();
        }
    }
}

