/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.hotrod;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.http.annotation.ThreadSafe;
import org.infinispan.client.hotrod.impl.transport.tcp.RequestBalancingStrategy;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

@ThreadSafe
public class Node0OnlyBalancingStrategy
implements RequestBalancingStrategy {
    private static final Log log = LogFactory.getLog(Node0OnlyBalancingStrategy.class);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private volatile InetSocketAddress[] servers;
    private static String host;
    private static int port;
    private static InetSocketAddress server;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServers(Collection<SocketAddress> servers) {
        this.writeLock.lock();
        try {
            this.servers = servers.toArray(new InetSocketAddress[servers.size()]);
            if (log.isTraceEnabled()) {
                log.trace((Object)("New server list is: " + Arrays.toString(this.servers)));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress nextServer() {
        this.readLock.lock();
        try {
            InetSocketAddress inetSocketAddress = server;
            return inetSocketAddress;
        }
        finally {
            this.readLock.unlock();
        }
    }

    static {
        port = 11222;
        host = System.getProperty("jbosstest.cluster.node0", "localhost");
        server = new InetSocketAddress(host, port);
        if (log.isDebugEnabled()) {
            log.trace((Object)("node0 server = " + server));
        }
    }
}

