/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.memcached;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.server.test.client.memcached.MemcachedClient;
import org.infinispan.server.test.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractSingleNodeMemcachedTest {
    static final String ENCODING = "UTF-8";
    static final String KEY_A = "a";
    static final String KEY_B = "b";
    static final String KEY_C = "c";
    MemcachedClient mc;

    protected abstract RemoteInfinispanServer getServer();

    @Before
    public void setUp() throws Exception {
        this.mc = new MemcachedClient(ENCODING, this.getServer().getMemcachedEndpoint().getInetAddress().getHostName(), this.getServer().getMemcachedEndpoint().getPort(), 10000);
        this.mc.delete(KEY_A);
        this.mc.delete(KEY_B);
        this.mc.delete(KEY_C);
        Assert.assertNull((Object)this.mc.get(KEY_A));
        Assert.assertNull((Object)this.mc.get(KEY_B));
        Assert.assertNull((Object)this.mc.get(KEY_C));
    }

    @After
    public void tearDown() throws Exception {
        this.mc.delete(KEY_A);
        this.mc.delete(KEY_B);
        this.mc.delete(KEY_C);
        this.mc.close();
    }

    @Test
    public void testSetGet() throws Exception {
        this.mc.set(KEY_A, "A");
        Assert.assertEquals((Object)"A", (Object)this.mc.get(KEY_A));
    }

    @Test
    public void testSetGetNewLineChars() throws Exception {
        this.mc.set(KEY_A, "A\r\nA");
        Assert.assertEquals((Object)"A\r\nA", (Object)this.mc.get(KEY_A));
    }

    @Test
    public void testSetGetObject() throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(new TestSerializable("CONTENT"));
        oo.flush();
        byte[] byteData = bout.toByteArray();
        this.mc.writeln("set a 0 0 " + byteData.length);
        this.mc.flush();
        this.mc.write(byteData);
        this.mc.write("\r\n".getBytes(ENCODING));
        this.mc.flush();
        Assert.assertEquals((Object)"STORED", (Object)this.mc.readln());
        byte[] bytesBack = this.mc.getBytes(KEY_A);
        Assert.assertEquals((long)byteData.length, (long)bytesBack.length);
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytesBack));
        TestSerializable ts = (TestSerializable)oin.readObject();
        Assert.assertEquals((Object)"CONTENT", (Object)ts.getContent());
    }

    @Test
    public void testSetGetFlags() throws Exception {
        this.mc.writeln("set a 1234 0 1");
        this.mc.writeln("A");
        this.mc.flush();
        Assert.assertEquals((Object)"STORED", (Object)this.mc.readln());
        this.mc.writeln("get a");
        this.mc.flush();
        Assert.assertEquals((Object)"VALUE a 1234 1", (Object)this.mc.readln());
        Assert.assertEquals((Object)"A", (Object)this.mc.readln());
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testSecondSet() throws Exception {
        this.mc.set(KEY_A, "A");
        Assert.assertEquals((Object)"A", (Object)this.mc.get(KEY_A));
        this.mc.set(KEY_A, "B");
        Assert.assertEquals((Object)"B", (Object)this.mc.get(KEY_A));
    }

    @Test
    public void testGetMultipleKeys() throws Exception {
        this.mc.set(KEY_A, "A");
        this.mc.set(KEY_B, "B");
        this.mc.writeln("get a b");
        this.mc.flush();
        Assert.assertEquals((Object)"VALUE a 0 1", (Object)this.mc.readln());
        Assert.assertEquals((Object)"A", (Object)this.mc.readln());
        Assert.assertEquals((Object)"VALUE b 0 1", (Object)this.mc.readln());
        Assert.assertEquals((Object)"B", (Object)this.mc.readln());
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testAdd() throws Exception {
        String data = "testAdd";
        this.mc.writeln("add a 0 0 " + data.getBytes(ENCODING).length);
        this.mc.writeln(data);
        this.mc.flush();
        Assert.assertEquals((Object)"STORED", (Object)this.mc.readln());
        Assert.assertEquals((Object)data, (Object)this.mc.get(KEY_A));
        this.mc.writeln("add a 0 0 " + data.getBytes(ENCODING).length);
        this.mc.writeln(data);
        this.mc.flush();
        Assert.assertEquals((Object)"NOT_STORED", (Object)this.mc.readln());
    }

    @Test
    public void testReplace() throws Exception {
        this.mc.set(KEY_A, "testAdd");
        Assert.assertEquals((Object)"testAdd", (Object)this.mc.get(KEY_A));
        this.mc.writeln("replace a 0 0 " + "replacement".getBytes(ENCODING).length);
        this.mc.writeln("replacement");
        this.mc.flush();
        Assert.assertEquals((Object)"STORED", (Object)this.mc.readln());
        Assert.assertEquals((Object)"replacement", (Object)this.mc.get(KEY_A));
    }

    @Test
    public void testReplaceNonExistent() throws Exception {
        this.mc.writeln("replace a 0 0 " + "replacement".getBytes(ENCODING).length);
        this.mc.writeln("replacement");
        this.mc.flush();
        Assert.assertEquals((Object)"NOT_STORED", (Object)this.mc.readln());
    }

    @Test
    public void testAppend() throws Exception {
        this.mc.set(KEY_A, "Hello");
        Assert.assertEquals((Object)"Hello", (Object)this.mc.get(KEY_A));
        this.mc.writeln("append a 0 0 " + ", World!".getBytes(ENCODING).length);
        this.mc.writeln(", World!");
        this.mc.flush();
        Assert.assertEquals((Object)"STORED", (Object)this.mc.readln());
        Assert.assertEquals((Object)"Hello, World!", (Object)this.mc.get(KEY_A));
    }

    @Test
    public void testAppendNonExistent() throws Exception {
        this.mc.writeln("append a 0 0 " + ", World!".getBytes(ENCODING).length);
        this.mc.writeln(", World!");
        this.mc.flush();
        Assert.assertEquals((Object)"NOT_STORED", (Object)this.mc.readln());
    }

    @Test
    public void testPrepend() throws Exception {
        this.mc.set(KEY_A, "World!");
        Assert.assertEquals((Object)"World!", (Object)this.mc.get(KEY_A));
        this.mc.writeln("prepend a 0 0 " + "Hello, ".getBytes(ENCODING).length);
        this.mc.writeln("Hello, ");
        this.mc.flush();
        Assert.assertEquals((Object)"STORED", (Object)this.mc.readln());
        Assert.assertEquals((Object)"Hello, World!", (Object)this.mc.get(KEY_A));
    }

    @Test
    public void testPrependNonExistent() throws Exception {
        this.mc.writeln("prepend a 0 0 " + "Hello, ".getBytes(ENCODING).length);
        this.mc.writeln("Hello, ");
        this.mc.flush();
        Assert.assertEquals((Object)"NOT_STORED", (Object)this.mc.readln());
    }

    @Test
    public void testCas() throws Exception {
        this.mc.set(KEY_A, "A");
        this.mc.writeln("gets a");
        this.mc.flush();
        String[] valueline = this.mc.readln().split(" ");
        Assert.assertEquals((Object)"VALUE", (Object)valueline[0]);
        Assert.assertEquals((Object)KEY_A, (Object)valueline[1]);
        Assert.assertEquals((Object)"0", (Object)valueline[2]);
        Assert.assertEquals((Object)"1", (Object)valueline[3]);
        Assert.assertEquals((Object)"A", (Object)this.mc.readln());
        String casId = valueline[4];
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
        this.mc.writeln("cas a 0 0 1 " + casId);
        this.mc.writeln("B");
        this.mc.flush();
        Assert.assertEquals((Object)"STORED", (Object)this.mc.readln());
        Assert.assertEquals((Object)"B", (Object)this.mc.get(KEY_A));
        this.mc.writeln("gets a");
        this.mc.flush();
        valueline = this.mc.readln().split(" ");
        Assert.assertFalse((boolean)casId.equals(valueline[4]));
        Assert.assertEquals((Object)"B", (Object)this.mc.readln());
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testCasExists() throws Exception {
        this.mc.set(KEY_A, "A");
        this.mc.writeln("gets a");
        this.mc.flush();
        String[] valueline = this.mc.readln().split(" ");
        Assert.assertEquals((Object)"VALUE", (Object)valueline[0]);
        Assert.assertEquals((Object)KEY_A, (Object)valueline[1]);
        Assert.assertEquals((Object)"0", (Object)valueline[2]);
        Assert.assertEquals((Object)"1", (Object)valueline[3]);
        Assert.assertEquals((Object)"A", (Object)this.mc.readln());
        String casId = valueline[4];
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
        this.mc.writeln("cas a 0 0 1 1" + casId);
        this.mc.writeln("B");
        this.mc.flush();
        Assert.assertEquals((Object)"EXISTS", (Object)this.mc.readln());
        Assert.assertEquals((Object)"A", (Object)this.mc.get(KEY_A));
    }

    @Test
    public void testGetNotFound() throws Exception {
        this.mc.writeln("get a");
        this.mc.flush();
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testCasNotFound() throws Exception {
        this.mc.writeln("cas a 0 0 1 1");
        this.mc.writeln("B");
        this.mc.flush();
        Assert.assertEquals((Object)"NOT_FOUND", (Object)this.mc.readln());
    }

    @Test
    public void testExpTime() throws Exception {
        this.mc.writeln("set a 0 2 1");
        this.mc.writeln("A");
        this.mc.flush();
        Assert.assertEquals((Object)"STORED", (Object)this.mc.readln());
        Assert.assertEquals((Object)"A", (Object)this.mc.get(KEY_A));
        Thread.sleep(2500L);
        Assert.assertNull((Object)this.mc.get(KEY_A));
    }

    @Test
    public void testExpTimeMaxSeconds() throws Exception {
        this.mc.writeln("set a 0 2592000 1");
        this.mc.writeln("A");
        this.mc.flush();
        Assert.assertEquals((Object)"STORED", (Object)this.mc.readln());
        Assert.assertEquals((Object)"A", (Object)this.mc.get(KEY_A));
        Thread.sleep(2000L);
        Assert.assertEquals((Object)"A", (Object)this.mc.get(KEY_A));
    }

    @Test
    public void testExpTimeAbsolutePast() throws Exception {
        this.mc.writeln("set a 0 2592001 1");
        this.mc.writeln("A");
        this.mc.flush();
        Assert.assertEquals((Object)"STORED", (Object)this.mc.readln());
        Thread.sleep(5L);
        Assert.assertNull((Object)this.mc.get(KEY_A));
    }

    @Test
    public void testExpTimeAbsoluteFuture() throws Exception {
        long now = this.mc.getServerTime();
        System.out.println("server time: " + now);
        this.mc.writeln("set a 0 " + (now + 2L) + " 1");
        this.mc.writeln("A");
        this.mc.flush();
        Assert.assertEquals((Object)"STORED", (Object)this.mc.readln());
        Assert.assertEquals((Object)"A", (Object)this.mc.get(KEY_A));
        Thread.sleep(2000L);
        Assert.assertNull((Object)this.mc.get(KEY_A));
    }

    private String key250() {
        String key250 = "";
        for (int i = 0; i < 250; ++i) {
            key250 = key250 + KEY_A;
        }
        return key250;
    }

    @Test
    public void testKeyLonger250() throws Exception {
        String key250 = this.key250();
        this.mc.delete(key250);
        String key251 = key250 + KEY_A;
        Assert.assertEquals((long)key250.length(), (long)key250.getBytes(ENCODING).length);
        Assert.assertEquals((long)key251.length(), (long)key251.getBytes(ENCODING).length);
        this.mc.set(key250, "A");
        Assert.assertEquals((Object)"A", (Object)this.mc.get(key250));
        this.mc.writeln("set " + key251 + " 0 0 1");
        this.mc.flush();
        this.assertStartsWith(this.mc.readln(), "CLIENT_ERROR");
    }

    @Test
    public void testKeyLonger250Get() throws Exception {
        this.mc.writeln("get " + this.key250() + KEY_A);
        this.mc.flush();
        this.assertStartsWith(this.mc.readln(), "CLIENT_ERROR");
    }

    @Test
    public void testKeyLonger250Gets() throws Exception {
        this.mc.writeln("gets " + this.key250() + KEY_A);
        this.mc.flush();
        this.assertStartsWith(this.mc.readln(), "CLIENT_ERROR");
    }

    @Test
    public void testKeyLonger250Multiget() throws Exception {
        String key250 = this.key250();
        String key251 = key250 + KEY_A;
        Assert.assertEquals((long)key250.length(), (long)key250.getBytes(ENCODING).length);
        Assert.assertEquals((long)key251.length(), (long)key251.getBytes(ENCODING).length);
        this.mc.set(key250, "A");
        Assert.assertEquals((Object)"A", (Object)this.mc.get(key250));
        this.mc.writeln("get " + key250 + " " + key251);
        this.mc.flush();
        this.assertStartsWith(this.mc.readln(), "CLIENT_ERROR");
        Assert.assertEquals((Object)"DELETED", (Object)this.mc.delete(key250));
    }

    @Test
    public void testKeyLonger250Add() throws Exception {
        String key250 = this.key250();
        this.mc.delete(key250);
        String key251 = key250 + KEY_A;
        Assert.assertEquals((long)key250.length(), (long)key250.getBytes(ENCODING).length);
        Assert.assertEquals((long)key251.length(), (long)key251.getBytes(ENCODING).length);
        this.mc.writeln("add " + key250 + " 0 0 1");
        this.mc.writeln("A");
        this.mc.flush();
        Assert.assertEquals((Object)"STORED", (Object)this.mc.readln());
        Assert.assertEquals((Object)"A", (Object)this.mc.get(key250));
        this.mc.writeln("add " + key251 + " 0 0 1");
        this.mc.flush();
        this.assertStartsWith(this.mc.readln(), "CLIENT_ERROR");
    }

    @Test
    public void testKeyLonger250Replace() throws Exception {
        this.mc.writeln("replace " + this.key250() + "a 0 0 1");
        this.mc.flush();
        this.assertStartsWith(this.mc.readln(), "CLIENT_ERROR");
    }

    @Test
    public void testKeyLonger250Append() throws Exception {
        this.mc.writeln("append " + this.key250() + "a 0 0 1");
        this.mc.flush();
        this.assertStartsWith(this.mc.readln(), "CLIENT_ERROR");
    }

    @Test
    public void testKeyLonger250Prepend() throws Exception {
        this.mc.writeln("prepend " + this.key250() + "a 0 0 1");
        this.mc.flush();
        this.assertStartsWith(this.mc.readln(), "CLIENT_ERROR");
    }

    @Test
    public void testKeyLonger250Cas() throws Exception {
        this.mc.writeln("prepend " + this.key250() + "a 0 0 1 1");
        this.mc.flush();
        this.assertStartsWith(this.mc.readln(), "CLIENT_ERROR");
    }

    @Test
    public void testKeyLonger250Incr() throws Exception {
        this.mc.writeln("incr " + this.key250() + "a 1");
        this.mc.flush();
        this.assertStartsWith(this.mc.readln(), "CLIENT_ERROR");
    }

    @Test
    public void testKeyLonger250Decr() throws Exception {
        this.mc.writeln("decr " + this.key250() + "a 1");
        this.mc.flush();
        this.assertStartsWith(this.mc.readln(), "CLIENT_ERROR");
    }

    @Test
    public void testKeyLonger250Delete() throws Exception {
        this.mc.writeln("delete " + this.key250() + KEY_A);
        this.mc.flush();
        this.assertStartsWith(this.mc.readln(), "CLIENT_ERROR");
    }

    @Test
    public void testDelete() throws Exception {
        this.mc.set(KEY_A, "A");
        Assert.assertEquals((Object)"A", (Object)this.mc.get(KEY_A));
        Assert.assertEquals((Object)"DELETED", (Object)this.mc.delete(KEY_A));
        Assert.assertNull((Object)this.mc.get(KEY_A));
    }

    @Test
    public void testDeleteNonExistent() throws Exception {
        Assert.assertEquals((Object)"NOT_FOUND", (Object)this.mc.delete(KEY_A));
    }

    @Test
    public void testIncr() throws Exception {
        this.mc.set(KEY_A, "0");
        this.mc.writeln("incr a 1");
        this.mc.flush();
        Assert.assertEquals((Object)"1", (Object)this.mc.readln());
    }

    @Test
    public void testDecr() throws Exception {
        this.mc.set(KEY_A, "1");
        this.mc.writeln("decr a 1");
        this.mc.flush();
        Assert.assertEquals((Object)"0", (Object)this.mc.readln());
    }

    @Test
    public void testIncrNotFound() throws Exception {
        this.mc.writeln("incr a 1");
        this.mc.flush();
        Assert.assertEquals((Object)"NOT_FOUND", (Object)this.mc.readln());
    }

    @Test
    public void testDecrNotFound() throws Exception {
        this.mc.writeln("decr a 1");
        this.mc.flush();
        Assert.assertEquals((Object)"NOT_FOUND", (Object)this.mc.readln());
    }

    @Test
    public void testIncr64BitMax() throws Exception {
        this.mc.set(KEY_A, "18446744073709551614");
        this.mc.writeln("incr a 1");
        this.mc.flush();
        Assert.assertEquals((Object)"18446744073709551615", (Object)this.mc.readln());
        this.mc.writeln("incr a 1");
        this.mc.flush();
        Assert.assertEquals((Object)"0", (Object)this.mc.readln());
    }

    @Test
    public void testDecrZero() throws Exception {
        this.mc.set(KEY_A, "0");
        this.mc.writeln("decr a 1");
        this.mc.flush();
        Assert.assertEquals((Object)"0", (Object)this.mc.readln());
    }

    @Test
    public void testIncrBigIncrement() throws Exception {
        this.mc.set(KEY_A, "0");
        this.mc.writeln("incr a 18446744073709551615");
        this.mc.flush();
        Assert.assertEquals((Object)"18446744073709551615", (Object)this.mc.readln());
    }

    @Test
    public void testIncrBigDecrement() throws Exception {
        this.mc.set(KEY_A, "18446744073709551615");
        this.mc.writeln("decr a 18446744073709551615");
        this.mc.flush();
        Assert.assertEquals((Object)"0", (Object)this.mc.readln());
    }

    @Test
    public void testUnsupportedStats() throws Exception {
        Map<String, String> stats = this.mc.getStats();
        Assert.assertEquals((Object)stats.get("pid"), (Object)"0");
        Assert.assertEquals((Object)stats.get("pointer_size"), (Object)"0");
        Assert.assertEquals((Object)stats.get("rusage_user"), (Object)"0");
        Assert.assertEquals((Object)stats.get("rusage_system"), (Object)"0");
        Assert.assertEquals((Object)stats.get("bytes"), (Object)"0");
        Assert.assertEquals((Object)stats.get("curr_connections"), (Object)"0");
        Assert.assertEquals((Object)stats.get("total_connections"), (Object)"0");
        Assert.assertEquals((Object)stats.get("connection_structures"), (Object)"0");
        Assert.assertEquals((Object)stats.get("auth_cmds"), (Object)"0");
        Assert.assertEquals((Object)stats.get("auth_errors"), (Object)"0");
        Assert.assertEquals((Object)stats.get("limit_maxbytes"), (Object)"0");
        Assert.assertEquals((Object)stats.get("conn_yields"), (Object)"0");
        Assert.assertEquals((Object)stats.get("threads"), (Object)"0");
    }

    @Test
    public void testStatsBytes() throws Exception {
        Map<String, String> stats = this.mc.getStats();
        int bytesRead = new Integer(stats.get("bytes_read"));
        int bytesWritten = new Integer(stats.get("bytes_written"));
        this.mc.set("testKey", "testValue");
        this.mc.get("testKey");
        this.mc.delete("testKey");
        stats = this.mc.getStats();
        Assert.assertTrue((String)"Bytes read didnt increase.", (bytesRead < Integer.parseInt(stats.get("bytes_read")) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Bytes written didnt increase.", (bytesWritten < Integer.parseInt(stats.get("bytes_written")) ? 1 : 0) != 0);
    }

    @Test
    public void testStatsTime() throws Exception {
        Map<String, String> stats = this.mc.getStats();
        int uptime = new Integer(stats.get("uptime"));
        int time = new Integer(stats.get("time"));
        Thread.sleep(1000L);
        stats = this.mc.getStats();
        Assert.assertTrue((uptime < new Integer(stats.get("uptime")) ? 1 : 0) != 0);
        Assert.assertTrue((time < new Integer(stats.get("time")) ? 1 : 0) != 0);
    }

    @Test
    public void testStatsVersion() throws Exception {
        Map<String, String> stats = this.mc.getStats();
        String version = stats.get("version");
        Assert.assertTrue((version != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)version.startsWith("6."));
    }

    @Test
    public void testStatsGetSetItemCount() throws Exception {
        Map<String, String> stats = this.mc.getStats();
        int cmd_set = new Integer(stats.get("cmd_set"));
        int cmd_get = new Integer(stats.get("cmd_get"));
        int get_hits = new Integer(stats.get("get_hits"));
        int get_misses = new Integer(stats.get("get_misses"));
        int curr_items = new Integer(stats.get("curr_items"));
        int total_items = new Integer(stats.get("total_items"));
        this.mc.set(KEY_A, "A");
        Assert.assertEquals((Object)"A", (Object)this.mc.get(KEY_A));
        Assert.assertNull((Object)this.mc.get(KEY_B));
        stats = this.mc.getStats();
        int cmd_set_new = new Integer(stats.get("cmd_set"));
        int cmd_get_new = new Integer(stats.get("cmd_get"));
        int get_hits_new = new Integer(stats.get("get_hits"));
        int get_misses_new = new Integer(stats.get("get_misses"));
        int curr_items_new = new Integer(stats.get("curr_items"));
        int total_items_new = new Integer(stats.get("total_items"));
        Assert.assertEquals((long)(cmd_get + 2), (long)cmd_get_new);
        Assert.assertEquals((long)(cmd_set + 1), (long)cmd_set_new);
        Assert.assertEquals((long)(get_hits + 1), (long)get_hits_new);
        Assert.assertEquals((long)(get_misses + 1), (long)get_misses_new);
        Assert.assertEquals((long)(curr_items + 1), (long)curr_items_new);
        Assert.assertEquals((long)(total_items + 1), (long)total_items_new);
    }

    @Test
    public void testStatsDelete() throws Exception {
        Map<String, String> stats = this.mc.getStats();
        int delete_misses = new Integer(stats.get("delete_misses"));
        int delete_hits = new Integer(stats.get("delete_hits"));
        this.mc.set(KEY_A, "A");
        Assert.assertEquals((Object)"DELETED", (Object)this.mc.delete(KEY_A));
        Assert.assertEquals((Object)"NOT_FOUND", (Object)this.mc.delete(KEY_B));
        stats = this.mc.getStats();
        int delete_misses_new = new Integer(stats.get("delete_misses"));
        int delete_hits_new = new Integer(stats.get("delete_hits"));
        Assert.assertEquals((long)(delete_misses + 1), (long)delete_misses_new);
        Assert.assertEquals((long)(delete_hits + 1), (long)delete_hits_new);
    }

    @Test
    public void testStatsIncrDecr() throws Exception {
        Map<String, String> stats = this.mc.getStats();
        int incr_misses = new Integer(stats.get("incr_misses"));
        int incr_hits = new Integer(stats.get("incr_hits"));
        int decr_misses = new Integer(stats.get("decr_misses"));
        int decr_hits = new Integer(stats.get("decr_hits"));
        this.mc.set(KEY_A, "0");
        this.mc.writeln("incr a 1");
        this.mc.flush();
        Assert.assertEquals((Object)"1", (Object)this.mc.readln());
        this.mc.writeln("decr a 1");
        this.mc.flush();
        Assert.assertEquals((Object)"0", (Object)this.mc.readln());
        this.mc.writeln("incr b 1");
        this.mc.flush();
        Assert.assertEquals((Object)"NOT_FOUND", (Object)this.mc.readln());
        this.mc.writeln("decr b 1");
        this.mc.flush();
        Assert.assertEquals((Object)"NOT_FOUND", (Object)this.mc.readln());
        stats = this.mc.getStats();
        int incr_misses_new = new Integer(stats.get("incr_misses"));
        int incr_hits_new = new Integer(stats.get("incr_hits"));
        int decr_misses_new = new Integer(stats.get("decr_misses"));
        int decr_hits_new = new Integer(stats.get("decr_hits"));
        Assert.assertEquals((long)(incr_misses + 1), (long)incr_misses_new);
        Assert.assertEquals((long)(incr_hits + 1), (long)incr_hits_new);
        Assert.assertEquals((long)(decr_misses + 1), (long)decr_misses_new);
        Assert.assertEquals((long)(decr_hits + 1), (long)decr_hits_new);
    }

    @Test
    public void testStatsCas() throws Exception {
        Map<String, String> stats = this.mc.getStats();
        int cas_misses = new Integer(stats.get("cas_misses"));
        int cas_hits = new Integer(stats.get("cas_hits"));
        this.mc.set(KEY_A, "A");
        this.mc.writeln("gets a");
        this.mc.flush();
        String[] valueline = this.mc.readln().split(" ");
        Assert.assertEquals((Object)"VALUE", (Object)valueline[0]);
        Assert.assertEquals((Object)KEY_A, (Object)valueline[1]);
        Assert.assertEquals((Object)"0", (Object)valueline[2]);
        Assert.assertEquals((Object)"1", (Object)valueline[3]);
        Assert.assertEquals((Object)"A", (Object)this.mc.readln());
        String casId = valueline[4];
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
        this.mc.writeln("cas a 0 0 1 " + casId);
        this.mc.writeln("B");
        this.mc.flush();
        Assert.assertEquals((Object)"STORED", (Object)this.mc.readln());
        Assert.assertEquals((Object)"B", (Object)this.mc.get(KEY_A));
        this.mc.writeln("cas b 0 0 1 1");
        this.mc.writeln("B");
        this.mc.flush();
        Assert.assertEquals((Object)"NOT_FOUND", (Object)this.mc.readln());
        stats = this.mc.getStats();
        int cas_misses_new = new Integer(stats.get("cas_misses"));
        int cas_hits_new = new Integer(stats.get("cas_hits"));
        Assert.assertEquals((long)(cas_misses + 1), (long)cas_misses_new);
        Assert.assertEquals((long)(cas_hits + 1), (long)cas_hits_new);
        int cas_badval = new Integer(stats.get("cas_badval"));
        this.mc.writeln("cas a 0 0 1 1" + casId);
        this.mc.writeln("C");
        this.mc.flush();
        Assert.assertEquals((Object)"EXISTS", (Object)this.mc.readln());
        stats = this.mc.getStats();
        int cas_badval_new = new Integer(stats.get("cas_badval"));
        Assert.assertEquals((long)(cas_badval + 1), (long)cas_badval_new);
    }

    @Test
    public void testBogusCommand() throws Exception {
        this.mc.writeln("boguscommand");
        this.mc.flush();
        this.assertStartsWith(this.mc.readln(), "ERROR");
    }

    @Test
    public void testBogusCommandArgs() throws Exception {
        this.mc.writeln("boguscommand arg1 arg2 arg3");
        this.mc.flush();
        this.assertStartsWith(this.mc.readln(), "ERROR");
    }

    @Test
    public void testBogusCommandPipeline() throws Exception {
        this.mc.writeln("boguscommand");
        this.mc.writeln("delete a");
        this.mc.flush();
        this.assertStartsWith(this.mc.readln(), "ERROR");
        Assert.assertEquals((Object)"NOT_FOUND", (Object)this.mc.readln());
    }

    @Test
    public void testCasParsing1() throws Exception {
        this.mc.writeln("cas bad blah 0 0 0");
        this.mc.flush();
        this.assertStartsWith(this.mc.readln(), "CLIENT_ERROR");
    }

    @Test
    public void testCasParsing2() throws Exception {
        this.mc.writeln("cas bad 0 blah 0 0");
        this.mc.flush();
        this.assertStartsWith(this.mc.readln(), "CLIENT_ERROR");
    }

    @Test
    public void testCasParsing3() throws Exception {
        this.mc.writeln("cas bad 0 0 blah 0");
        this.mc.flush();
        this.assertStartsWith(this.mc.readln(), "CLIENT_ERROR");
    }

    @Test
    public void testCasParsing4() throws Exception {
        this.mc.writeln("cas bad 0 0 0 blah");
        this.mc.flush();
        this.assertStartsWith(this.mc.readln(), "CLIENT_ERROR");
    }

    @Test
    public void testCasParsing6() throws Exception {
        this.mc.writeln("cas bad 0 0 6");
        this.mc.flush();
        this.assertStartsWith(this.mc.readln(), "SERVER_ERROR");
    }

    @Test
    public void testCasUniqueIs64Bit() throws Exception {
        this.mc.writeln("cas a 0 0 1 9223372036854775807");
        this.mc.writeln(KEY_A);
        this.mc.flush();
        Assert.assertEquals((Object)"NOT_FOUND", (Object)this.mc.readln());
        this.mc.writeln("cas a 0 0 1 -9223372036854775808");
        this.mc.writeln(KEY_A);
        this.mc.flush();
        Assert.assertEquals((Object)"NOT_FOUND", (Object)this.mc.readln());
    }

    @Test
    public void testSetFlagsRange() throws Exception {
        this.mc.writeln("set a 0 0 1");
        this.mc.writeln(KEY_A);
        this.mc.flush();
        Assert.assertEquals((Object)"STORED", (Object)this.mc.readln());
        this.mc.writeln("set a 4294967295 0 1");
        this.mc.writeln(KEY_A);
        this.mc.flush();
        Assert.assertEquals((Object)"STORED", (Object)this.mc.readln());
        this.mc.writeln("set a -1 0 1");
        this.mc.flush();
        this.assertStartsWith(this.mc.readln(), "CLIENT_ERROR");
        this.mc.writeln("set a 4294967296 0 1");
        this.mc.flush();
        this.assertStartsWith(this.mc.readln(), "CLIENT_ERROR");
    }

    @Test
    public void testVerbosityUnsupported() throws Exception {
        this.mc.writeln("verbosity 0");
        this.mc.flush();
        this.assertStartsWith(this.mc.readln(), "CLIENT_ERROR");
    }

    @Test
    public void testQuit() throws Exception {
        this.mc.writeln("quit");
        this.mc.flush();
        Assert.assertEquals((Object)"", (Object)this.mc.readln());
    }

    @Test
    public void testFlushAll() throws Exception {
        this.mc.set(KEY_A, "valA");
        this.mc.set(KEY_B, "valB");
        this.mc.set(KEY_C, "valC");
        Assert.assertEquals((Object)"valA", (Object)this.mc.get(KEY_A));
        Assert.assertEquals((Object)"valB", (Object)this.mc.get(KEY_B));
        Assert.assertEquals((Object)"valC", (Object)this.mc.get(KEY_C));
        this.mc.writeln("flush_all");
        this.mc.flush();
        Assert.assertEquals((Object)"OK", (Object)this.mc.readln());
        Assert.assertNull((Object)this.mc.get(KEY_A));
        Assert.assertNull((Object)this.mc.get(KEY_B));
        Assert.assertNull((Object)this.mc.get(KEY_C));
    }

    @Test
    public void testFlushAllDelayed() throws Exception {
        this.mc.set(KEY_A, "valA");
        this.mc.set(KEY_B, "valB");
        this.mc.set(KEY_C, "valC");
        Assert.assertEquals((Object)"valA", (Object)this.mc.get(KEY_A));
        Assert.assertEquals((Object)"valB", (Object)this.mc.get(KEY_B));
        Assert.assertEquals((Object)"valC", (Object)this.mc.get(KEY_C));
        this.mc.writeln("flush_all 1");
        this.mc.flush();
        Assert.assertEquals((Object)"OK", (Object)this.mc.readln());
        Assert.assertEquals((Object)"valA", (Object)this.mc.get(KEY_A));
        Assert.assertEquals((Object)"valB", (Object)this.mc.get(KEY_B));
        Assert.assertEquals((Object)"valC", (Object)this.mc.get(KEY_C));
        TestUtil.eventually(new TestUtil.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return AbstractSingleNodeMemcachedTest.this.mc.get(AbstractSingleNodeMemcachedTest.KEY_A) == null && AbstractSingleNodeMemcachedTest.this.mc.get(AbstractSingleNodeMemcachedTest.KEY_B) == null && AbstractSingleNodeMemcachedTest.this.mc.get(AbstractSingleNodeMemcachedTest.KEY_C) == null;
            }
        }, 20000L, 40);
    }

    @Test
    public void testFlushAllDelayedUnixTime() throws Exception {
        this.mc.set(KEY_A, "valA");
        this.mc.set(KEY_B, "valB");
        this.mc.set(KEY_C, "valC");
        Assert.assertEquals((Object)"valA", (Object)this.mc.get(KEY_A));
        Assert.assertEquals((Object)"valB", (Object)this.mc.get(KEY_B));
        Assert.assertEquals((Object)"valC", (Object)this.mc.get(KEY_C));
        long t = this.mc.getServerTime();
        Assert.assertTrue((t > 0L ? 1 : 0) != 0);
        this.mc.writeln("flush_all " + (t + 2L));
        this.mc.flush();
        Assert.assertEquals((Object)"OK", (Object)this.mc.readln());
        Assert.assertEquals((Object)"valA", (Object)this.mc.get(KEY_A));
        Assert.assertEquals((Object)"valB", (Object)this.mc.get(KEY_B));
        Assert.assertEquals((Object)"valC", (Object)this.mc.get(KEY_C));
        TestUtil.eventually(new TestUtil.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return AbstractSingleNodeMemcachedTest.this.mc.get(AbstractSingleNodeMemcachedTest.KEY_A) == null && AbstractSingleNodeMemcachedTest.this.mc.get(AbstractSingleNodeMemcachedTest.KEY_B) == null && AbstractSingleNodeMemcachedTest.this.mc.get(AbstractSingleNodeMemcachedTest.KEY_C) == null;
            }
        }, 20000L, 40);
    }

    @Test
    public void testPipeliningSet() throws Exception {
        this.mc.writeln("set a 0 0 1");
        this.mc.writeln(KEY_A);
        this.mc.writeln("get b");
        this.mc.flush();
        Assert.assertEquals((Object)"STORED", (Object)this.mc.readln());
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testPipeliningAdd() throws Exception {
        this.mc.writeln("add a 0 0 1");
        this.mc.writeln(KEY_A);
        this.mc.writeln("get b");
        this.mc.flush();
        Assert.assertEquals((Object)"STORED", (Object)this.mc.readln());
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testPipeliningReplace() throws Exception {
        this.mc.set(KEY_A, KEY_B);
        this.mc.writeln("replace a 0 0 1");
        this.mc.writeln(KEY_A);
        this.mc.writeln("get b");
        this.mc.flush();
        Assert.assertEquals((Object)"STORED", (Object)this.mc.readln());
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testPipeliningAppend() throws Exception {
        this.mc.set(KEY_A, KEY_A);
        this.mc.writeln("append a 0 0 1");
        this.mc.writeln(KEY_A);
        this.mc.writeln("get b");
        this.mc.flush();
        Assert.assertEquals((Object)"STORED", (Object)this.mc.readln());
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testPipeliningPrepend() throws Exception {
        this.mc.set(KEY_A, KEY_A);
        this.mc.writeln("prepend a 0 0 1");
        this.mc.writeln(KEY_A);
        this.mc.writeln("get b");
        this.mc.flush();
        Assert.assertEquals((Object)"STORED", (Object)this.mc.readln());
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testPipeliningCas() throws Exception {
        this.mc.writeln("cas a 0 0 1 0");
        this.mc.writeln(KEY_A);
        this.mc.writeln("get b");
        this.mc.flush();
        Assert.assertEquals((Object)"NOT_FOUND", (Object)this.mc.readln());
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testPipeliningGet() throws Exception {
        this.mc.writeln("get a");
        this.mc.writeln("get b");
        this.mc.flush();
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testPipeliningGetMulti() throws Exception {
        this.mc.writeln("get a c");
        this.mc.writeln("get b");
        this.mc.flush();
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testPipeliningGets() throws Exception {
        this.mc.writeln("gets a");
        this.mc.writeln("get b");
        this.mc.flush();
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testPipeliningGetsMulti() throws Exception {
        this.mc.writeln("gets a c");
        this.mc.writeln("get b");
        this.mc.flush();
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testPipeliningDelete() throws Exception {
        this.mc.writeln("delete a");
        this.mc.writeln("get b");
        this.mc.flush();
        Assert.assertEquals((Object)"NOT_FOUND", (Object)this.mc.readln());
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testPipeliningIncr() throws Exception {
        this.mc.set(KEY_A, "1");
        this.mc.writeln("incr a 1");
        this.mc.writeln("get b");
        this.mc.flush();
        Assert.assertEquals((Object)"2", (Object)this.mc.readln());
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testPipeliningDecr() throws Exception {
        this.mc.set(KEY_A, "2");
        this.mc.writeln("decr a 1");
        this.mc.writeln("get b");
        this.mc.flush();
        Assert.assertEquals((Object)"1", (Object)this.mc.readln());
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testPipeliningStats() throws Exception {
        this.mc.writeln("stats");
        this.mc.writeln("get b");
        this.mc.flush();
        String line = null;
        while (!(line = this.mc.readln()).equals("END")) {
        }
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testPipeliningVersion() throws Exception {
        this.mc.writeln("version");
        this.mc.writeln("get b");
        this.mc.flush();
        Assert.assertNotNull((Object)this.mc.readln());
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testPipeliningVerbosity() throws Exception {
        this.mc.writeln("verbosity 0");
        this.mc.writeln("get b");
        this.mc.flush();
        this.assertStartsWith(this.mc.readln(), "CLIENT_ERROR");
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testPipeliningFlushAll() throws Exception {
        this.mc.writeln("flush_all");
        this.mc.writeln("get b");
        this.mc.flush();
        Assert.assertEquals((Object)"OK", (Object)this.mc.readln());
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testPipeliningFlushAllDelayed() throws Exception {
        this.mc.writeln("flush_all 1");
        this.mc.writeln("get b");
        this.mc.flush();
        Assert.assertEquals((Object)"OK", (Object)this.mc.readln());
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
        this.mc.set(KEY_A, "thisWillBeFlushed");
        Assert.assertEquals((Object)"thisWillBeFlushed", (Object)this.mc.get(KEY_A));
        TestUtil.eventually(new TestUtil.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return AbstractSingleNodeMemcachedTest.this.mc.get(AbstractSingleNodeMemcachedTest.KEY_A) == null;
            }
        }, 20000L, 40);
    }

    @Test
    public void testStatsArgs() throws Exception {
        this.mc.writeln("stats args");
        this.mc.flush();
        this.assertStartsWith(this.mc.readln(), "CLIENT_ERROR");
    }

    @Test
    public void testNegativeItemSize() throws Exception {
        this.mc.writeln("set a 0 0 -1");
        this.mc.flush();
        this.assertStartsWith(this.mc.readln(), "CLIENT_ERROR");
    }

    @Test
    public void testNoReplySet() throws Exception {
        this.mc.writeln("set a 0 0 1 noreply");
        this.mc.writeln(KEY_A);
        this.mc.writeln("get b");
        this.mc.flush();
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testNoReplyAdd() throws Exception {
        this.mc.writeln("add a 0 0 1 noreply");
        this.mc.writeln(KEY_A);
        this.mc.writeln("get b");
        this.mc.flush();
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testNoReplyReplace() throws Exception {
        this.mc.set(KEY_A, KEY_B);
        this.mc.writeln("replace a 0 0 1 noreply");
        this.mc.writeln(KEY_A);
        this.mc.writeln("get b");
        this.mc.flush();
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testNoReplyAppend() throws Exception {
        this.mc.set(KEY_A, KEY_A);
        this.mc.writeln("append a 0 0 1 noreply");
        this.mc.writeln(KEY_A);
        this.mc.writeln("get b");
        this.mc.flush();
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testNoReplyPrepend() throws Exception {
        this.mc.set(KEY_A, KEY_A);
        this.mc.writeln("prepend a 0 0 1 noreply");
        this.mc.writeln(KEY_A);
        this.mc.writeln("get b");
        this.mc.flush();
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testNoReplyCas() throws Exception {
        this.mc.writeln("cas a 0 0 1 0 noreply");
        this.mc.writeln(KEY_A);
        this.mc.writeln("get b");
        this.mc.flush();
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testNoReplyDelete() throws Exception {
        this.mc.writeln("delete a noreply");
        this.mc.writeln("get b");
        this.mc.flush();
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testNoReplyIncr() throws Exception {
        this.mc.set(KEY_A, "1");
        this.mc.writeln("incr a 1 noreply");
        this.mc.writeln("get b");
        this.mc.flush();
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testNoReplyDecr() throws Exception {
        this.mc.set(KEY_A, "2");
        this.mc.writeln("decr a 1 noreply");
        this.mc.writeln("get b");
        this.mc.flush();
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testNoReplyFlushAll() throws Exception {
        this.mc.writeln("flush_all noreply");
        this.mc.writeln("get b");
        this.mc.flush();
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
    }

    @Test
    public void testNoReplyFlushAllDelayed() throws Exception {
        this.mc.writeln("flush_all 1 noreply");
        this.mc.writeln("get b");
        this.mc.flush();
        Assert.assertEquals((Object)"END", (Object)this.mc.readln());
        this.mc.set(KEY_A, "thisWillBeFlushed");
        Assert.assertEquals((Object)"thisWillBeFlushed", (Object)this.mc.get(KEY_A));
        TestUtil.eventually(new TestUtil.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return AbstractSingleNodeMemcachedTest.this.mc.get(AbstractSingleNodeMemcachedTest.KEY_A) == null;
            }
        }, 20000L, 40);
    }

    private void assertStartsWith(String str, String prefix) {
        Assert.assertTrue((String)("String \"" + str + "\" doesn't start with expected prefix \"" + prefix + "\""), (boolean)str.startsWith(prefix));
    }

    public static class TestSerializable
    implements Serializable {
        private String content;

        public TestSerializable(String content) {
            this.content = content;
        }

        public String getContent() {
            return this.content;
        }
    }
}

