/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.util;

import java.io.File;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.server.test.util.RemoteInfinispanMBeans;
import org.junit.Assert;

public class TestUtil {
    public static final String SERVER_DATA_DIR = System.getProperty("server1.dist") + File.separator + "standalone" + File.separator + "data";
    public static final String SERVER_CONFIG_DIR = System.getProperty("server1.dist") + File.separator + "standalone" + File.separator + "configuration";

    public static RemoteCacheManager createCacheManager(RemoteInfinispanServer server) {
        return new RemoteCacheManager(TestUtil.createConfigBuilder(server.getHotrodEndpoint().getInetAddress().getHostName(), server.getHotrodEndpoint().getPort()).build());
    }

    public static ConfigurationBuilder createConfigBuilder(String hostName, int port) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host(hostName).port(port);
        return builder;
    }

    public static RemoteCacheManager createCacheManager(RemoteInfinispanMBeans serverBeans) {
        return TestUtil.createCacheManager(serverBeans.server);
    }

    public static void eventually(Condition ec, long timeout) {
        TestUtil.eventually(ec, timeout, 10);
    }

    public static void eventually(Condition ec, long timeout, int loops) {
        if (loops <= 0) {
            throw new IllegalArgumentException("Number of loops must be positive");
        }
        long sleepDuration = timeout / (long)loops;
        if (sleepDuration == 0L) {
            sleepDuration = 1L;
        }
        try {
            for (int i = 0; i < loops; ++i) {
                if (ec.isSatisfied()) {
                    return;
                }
                Thread.sleep(sleepDuration);
            }
            Assert.assertTrue((boolean)ec.isSatisfied());
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected!", e);
        }
    }

    public static interface Condition {
        public boolean isSatisfied() throws Exception;
    }
}

