/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.asymmetric;

import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.server.test.client.memcached.MemcachedClient;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@WithRunningServer(value={"asymmetric-cluster-1", "asymmetric-cluster-2"})
public class AsymmetricClusterTest {
    @InfinispanResource(value="asymmetric-cluster-1")
    RemoteInfinispanServer server1;
    @InfinispanResource(value="asymmetric-cluster-2")
    RemoteInfinispanServer server2;
    MemcachedClient mc;
    MemcachedClient mc2;
    RemoteCache<String, String> hrCache;

    @Test
    public void testBasicOperations() throws Exception {
        Configuration conf = new ConfigurationBuilder().addServers(this.server1.getHotrodEndpoint().getInetAddress().getHostName() + ":" + this.server1.getHotrodEndpoint().getPort()).build();
        RemoteCacheManager rcm = new RemoteCacheManager(conf);
        this.hrCache = rcm.getCache();
        this.mc = new MemcachedClient(this.server1.getMemcachedEndpoint().getInetAddress().getHostName(), this.server1.getMemcachedEndpoint().getPort());
        this.mc2 = new MemcachedClient(this.server2.getMemcachedEndpoint().getInetAddress().getHostName(), this.server2.getMemcachedEndpoint().getPort());
        this.mc.set("k1", "v1");
        Assert.assertEquals((Object)"v1", (Object)this.mc.get("k1"));
        Assert.assertEquals((Object)"v1", (Object)this.mc2.get("k1"));
        this.hrCache.put((Object)"k2", (Object)"v2");
        Assert.assertEquals((Object)"v2", (Object)this.hrCache.get((Object)"k2"));
    }
}

