/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.hotrod;

import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.List;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ServerConfiguration;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.impl.operations.OperationsFactory;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.client.hotrod.impl.transport.tcp.RequestBalancingStrategy;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransport;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractRemoteCacheManagerTest {
    private final String TEST_CACHE_NAME = "testcache";
    static final String DEFAULT_CLUSTERING_MODE = "dist";
    protected static final String DEFAULT_NAMED_CACHE = "namedCache";

    protected abstract List<RemoteInfinispanServer> getServers();

    private ConfigurationBuilder createRemoteCacheManagerConfigurationBuilder() {
        ConfigurationBuilder config = new ConfigurationBuilder();
        this.addServers(config);
        config.balancingStrategy("org.infinispan.server.test.client.hotrod.HotRodTestRequestBalancingStrategy").forceReturnValues(true).tcpNoDelay(false).pingOnStartup(false).transportFactory("org.infinispan.server.test.client.hotrod.HotRodTestTransportFactory").marshaller("org.infinispan.server.test.client.hotrod.HotRodTestMarshaller").asyncExecutorFactory().factoryClass("org.infinispan.server.test.client.hotrod.HotRodTestExecutorFactory").addExecutorProperty("infinispan.client.hotrod.default_executor_factory.pool_size", "20").addExecutorProperty("infinispan.client.hotrod.default_executor_factory.queue_size", "200000").keySizeEstimate(128).valueSizeEstimate(1024);
        if (AbstractRemoteCacheManagerTest.isDistributedMode()) {
            config.consistentHashImpl(1, "org.infinispan.client.hotrod.impl.consistenthash.ConsistentHashV1");
        }
        return config;
    }

    @Test
    public void testConfigurationConstructors() throws Exception {
        Configuration conf = this.createRemoteCacheManagerConfigurationBuilder().build();
        RemoteCacheManager rcm = new RemoteCacheManager(conf);
        RemoteCacheManager rcm2 = new RemoteCacheManager(conf, false);
        Assert.assertTrue((boolean)rcm.isStarted());
        Assert.assertFalse((boolean)rcm2.isStarted());
        RemoteCache rc = rcm.getCache("testcache");
        this.assertEqualConfiguration(conf, rc);
    }

    @Test
    public void testEmptyConfiguration() throws Exception {
        ConfigurationBuilder confBuilder = new ConfigurationBuilder();
        this.addServers(confBuilder);
        RemoteCacheManager rcm = new RemoteCacheManager(confBuilder.build());
        RemoteCache rc = rcm.getCache("testcache");
        ConfigurationBuilder builder = new ConfigurationBuilder();
        this.addServers(builder);
        builder.balancingStrategy("org.infinispan.client.hotrod.impl.transport.tcp.RoundRobinBalancingStrategy").forceReturnValues(false).tcpNoDelay(true).pingOnStartup(true).transportFactory("org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory").marshaller("org.infinispan.commons.marshall.jboss.GenericJBossMarshaller").asyncExecutorFactory().factoryClass("org.infinispan.client.hotrod.impl.async.DefaultAsyncExecutorFactory").addExecutorProperty("infinispan.client.hotrod.default_executor_factory.pool_size", "10").addExecutorProperty("infinispan.client.hotrod.default_executor_factory.queue_size", "100000").keySizeEstimate(64).valueSizeEstimate(512);
        if (AbstractRemoteCacheManagerTest.isDistributedMode()) {
            builder.consistentHashImpl(1, "org.infinispan.client.hotrod.impl.consistenthash.ConsistentHashV1");
        }
        Configuration defaultConf = builder.build();
        this.assertEqualConfiguration(defaultConf, rc);
        Assert.assertTrue((boolean)this.putGetFromDefaultCache(rcm));
    }

    private void addServers(ConfigurationBuilder builder) {
        for (RemoteInfinispanServer server : this.getServers()) {
            builder.addServer().host(server.getHotrodEndpoint().getInetAddress().getHostName()).port(server.getHotrodEndpoint().getPort());
        }
    }

    protected static boolean isDistributedMode() {
        return AbstractRemoteCacheManagerTest.getClusteringMode().contains(DEFAULT_CLUSTERING_MODE);
    }

    @Test
    public void testStartStop() {
        Configuration cfg = this.createRemoteCacheManagerConfigurationBuilder().build();
        RemoteCacheManager rcm = new RemoteCacheManager(cfg, false);
        Assert.assertTrue((String)"RemoteCacheManager should not be started initially", (!rcm.isStarted() ? 1 : 0) != 0);
        rcm.start();
        Assert.assertTrue((String)"RemoteCacheManager fails while trying to use it to put/retrieve value", (boolean)this.putGetFromDefaultCache(rcm));
        Assert.assertTrue((String)"RemoteCacheManager should be started after calling start()", (boolean)rcm.isStarted());
        rcm.stop();
        Assert.assertTrue((String)"RemoteCacheManager should be stopped after calling stop()", (!rcm.isStarted() ? 1 : 0) != 0);
    }

    @Test
    public void testGetCache() {
        RemoteCacheManager rcm = new RemoteCacheManager(this.createRemoteCacheManagerConfigurationBuilder().build());
        RemoteCache rc1 = rcm.getCache("testcache");
        RemoteCache rc2 = rcm.getCache(DEFAULT_NAMED_CACHE);
        Assert.assertNotNull((Object)rc1);
        Assert.assertNotNull((Object)rc2);
    }

    @Test
    public void testGetNonExistentCache() {
        RemoteCacheManager rcm = new RemoteCacheManager(this.createRemoteCacheManagerConfigurationBuilder().build());
        RemoteCache rc1 = rcm.getCache("nonExistentCache");
        try {
            for (String stat : rc1.stats().getStatsMap().keySet()) {
                System.out.println(stat + " " + (String)rc1.stats().getStatsMap().get(stat));
            }
            Assert.fail((String)"Should throw CacheNotFoundException");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testDefaultLoadBalancing() throws Exception {
        if (!AbstractRemoteCacheManagerTest.isLocalMode()) {
            this.doTestDefaultLoadBalanding();
        }
    }

    private void doTestDefaultLoadBalanding() throws Exception {
        InetSocketAddress hostport0 = new InetSocketAddress(this.getServers().get(0).getHotrodEndpoint().getInetAddress().getHostName(), this.getServers().get(0).getHotrodEndpoint().getPort());
        InetSocketAddress hostport1 = new InetSocketAddress(this.getServers().get(1).getHotrodEndpoint().getInetAddress().getHostName(), this.getServers().get(1).getHotrodEndpoint().getPort());
        TcpTransport tt = null;
        InetSocketAddress sock_addr = null;
        StringBuilder serverAddrSequence = new StringBuilder();
        String hostport0String = hostport0.getAddress().getHostAddress() + ":" + hostport0.getPort();
        String hostport1String = hostport1.getAddress().getHostAddress() + ":" + hostport1.getPort();
        String expectedSequence1 = hostport0String + " " + hostport1String + " " + hostport0String;
        String expectedSequence2 = hostport1String + " " + hostport0String + " " + hostport1String;
        String expectedSequenceLocalMode = hostport0String + " " + hostport0String + " " + hostport0String;
        Configuration cfg = this.createRemoteCacheManagerConfigurationBuilder().build();
        RemoteCacheManager rcm = new RemoteCacheManager(cfg);
        RemoteCache rc = rcm.getCache("testcache");
        RemoteCacheImpl rci = (RemoteCacheImpl)rc;
        OperationsFactory of = this.getOperationsFactoryField(rci);
        TcpTransportFactory ttf = (TcpTransportFactory)this.getTransportFactoryField(of);
        tt = (TcpTransport)ttf.getTransport();
        sock_addr = (InetSocketAddress)tt.getServerAddress();
        ttf.releaseTransport((Transport)tt);
        serverAddrSequence.append(sock_addr.getAddress().getHostAddress() + ":" + sock_addr.getPort()).append(" ");
        tt = (TcpTransport)ttf.getTransport();
        sock_addr = (InetSocketAddress)tt.getServerAddress();
        ttf.releaseTransport((Transport)tt);
        serverAddrSequence.append(sock_addr.getAddress().getHostAddress() + ":" + sock_addr.getPort()).append(" ");
        tt = (TcpTransport)ttf.getTransport();
        sock_addr = (InetSocketAddress)tt.getServerAddress();
        ttf.releaseTransport((Transport)tt);
        serverAddrSequence.append(sock_addr.getAddress().getHostAddress() + ":" + sock_addr.getPort());
        if (!AbstractRemoteCacheManagerTest.isLocalMode()) {
            Assert.assertTrue((String)("loadbalancing server sequence expected either " + expectedSequence1 + " or " + expectedSequence2 + ", actual sequence: " + serverAddrSequence.toString()), (serverAddrSequence.toString().equals(expectedSequence1) || serverAddrSequence.toString().equals(expectedSequence2) ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((String)("LOCAL mode - loadbalancing server sequence expected " + expectedSequenceLocalMode + ", actual sequence: " + serverAddrSequence.toString()), (Object)serverAddrSequence.toString(), (Object)expectedSequenceLocalMode);
        }
    }

    protected static boolean isLocalMode() {
        return AbstractRemoteCacheManagerTest.getClusteringMode().contains("local");
    }

    @Test
    public void testCustomLoadBalancing() throws Exception {
        if (!AbstractRemoteCacheManagerTest.isLocalMode()) {
            this.doTestCustomLoadBalancing();
        }
    }

    private void doTestCustomLoadBalancing() throws Exception {
        InetSocketAddress hostport0 = new InetSocketAddress(this.getServers().get(0).getHotrodEndpoint().getInetAddress().getHostName(), this.getServers().get(0).getHotrodEndpoint().getPort());
        InetSocketAddress hostport1 = new InetSocketAddress(this.getServers().get(1).getHotrodEndpoint().getInetAddress().getHostName(), this.getServers().get(1).getHotrodEndpoint().getPort());
        TcpTransport tt = null;
        InetSocketAddress sock_addr = null;
        Configuration cfg = this.createRemoteCacheManagerConfigurationBuilder().balancingStrategy("org.infinispan.server.test.client.hotrod.Node0OnlyBalancingStrategy").build();
        RemoteCacheManager rcm = new RemoteCacheManager(cfg);
        RemoteCache rc = rcm.getCache("testcache");
        RemoteCacheImpl rci = (RemoteCacheImpl)rc;
        OperationsFactory of = this.getOperationsFactoryField(rci);
        TcpTransportFactory ttf = (TcpTransportFactory)this.getTransportFactoryField(of);
        tt = (TcpTransport)ttf.getTransport();
        sock_addr = (InetSocketAddress)tt.getServerAddress();
        ttf.releaseTransport((Transport)tt);
        Assert.assertEquals((String)("load balancing first request: server address expected " + hostport0 + ", actual server address " + sock_addr), (Object)sock_addr, (Object)hostport0);
        tt = (TcpTransport)ttf.getTransport();
        sock_addr = (InetSocketAddress)tt.getServerAddress();
        ttf.releaseTransport((Transport)tt);
        Assert.assertEquals((String)("load balancing second request: server address expected " + hostport0 + ", actual server address" + sock_addr), (Object)sock_addr, (Object)hostport0);
    }

    private boolean putGetFromDefaultCache(RemoteCacheManager rcm) {
        RemoteCache rc = rcm.getCache();
        rc.put((Object)"testKey", (Object)139);
        boolean success = (Integer)rc.get((Object)"testKey") == 139;
        rc.remove((Object)"testKey");
        return success;
    }

    private void assertEqualConfiguration(Configuration config, RemoteCache rc) throws Exception {
        Assert.assertEquals((Object)config.balancingStrategy().getName(), (Object)this.getRequestBalancingStrategyProperty(rc));
        String servers = this.getServerListProperty(rc);
        for (ServerConfiguration scfg : config.servers()) {
            boolean found = false;
            for (String server : servers.split(";")) {
                String[] components = server.trim().split(":");
                String host = components[0];
                int port = 11222;
                if (components.length > 1) {
                    port = Integer.parseInt(components[1]);
                }
                if (!scfg.host().equals(host) || scfg.port() != port) continue;
                found = true;
            }
            if (found) continue;
            Assert.fail((String)("The remote cache manager was configured to have server with an address " + scfg.host() + ":" + scfg.port() + ", but it doesn't."));
        }
        Assert.assertEquals((Object)config.forceReturnValues(), (Object)Boolean.parseBoolean(this.getForceReturnValueProperty(rc)));
        Assert.assertEquals((Object)config.tcpNoDelay(), (Object)Boolean.parseBoolean(this.getTcpNoDelayProperty(rc)));
        Assert.assertEquals((Object)config.pingOnStartup(), (Object)rc.getRemoteCacheManager().getConfiguration().pingOnStartup());
        Assert.assertEquals((Object)config.asyncExecutorFactory().factoryClass().getName(), (Object)rc.getRemoteCacheManager().getConfiguration().asyncExecutorFactory().factoryClass().getName());
        Assert.assertEquals((Object)config.transportFactory().getName(), (Object)this.getTransportFactoryProperty(rc));
        if (config.marshaller() != null) {
            Assert.assertEquals((Object)config.marshaller().getClass().getName(), (Object)this.getMarshallerProperty(rc));
        } else {
            Assert.assertEquals((Object)config.marshallerClass().getName(), (Object)this.getMarshallerProperty(rc));
        }
        rc.stats();
        if (AbstractRemoteCacheManagerTest.isDistributedMode()) {
            Assert.assertEquals((Object)config.consistentHashImpl(2).getName(), (Object)this.getHashFunctionImplProperty(rc));
        }
        Assert.assertEquals((long)config.keySizeEstimate(), (long)this.getKeySizeEstimateProperty(rc));
        Assert.assertEquals((long)config.valueSizeEstimate(), (long)this.getValueSizeEstimateProperty(rc));
    }

    private String getRequestBalancingStrategyProperty(RemoteCache rc) throws Exception {
        RemoteCacheImpl rci = (RemoteCacheImpl)rc;
        OperationsFactory of = this.getOperationsFactoryField(rci);
        TcpTransportFactory ttf = (TcpTransportFactory)this.getTransportFactoryField(of);
        RequestBalancingStrategy rbs = ttf.getBalancer();
        return rbs.getClass().getName();
    }

    private String getServerListProperty(RemoteCache rc) throws Exception {
        RemoteCacheImpl rci = (RemoteCacheImpl)rc;
        OperationsFactory of = this.getOperationsFactoryField(rci);
        TcpTransportFactory ttf = (TcpTransportFactory)this.getTransportFactoryField(of);
        Collection servers = ttf.getServers();
        StringBuffer serverList = new StringBuffer();
        int listSize = servers.size();
        int i = 0;
        for (InetSocketAddress addr : servers) {
            String serverAddress = addr.getAddress().toString();
            if (serverAddress.startsWith("/")) {
                serverAddress = serverAddress.substring(1);
            }
            serverList.append(addr.getHostName());
            serverList.append(":");
            serverList.append(addr.getPort());
            if (i < listSize - 1) {
                serverList.append(";");
            }
            ++i;
        }
        return serverList.toString();
    }

    private String getForceReturnValueProperty(RemoteCache rc) throws Exception {
        RemoteCacheImpl rci = (RemoteCacheImpl)rc;
        OperationsFactory of = this.getOperationsFactoryField(rci);
        boolean forceReturn = this.getForceReturnValueField(of);
        return Boolean.toString(forceReturn);
    }

    private String getTcpNoDelayProperty(RemoteCache rc) throws Exception {
        RemoteCacheImpl rci = (RemoteCacheImpl)rc;
        OperationsFactory of = this.getOperationsFactoryField(rci);
        TcpTransportFactory ttf = (TcpTransportFactory)this.getTransportFactoryField(of);
        boolean tcpNoDelay = ttf.isTcpNoDelay();
        return Boolean.toString(tcpNoDelay);
    }

    private String getTransportFactoryProperty(RemoteCache rc) throws Exception {
        RemoteCacheImpl rci = (RemoteCacheImpl)rc;
        OperationsFactory of = this.getOperationsFactoryField(rci);
        TransportFactory tf = this.getTransportFactoryField(of);
        return tf.getClass().getName();
    }

    private String getMarshallerProperty(RemoteCache rc) throws Exception {
        RemoteCacheImpl rci = (RemoteCacheImpl)rc;
        Marshaller m = this.getMarshallerField(rci);
        return m.getClass().getName();
    }

    private String getHashFunctionImplProperty(RemoteCache rc) throws Exception {
        RemoteCacheImpl rci = (RemoteCacheImpl)rc;
        OperationsFactory of = this.getOperationsFactoryField(rci);
        TcpTransportFactory ttf = (TcpTransportFactory)this.getTransportFactoryField(of);
        ConsistentHash ch = ttf.getConsistentHash();
        return ch.getClass().getName();
    }

    private int getKeySizeEstimateProperty(RemoteCache rc) throws Exception {
        RemoteCacheImpl rci = (RemoteCacheImpl)rc;
        return this.getEstimateKeySizeField(rci);
    }

    private int getValueSizeEstimateProperty(RemoteCache rc) throws Exception {
        RemoteCacheImpl rci = (RemoteCacheImpl)rc;
        return this.getEstimateValueSizeField(rci);
    }

    protected static String getClusteringMode() {
        return System.getProperty("clustering.mode", DEFAULT_CLUSTERING_MODE);
    }

    private OperationsFactory getOperationsFactoryField(RemoteCacheImpl rci) throws Exception {
        Field field = null;
        try {
            field = RemoteCacheImpl.class.getDeclaredField("operationsFactory");
        }
        catch (NoSuchFieldException e) {
            throw new Exception("Could not access operationsFactory field", e);
        }
        field.setAccessible(true);
        OperationsFactory fieldValue = null;
        try {
            fieldValue = (OperationsFactory)field.get(rci);
        }
        catch (IllegalAccessException e) {
            throw new Exception("Could not access OperationsFactory field", e);
        }
        return fieldValue;
    }

    private int getEstimateKeySizeField(RemoteCacheImpl rci) throws Exception {
        Field field = null;
        try {
            field = RemoteCacheImpl.class.getDeclaredField("estimateKeySize");
        }
        catch (NoSuchFieldException e) {
            throw new Exception("Could not access estimateKeySize field", e);
        }
        field.setAccessible(true);
        int fieldValue = 0;
        try {
            fieldValue = field.getInt(rci);
        }
        catch (IllegalAccessException e) {
            throw new Exception("Could not access estimateKeySize field", e);
        }
        return fieldValue;
    }

    private int getEstimateValueSizeField(RemoteCacheImpl rci) throws Exception {
        Field field = null;
        try {
            field = RemoteCacheImpl.class.getDeclaredField("estimateValueSize");
        }
        catch (NoSuchFieldException e) {
            throw new Exception("Could not access estimateValueSize field", e);
        }
        field.setAccessible(true);
        int fieldValue = 0;
        try {
            fieldValue = field.getInt(rci);
        }
        catch (IllegalAccessException e) {
            throw new Exception("Could not access estimateValueSize field", e);
        }
        return fieldValue;
    }

    private Marshaller getMarshallerField(RemoteCacheImpl rci) throws Exception {
        Field field = null;
        try {
            field = RemoteCacheImpl.class.getDeclaredField("marshaller");
        }
        catch (NoSuchFieldException e) {
            throw new Exception("Could not access marshaller field", e);
        }
        field.setAccessible(true);
        Marshaller fieldValue = null;
        try {
            fieldValue = (Marshaller)field.get(rci);
        }
        catch (IllegalAccessException e) {
            throw new Exception("Could not access marshaller field", e);
        }
        return fieldValue;
    }

    private boolean getForceReturnValueField(OperationsFactory of) throws Exception {
        Field field = null;
        try {
            field = OperationsFactory.class.getDeclaredField("forceReturnValue");
        }
        catch (NoSuchFieldException e) {
            throw new Exception("Could not access forceReturnValue field", e);
        }
        field.setAccessible(true);
        boolean fieldValue = false;
        try {
            fieldValue = field.getBoolean(of);
        }
        catch (IllegalAccessException e) {
            throw new Exception("Could not access forceReturnValue field", e);
        }
        return fieldValue;
    }

    private TransportFactory getTransportFactoryField(OperationsFactory of) throws Exception {
        Field field = null;
        try {
            field = OperationsFactory.class.getDeclaredField("transportFactory");
        }
        catch (NoSuchFieldException e) {
            throw new Exception("Could not access transportFactory field", e);
        }
        field.setAccessible(true);
        TransportFactory fieldValue = null;
        try {
            fieldValue = (TransportFactory)field.get(of);
        }
        catch (IllegalAccessException e) {
            throw new Exception("Could not access transportFactory field", e);
        }
        return fieldValue;
    }
}

