/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.rest;

import java.net.Inet6Address;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.server.test.category.RESTClustered;
import org.infinispan.server.test.client.rest.RESTHelper;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={RESTClustered.class})
public class RESTReplicationTest {
    @InfinispanResource(value="container1")
    RemoteInfinispanServer server1;
    @InfinispanResource(value="container2")
    RemoteInfinispanServer server2;

    @Before
    public void setUp() throws Exception {
        if (this.server1.getRESTEndpoint().getInetAddress() instanceof Inet6Address) {
            RESTHelper.addServer("[" + this.server1.getRESTEndpoint().getInetAddress().getHostName() + "]", this.server1.getRESTEndpoint().getContextPath());
        } else {
            RESTHelper.addServer(this.server1.getRESTEndpoint().getInetAddress().getHostName(), this.server1.getRESTEndpoint().getContextPath());
        }
        if (this.server2.getRESTEndpoint().getInetAddress() instanceof Inet6Address) {
            RESTHelper.addServer("[" + this.server2.getRESTEndpoint().getInetAddress().getHostName() + "]", this.server2.getRESTEndpoint().getContextPath());
        } else {
            RESTHelper.addServer(this.server2.getRESTEndpoint().getInetAddress().getHostName(), this.server2.getRESTEndpoint().getContextPath());
        }
        RESTHelper.delete(RESTHelper.fullPathKey("a"));
        RESTHelper.delete(RESTHelper.fullPathKey("b"));
        RESTHelper.delete(RESTHelper.fullPathKey("c"));
        RESTHelper.head(RESTHelper.fullPathKey("a"), 404);
        RESTHelper.head(RESTHelper.fullPathKey("b"), 404);
        RESTHelper.head(RESTHelper.fullPathKey("c"), 404);
    }

    @After
    public void tearDown() throws Exception {
        RESTHelper.delete(RESTHelper.fullPathKey("a"));
        RESTHelper.delete(RESTHelper.fullPathKey("b"));
        RESTHelper.delete(RESTHelper.fullPathKey("c"));
    }

    @Test
    public void testReplicationPut() throws Exception {
        RESTHelper.put(RESTHelper.fullPathKey(0, "a"), "data", "text/plain");
        RESTHelper.get(RESTHelper.fullPathKey(1, "a"), "data");
    }

    @Test
    public void testReplicationPost() throws Exception {
        RESTHelper.post(RESTHelper.fullPathKey(0, "a"), "data", "text/plain");
        RESTHelper.get(RESTHelper.fullPathKey(1, "a"), "data");
    }

    @Test
    public void testReplicationDelete() throws Exception {
        RESTHelper.post(RESTHelper.fullPathKey(0, "a"), "data", "text/plain");
        RESTHelper.get(RESTHelper.fullPathKey(1, "a"), "data");
        RESTHelper.delete(RESTHelper.fullPathKey(0, "a"));
        RESTHelper.head(RESTHelper.fullPathKey(1, "a"), 404);
    }

    @Test
    public void testReplicationWipeCache() throws Exception {
        RESTHelper.post(RESTHelper.fullPathKey(0, "a"), "data", "text/plain");
        RESTHelper.post(RESTHelper.fullPathKey(0, "b"), "data", "text/plain");
        RESTHelper.head(RESTHelper.fullPathKey(0, "a"));
        RESTHelper.head(RESTHelper.fullPathKey(0, "b"));
        RESTHelper.delete(RESTHelper.fullPathKey(0, null));
        RESTHelper.head(RESTHelper.fullPathKey(1, "a"), 404);
        RESTHelper.head(RESTHelper.fullPathKey(1, "b"), 404);
    }

    @Test
    public void testReplicationTTL() throws Exception {
        RESTHelper.post(RESTHelper.fullPathKey(0, "a"), "data", "application/text", 200, "Content-Type", "application/text", "timeToLiveSeconds", "2");
        RESTHelper.head(RESTHelper.fullPathKey(1, "a"));
        Thread.sleep(2100L);
        RESTHelper.head(RESTHelper.fullPathKey(1, "a"), 404);
    }
}

