/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.jmxmanagement.suppress.statetransfer;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RemoteInfinispanServers;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.server.test.util.RemoteInfinispanMBeans;
import org.infinispan.server.test.util.TestUtil;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractStateTransferSuppressTest {
    protected static final String CONTAINER1 = "suppress-state-transfer-1";
    protected static final String CONTAINER2 = "suppress-state-transfer-2";
    protected static final String CONTAINER3 = "suppress-state-transfer-3";
    final String DIST_CACHE_PREFIX = "jboss.infinispan:type=Cache,name=\"" + this.getCacheName() + "(dist_sync)\",manager=\"" + this.getCacheManagerName() + "\",component=";
    final String RPC_MANAGER_MBEAN = this.DIST_CACHE_PREFIX + "RpcManager";
    final String REBALANCE_ENABLED_ATTR_NAME = "RebalancingEnabled";
    final String COMMITTED_VIEW_AS_STRING_ATTR_NAME = "CommittedViewAsString";
    final String PENDING_VIEW_AS_STRING_ATTR_NAME = "PendingViewAsString";
    private final String OWNERS_2_MEMBERS_NODE0_NODE1 = "DefaultConsistentHash{numSegments=60, numOwners=2, members=[node0/" + this.getCacheManagerName() + ", node1/" + this.getCacheManagerName() + "]}";
    private final String OWNERS_2_MEMBERS_NODE1_NODE2 = "DefaultConsistentHash{numSegments=60, numOwners=2, members=[node1/" + this.getCacheManagerName() + ", node2/" + this.getCacheManagerName() + "]}";
    private final String OWNERS_2_MEMBERS_NODE0_NODE1_NODE2 = "DefaultConsistentHash{numSegments=60, numOwners=2, members=[node0/" + this.getCacheManagerName() + ", node1/" + this.getCacheManagerName() + ", node2/" + this.getCacheManagerName() + "]}";
    private final String LOCAL_TOPOLOGY_MANAGER = "jboss.infinispan:type=CacheManager,name=\"" + this.getCacheManagerName() + "\",component=LocalTopologyManager";
    final int managementPort = 9999;
    @InfinispanResource
    RemoteInfinispanServers serverManager;
    @ArquillianResource
    ContainerController controller;
    protected final List<MBeanServerConnectionProvider> providers = new ArrayList<MBeanServerConnectionProvider>();
    private final List<RemoteInfinispanMBeans> mbeans = new ArrayList<RemoteInfinispanMBeans>();

    @Before
    public void setUp() throws Exception {
        this.mbeans.clear();
        this.mbeans.add(RemoteInfinispanMBeans.create(this.serverManager, CONTAINER1, this.getCacheName(), this.getCacheManagerName()));
        this.mbeans.add(RemoteInfinispanMBeans.create(this.serverManager, CONTAINER2, this.getCacheName(), this.getCacheManagerName()));
        this.mbeans.add(RemoteInfinispanMBeans.create(this.serverManager, CONTAINER3, this.getCacheName(), this.getCacheManagerName()));
        this.providers.clear();
        this.prepare();
    }

    @After
    public void tearDown() throws Exception {
        this.destroy();
    }

    protected RemoteInfinispanMBeans mbean(int index) {
        return this.mbeans.get(index);
    }

    protected RemoteInfinispanServer server(int index) {
        return this.mbean((int)index).server;
    }

    protected MBeanServerConnectionProvider provider(int index) {
        return this.providers.get(index);
    }

    @Test
    @WithRunningServer(value={"suppress-state-transfer-1", "suppress-state-transfer-2"})
    public void testRebalanceSwitch() throws Exception {
        this.checkRebalanceStatus(true, this.provider(0), this.provider(1));
        this.checkRpcManagerStatistics(new String[]{"null"}, this.OWNERS_2_MEMBERS_NODE0_NODE1, this.provider(0), this.provider(1));
        TestUtil.setAttribute(this.provider(0), this.LOCAL_TOPOLOGY_MANAGER, "RebalancingEnabled", false);
        this.checkRebalanceStatus(false, this.provider(0), this.provider(1));
        this.putDataIntoCache(100);
        this.checkRpcManagerStatistics(new String[]{"null"}, this.OWNERS_2_MEMBERS_NODE0_NODE1, this.provider(0), this.provider(1));
        TestUtil.setAttribute(this.provider(1), this.LOCAL_TOPOLOGY_MANAGER, "RebalancingEnabled", true);
        this.checkRebalanceStatus(true, this.provider(0), this.provider(1));
        this.checkRpcManagerStatistics(new String[]{"null"}, this.OWNERS_2_MEMBERS_NODE0_NODE1, this.provider(0), this.provider(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @WithRunningServer(value={"suppress-state-transfer-1", "suppress-state-transfer-2"})
    public void testRebalanceDisabledWithNewNode() throws Exception {
        try {
            this.verifyRebalanceWith3rdNode();
        }
        finally {
            this.controller.stop(CONTAINER3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @WithRunningServer(value={"suppress-state-transfer-1", "suppress-state-transfer-2"})
    public void testRebalanceWithFirstNodeStop() throws Exception {
        try {
            this.verifyRebalanceWith3rdNode();
            TestUtil.setAttribute(this.provider(0), this.LOCAL_TOPOLOGY_MANAGER, "RebalancingEnabled", false);
            this.controller.stop(CONTAINER1);
            this.checkRpcManagerStatistics(new String[]{"null", this.OWNERS_2_MEMBERS_NODE1_NODE2}, this.OWNERS_2_MEMBERS_NODE1_NODE2, this.provider(1), this.provider(2));
            Thread.sleep(5000L);
            this.checkRebalanceStatus(false, this.provider(1), this.provider(2));
            Assert.assertTrue((this.server(1).getCacheManager(this.getCacheManagerName()).getCache(this.getCacheName()).getNumberOfEntries() < 100L ? 1 : 0) != 0);
            Assert.assertTrue((this.server(2).getCacheManager(this.getCacheManagerName()).getCache(this.getCacheName()).getNumberOfEntries() < 100L ? 1 : 0) != 0);
            TestUtil.setAttribute(this.provider(1), this.LOCAL_TOPOLOGY_MANAGER, "RebalancingEnabled", true);
            this.checkRebalanceStatus(true, this.provider(1), this.provider(2));
            this.checkRpcManagerStatistics(new String[]{"null", this.OWNERS_2_MEMBERS_NODE1_NODE2}, this.OWNERS_2_MEMBERS_NODE1_NODE2, this.provider(1), this.provider(2));
            Assert.assertTrue((this.server(1).getCacheManager(this.getCacheManagerName()).getCache(this.getCacheName()).getNumberOfEntries() == 100L ? 1 : 0) != 0);
            Assert.assertTrue((this.server(2).getCacheManager(this.getCacheManagerName()).getCache(this.getCacheName()).getNumberOfEntries() == 100L ? 1 : 0) != 0);
        }
        finally {
            this.controller.stop(CONTAINER3);
        }
    }

    @Test
    @WithRunningServer(value={"suppress-state-transfer-1", "suppress-state-transfer-2"})
    public void testRebalanceWithJoinedNodeStop() throws Exception {
        this.verifyRebalanceWith3rdNode();
        TestUtil.setAttribute(this.provider(0), this.LOCAL_TOPOLOGY_MANAGER, "RebalancingEnabled", false);
        this.controller.stop(CONTAINER3);
        this.checkRpcManagerStatistics(new String[]{"null", this.OWNERS_2_MEMBERS_NODE0_NODE1}, this.OWNERS_2_MEMBERS_NODE0_NODE1, this.provider(0), this.provider(1));
        Thread.sleep(5000L);
        this.checkRebalanceStatus(false, this.provider(0), this.provider(1));
        Assert.assertTrue((this.server(0).getCacheManager(this.getCacheManagerName()).getCache(this.getCacheName()).getNumberOfEntries() < 100L ? 1 : 0) != 0);
        Assert.assertTrue((this.server(1).getCacheManager(this.getCacheManagerName()).getCache(this.getCacheName()).getNumberOfEntries() < 100L ? 1 : 0) != 0);
        TestUtil.setAttribute(this.provider(1), this.LOCAL_TOPOLOGY_MANAGER, "RebalancingEnabled", true);
        this.checkRebalanceStatus(true, this.provider(0), this.provider(1));
        this.checkRpcManagerStatistics(new String[]{"null", this.OWNERS_2_MEMBERS_NODE0_NODE1}, this.OWNERS_2_MEMBERS_NODE0_NODE1, this.provider(0), this.provider(1));
        Assert.assertTrue((this.server(0).getCacheManager(this.getCacheManagerName()).getCache(this.getCacheName()).getNumberOfEntries() == 100L ? 1 : 0) != 0);
        Assert.assertTrue((this.server(1).getCacheManager(this.getCacheManagerName()).getCache(this.getCacheName()).getNumberOfEntries() == 100L ? 1 : 0) != 0);
    }

    private void verifyRebalanceWith3rdNode() throws Exception {
        TestUtil.setAttribute(this.provider(0), this.LOCAL_TOPOLOGY_MANAGER, "RebalancingEnabled", false);
        this.putDataIntoCache(100);
        this.checkRebalanceStatus(false, this.provider(0), this.provider(1));
        this.checkRpcManagerStatistics(new String[]{"null"}, this.OWNERS_2_MEMBERS_NODE0_NODE1, this.provider(0), this.provider(1));
        this.controller.start(CONTAINER3);
        this.createNewProvider();
        this.checkRebalanceStatus(false, this.provider(2));
        this.checkRpcManagerStatistics(new String[]{"null"}, this.OWNERS_2_MEMBERS_NODE0_NODE1, this.provider(0), this.provider(1), this.provider(2));
        Assert.assertTrue((String)"The cache on server(2) should be empty.", (this.server(2).getCacheManager(this.getCacheManagerName()).getCache(this.getCacheName()).getNumberOfEntries() == 0L ? 1 : 0) != 0);
        TestUtil.setAttribute(this.provider(0), this.LOCAL_TOPOLOGY_MANAGER, "RebalancingEnabled", true);
        this.checkRebalanceStatus(true, this.provider(0), this.provider(1), this.provider(2));
        this.checkRpcManagerStatistics(new String[]{"null", this.OWNERS_2_MEMBERS_NODE0_NODE1_NODE2}, null, this.provider(0), this.provider(1), this.provider(2));
        Thread.sleep(10000L);
        this.checkRpcManagerStatistics(new String[]{"null"}, this.OWNERS_2_MEMBERS_NODE0_NODE1_NODE2, this.provider(0), this.provider(1), this.provider(2));
        Assert.assertTrue((this.server(0).getCacheManager(this.getCacheManagerName()).getCache(this.getCacheName()).getNumberOfEntries() < 100L ? 1 : 0) != 0);
        Assert.assertTrue((this.server(1).getCacheManager(this.getCacheManagerName()).getCache(this.getCacheName()).getNumberOfEntries() < 100L ? 1 : 0) != 0);
        Assert.assertTrue((this.server(2).getCacheManager(this.getCacheManagerName()).getCache(this.getCacheName()).getNumberOfEntries() < 100L ? 1 : 0) != 0);
    }

    private void checkRebalanceStatus(boolean expectedStatus, MBeanServerConnectionProvider ... providers) throws Exception {
        for (MBeanServerConnectionProvider provider : providers) {
            Assert.assertTrue((Boolean.parseBoolean(TestUtil.getAttribute(provider, this.LOCAL_TOPOLOGY_MANAGER, "RebalancingEnabled")) == expectedStatus ? 1 : 0) != 0);
        }
    }

    private void checkRpcManagerStatistics(String[] expectedPendingViews, String expectedCommitedView, MBeanServerConnectionProvider ... providers) throws Exception {
        for (MBeanServerConnectionProvider provider : providers) {
            if (expectedCommitedView != null) {
                String committedViewAsString = String.valueOf(TestUtil.getAttribute(provider, this.RPC_MANAGER_MBEAN, "CommittedViewAsString"));
                Assert.assertEquals((Object)expectedCommitedView, (Object)committedViewAsString);
            }
            String pendingViewAsString = String.valueOf(TestUtil.getAttribute(provider, this.RPC_MANAGER_MBEAN, "PendingViewAsString"));
            boolean passed = false;
            for (String expectedPendingView : expectedPendingViews) {
                if (!expectedPendingView.equals(pendingViewAsString)) continue;
                passed = true;
                break;
            }
            Assert.assertTrue((String)("The pending view doesn't match to any of expected ones, but is " + pendingViewAsString + "."), (boolean)passed);
        }
    }

    protected abstract void prepare();

    protected abstract void destroy();

    protected abstract void putDataIntoCache(int var1);

    protected abstract String getCacheName();

    protected abstract String getCacheManagerName();

    protected abstract void createNewProvider();
}

