/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.query;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.management.JMX;
import javax.management.ObjectName;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.sampledomain.User;
import org.infinispan.protostream.sampledomain.marshallers.MarshallerRegistration;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.remote.ProtobufMetadataManagerMBean;
import org.infinispan.server.test.util.RemoteCacheManagerFactory;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@WithRunningServer(value={"remote-query"})
public class ManualIndexingTest {
    private static final String CACHE_MANAGER_NAME = "local";
    private static final String CACHE_NAME = "testcache_manual";
    @InfinispanResource(value="remote-query")
    private RemoteInfinispanServer server;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache<Integer, User> remoteCache;
    private MBeanServerConnectionProvider provider;
    private RemoteCacheManagerFactory rcmFactory;

    @Before
    public void setUp() throws Exception {
        this.provider = new MBeanServerConnectionProvider(this.server.getHotrodEndpoint().getInetAddress().getHostName(), 9999);
        this.rcmFactory = new RemoteCacheManagerFactory();
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host(this.server.getHotrodEndpoint().getInetAddress().getHostName()).port(this.server.getHotrodEndpoint().getPort()).marshaller((Marshaller)new ProtoStreamMarshaller());
        this.remoteCacheManager = this.rcmFactory.createManager(clientBuilder);
        this.remoteCache = this.remoteCacheManager.getCache(CACHE_NAME);
        ObjectName protobufMetadataManagerName = new ObjectName("jboss.infinispan:type=RemoteQuery,name=" + ObjectName.quote(CACHE_MANAGER_NAME) + ",component=ProtobufMetadataManager");
        ProtobufMetadataManagerMBean protobufMetadataManagerMBean = JMX.newMBeanProxy(this.provider.getConnection(), protobufMetadataManagerName, ProtobufMetadataManagerMBean.class);
        protobufMetadataManagerMBean.registerProtofile(this.readClasspathResource("/bank.protobin"));
        MarshallerRegistration.registerMarshallers((SerializationContext)ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.remoteCacheManager));
    }

    @After
    public void tearDown() {
        if (this.remoteCache != null) {
            this.remoteCache.clear();
        }
        if (this.rcmFactory != null) {
            this.rcmFactory.stopManagers();
        }
        this.rcmFactory = null;
    }

    @Test
    public void testManualIndexing() throws Exception {
        QueryBuilder qb = Search.getQueryFactory(this.remoteCache).from(User.class).having("name").eq((Object)"Tom").toBuilder();
        User user = new User();
        user.setId(1);
        user.setName("Tom");
        user.setSurname("Cat");
        user.setGender(User.Gender.MALE);
        this.remoteCache.put((Object)1, (Object)user);
        Assert.assertEquals((long)0L, (long)qb.build().list().size());
        ObjectName massIndexerName = new ObjectName("jboss.infinispan:type=Query,manager=" + ObjectName.quote(CACHE_MANAGER_NAME) + ",cache=" + ObjectName.quote(CACHE_NAME) + ",component=MassIndexer");
        this.provider.getConnection().invoke(massIndexerName, "start", null, null);
        List list = qb.build().list();
        Assert.assertEquals((long)1L, (long)list.size());
        User foundUser = (User)list.get(0);
        Assert.assertEquals((long)1L, (long)foundUser.getId());
        Assert.assertEquals((Object)"Tom", (Object)foundUser.getName());
        Assert.assertEquals((Object)"Cat", (Object)foundUser.getSurname());
        Assert.assertEquals((Object)User.Gender.MALE, (Object)foundUser.getGender());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readClasspathResource(String c) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(c);
        try {
            byte[] byArray = Util.readStream((InputStream)is);
            return byArray;
        }
        finally {
            is.close();
        }
    }
}

