/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.rollingupgrades;

import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServers;
import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.server.test.category.RollingUpgrades;
import org.infinispan.server.test.util.RemoteCacheManagerFactory;
import org.infinispan.server.test.util.RemoteInfinispanMBeans;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={RollingUpgrades.class})
public class RollingUpgradesTest {
    private static final Logger log = Logger.getLogger(RollingUpgradesTest.class);
    @InfinispanResource
    RemoteInfinispanServers serverManager;
    static final String DEFAULT_CACHE_NAME = "default";
    @ArquillianResource
    ContainerController controller;
    RemoteCacheManagerFactory rcmFactory;

    @Before
    public void setUp() {
        this.rcmFactory = new RemoteCacheManagerFactory();
    }

    @After
    public void tearDown() {
        if (this.rcmFactory != null) {
            this.rcmFactory.stopManagers();
        }
        this.rcmFactory = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHotRodRollingUpgradesDiffVersions() throws Exception {
        int managementPortServer1 = 9999;
        int managementPortServer2 = 10099;
        this.controller.start("hotrod-rolling-upgrade-2-old");
        try {
            RemoteInfinispanMBeans s2 = this.createRemotes("hotrod-rolling-upgrade-2-old", "local", DEFAULT_CACHE_NAME);
            RemoteCache<Object, Object> c2 = this.createCache(s2);
            c2.put((Object)"key1", (Object)"value1");
            Assert.assertEquals((Object)"value1", (Object)c2.get((Object)"key1"));
            for (int i = 0; i < 50; ++i) {
                c2.put((Object)("keyLoad" + i), (Object)("valueLoad" + i));
            }
            this.controller.start("hotrod-rolling-upgrade-1");
            RemoteInfinispanMBeans s1 = this.createRemotes("hotrod-rolling-upgrade-1", "local", DEFAULT_CACHE_NAME);
            RemoteCache<Object, Object> c1 = this.createCache(s1);
            Assert.assertEquals((String)"Can't access etries stored in source node (target's RemoteCacheStore).", (Object)"value1", (Object)c1.get((Object)"key1"));
            MBeanServerConnectionProvider provider1 = new MBeanServerConnectionProvider(s1.server.getHotrodEndpoint().getInetAddress().getHostName(), 9999);
            MBeanServerConnectionProvider provider2 = new MBeanServerConnectionProvider(s2.server.getHotrodEndpoint().getInetAddress().getHostName(), 10099);
            ObjectName rollMan = new ObjectName("jboss.infinispan:type=Cache,name=\"default(local)\",manager=\"local\",component=RollingUpgradeManager");
            this.invokeOperation(provider2, rollMan.toString(), "recordKnownGlobalKeyset", new Object[0], new String[0]);
            this.invokeOperation(provider1, rollMan.toString(), "synchronizeData", new Object[]{"hotrod"}, new String[]{"java.lang.String"});
            this.invokeOperation(provider1, rollMan.toString(), "disconnectSource", new Object[]{"hotrod"}, new String[]{"java.lang.String"});
            c2.put((Object)"disconnected", (Object)"source");
            Assert.assertEquals((String)"Can't obtain value from cache1 (source node).", (Object)"source", (Object)c2.get((Object)"disconnected"));
            Assert.assertNull((String)"Source node entries should NOT be accessible from target node (after RCS disconnection)", (Object)c1.get((Object)"disconnected"));
            Assert.assertEquals((String)"Entry was not successfully migrated.", (Object)"value1", (Object)c1.get((Object)"key1"));
            for (int i = 0; i < 50; ++i) {
                Assert.assertEquals((String)"Entry was not successfully migrated.", (Object)("valueLoad" + i), (Object)c1.get((Object)("keyLoad" + i)));
            }
        }
        finally {
            if (this.controller.isStarted("hotrod-rolling-upgrade-1")) {
                this.controller.stop("hotrod-rolling-upgrade-1");
            }
            if (this.controller.isStarted("hotrod-rolling-upgrade-2-old")) {
                this.controller.stop("hotrod-rolling-upgrade-2-old");
            }
        }
    }

    protected RemoteCache<Object, Object> createCache(RemoteInfinispanMBeans cacheBeans) {
        return this.rcmFactory.createCache(cacheBeans);
    }

    protected RemoteInfinispanMBeans createRemotes(String serverName, String managerName, String cacheName) {
        return RemoteInfinispanMBeans.create(this.serverManager, serverName, cacheName, managerName);
    }

    private Object invokeOperation(MBeanServerConnectionProvider provider, String mbean, String operationName, Object[] params, String[] signature) throws Exception {
        return provider.getConnection().invoke(new ObjectName(mbean), operationName, params, signature);
    }
}

