/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.cs.leveldb;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.infinispan.Cache;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.model.RemoteInfinispanCache;
import org.infinispan.arquillian.model.RemoteInfinispanCacheManager;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.marshall.AbstractDelegatingMarshaller;
import org.infinispan.commons.marshall.AbstractMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.server.test.category.CacheStore;
import org.infinispan.server.test.util.TestUtil;
import org.infinispan.test.TestingUtil;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.impl.Iq80DBFactory;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={CacheStore.class})
public class LevelDBCacheStoreTest {
    @InfinispanResource(value="leveldb")
    RemoteInfinispanServer server;
    @ArquillianResource
    ContainerController controller;
    public static final String CONTAINER = "leveldb";
    private static File dataDir = new File(TestUtil.SERVER_DATA_DIR + File.separator + "leveldbtestcache");
    private static File expiredDir = new File(TestUtil.SERVER_DATA_DIR + File.separator + "leveldb-expiredtestcache");
    String cacheStoreName = System.getProperty("cachestore.name");
    private static final TestMarshaller clientMarshaller = new TestMarshaller();
    private static final StreamingMarshaller serverMarshaller = LevelDBCacheStoreTest.getServerMarshaller();

    private void removeDataFilesIfExists() {
        if (dataDir.exists()) {
            TestingUtil.recursiveFileRemove((File)dataDir);
        }
        if (expiredDir.exists()) {
            TestingUtil.recursiveFileRemove((File)expiredDir);
        }
    }

    @Test
    public void testDataSurvivesRestart() throws Exception {
        this.removeDataFilesIfExists();
        this.controller.start(CONTAINER);
        RemoteInfinispanCacheManager managerJmx = this.server.getCacheManager("local");
        RemoteInfinispanCache cacheJmx = managerJmx.getCache("testcache");
        RemoteCache cache = this.createManager().getCache();
        cache.clear();
        Assert.assertEquals((long)0L, (long)cacheJmx.getNumberOfEntries());
        cache.put((Object)"key1", (Object)"1");
        cache.put((Object)"key2", (Object)"2");
        cache.put((Object)"key3", (Object)"3");
        Assert.assertEquals((Object)"1", (Object)cache.get((Object)"key1"));
        Assert.assertEquals((Object)"2", (Object)cache.get((Object)"key2"));
        Assert.assertEquals((Object)"3", (Object)cache.get((Object)"key3"));
        System.out.println("Stored via Hot Rod:");
        this.printHex("key1", "1");
        this.printHex("key2", "2");
        this.printHex("key3", "3");
        Assert.assertTrue((boolean)dataDir.exists());
        Assert.assertTrue((boolean)dataDir.isDirectory());
        Assert.assertTrue((boolean)expiredDir.exists());
        Assert.assertTrue((boolean)expiredDir.isDirectory());
        this.controller.stop(CONTAINER);
        this.controller.start(CONTAINER);
        Assert.assertEquals((Object)"1", (Object)cache.get((Object)"key1"));
        Assert.assertEquals((Object)"2", (Object)cache.get((Object)"key2"));
        Assert.assertEquals((Object)"3", (Object)cache.get((Object)"key3"));
        this.controller.stop(CONTAINER);
    }

    private void printHex(String key, String value) throws IOException, InterruptedException {
        byte[] keyBytes = this.marshall(key);
        byte[] valueBytes = this.marshall(value);
        System.out.println("key \"" + Hex.encodeHexString((byte[])keyBytes) + "\": value \"" + Hex.encodeHexString((byte[])valueBytes) + "\"");
    }

    @Test
    public void testDataRetrievableViaLevelDbApi() throws Exception {
        this.removeDataFilesIfExists();
        this.controller.start(CONTAINER);
        RemoteInfinispanCacheManager managerJmx = this.server.getCacheManager("local");
        RemoteInfinispanCache cacheJmx = managerJmx.getCache("testcache");
        RemoteCache cache = this.createManager().getCache();
        cache.clear();
        Assert.assertEquals((long)0L, (long)cacheJmx.getNumberOfEntries());
        cache.put((Object)"key1", (Object)"1");
        Assert.assertEquals((Object)"1", (Object)cache.get((Object)"key1"));
        System.out.println("Stored via Hot Rod:");
        this.printHex("key1", "1");
        Assert.assertTrue((boolean)dataDir.exists());
        Assert.assertTrue((boolean)dataDir.isDirectory());
        Assert.assertTrue((boolean)expiredDir.exists());
        Assert.assertTrue((boolean)expiredDir.isDirectory());
        this.controller.stop(CONTAINER);
        DB db = Iq80DBFactory.factory.open(dataDir, new Options());
        System.out.println("LevelDB file " + dataDir.getAbsolutePath() + " contents:");
        for (Map.Entry entry : db) {
            System.out.println("key \"" + Hex.encodeHexString((byte[])((byte[])entry.getKey())) + "\": value \"" + Hex.encodeHexString((byte[])((byte[])entry.getValue())) + "\"");
        }
        Assert.assertNotNull((Object)db.get(this.marshall("key1")));
    }

    private byte[] marshall(Object o) throws IOException, InterruptedException {
        return serverMarshaller.objectToByteBuffer((Object)clientMarshaller.objectToByteBuffer(o));
    }

    private RemoteCacheManager createManager() {
        ConfigurationBuilder cfgBuild = TestUtil.createConfigBuilder(this.server.getHotrodEndpoint().getInetAddress().getHostName(), this.server.getHotrodEndpoint().getPort());
        if (clientMarshaller != null) {
            cfgBuild.marshaller((Marshaller)clientMarshaller);
        }
        return new RemoteCacheManager(cfgBuild.build());
    }

    private static AbstractDelegatingMarshaller getServerMarshaller() {
        DefaultCacheManager dcm = new DefaultCacheManager();
        dcm.start();
        dcm.getCache();
        return LevelDBCacheStoreTest.extractCacheMarshaller(dcm.getCache());
    }

    private static Object extractField(Object target, String fieldName) {
        return LevelDBCacheStoreTest.extractField(target.getClass(), target, fieldName);
    }

    private static Object extractField(Class<?> type, Object target, String fieldName) {
        while (true) {
            try {
                Field field = type.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field.get(target);
            }
            catch (Exception e) {
                if (type.equals(Object.class)) {
                    e.printStackTrace();
                    return null;
                }
                type = type.getSuperclass();
                continue;
            }
            break;
        }
    }

    public static AbstractDelegatingMarshaller extractCacheMarshaller(Cache<?, ?> cache) {
        ComponentRegistry cr = (ComponentRegistry)LevelDBCacheStoreTest.extractField(cache, "componentRegistry");
        StreamingMarshaller marshaller = (StreamingMarshaller)cr.getComponent(StreamingMarshaller.class, "org.infinispan.marshaller.cache");
        return (AbstractDelegatingMarshaller)marshaller;
    }

    private static class TestMarshaller
    extends AbstractMarshaller {
        private TestMarshaller() {
        }

        public Object objectFromByteBuffer(byte[] buf, int offset, int length) throws IOException, ClassNotFoundException {
            byte[] bytes = new byte[length];
            System.arraycopy(buf, offset, bytes, 0, length);
            return new String(bytes);
        }

        public boolean isMarshallable(Object o) throws Exception {
            return o instanceof String;
        }

        protected ByteBuffer objectToBuffer(Object o, int estimatedSize) throws IOException, InterruptedException {
            if (o instanceof String) {
                String str = (String)o;
                byte[] bytes = str.getBytes();
                return new ByteBufferImpl(bytes, 0, bytes.length);
            }
            throw new IllegalArgumentException("type not marshallable");
        }
    }
}

