/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.jgroups.auth;

import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServers;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.server.test.client.memcached.MemcachedClient;
import org.infinispan.server.test.util.RemoteInfinispanMBeans;
import org.infinispan.server.test.util.TestUtil;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class AuthAndEncryptProtocolTest {
    @InfinispanResource
    RemoteInfinispanServers servers;
    @ArquillianResource
    ContainerController controller;
    final String COORDINATOR_NODE = "clustered-auth-1";
    final String JOINING_NODE_FRIEND = "clustered-auth-2";
    final String COORDINATOR_NODE_NO_ENCRYPT = "clustered-auth-3";
    final String JOINING_NODE_ALIEN = "clustered-auth-4";
    final String ENCRYPT_MBEAN = "jgroups:type=protocol,cluster=\"clustered\",protocol=ENCRYPT";
    final String AUTH_MBEAN = "jgroups:type=protocol,cluster=\"clustered\",protocol=AUTH";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WithRunningServer(value={"clustered-auth-1"})
    @Test
    public void testFriendlyNodeCanJoin() throws Exception {
        try {
            this.controller.start("clustered-auth-2");
            RemoteInfinispanMBeans coordinator = RemoteInfinispanMBeans.create(this.servers, "clustered-auth-1", "memcachedCache", "clustered");
            RemoteInfinispanMBeans friend = RemoteInfinispanMBeans.create(this.servers, "clustered-auth-2", "memcachedCache", "clustered");
            MBeanServerConnectionProvider providerCoordinator = new MBeanServerConnectionProvider(coordinator.server.getHotrodEndpoint().getInetAddress().getHostName(), 9999);
            MBeanServerConnectionProvider providerFriend = new MBeanServerConnectionProvider(friend.server.getHotrodEndpoint().getInetAddress().getHostName(), 10099);
            MemcachedClient mcCoordinator = new MemcachedClient(coordinator.server.getMemcachedEndpoint().getInetAddress().getHostName(), coordinator.server.getMemcachedEndpoint().getPort());
            MemcachedClient mcFriend = new MemcachedClient(friend.server.getMemcachedEndpoint().getInetAddress().getHostName(), friend.server.getMemcachedEndpoint().getPort());
            Assert.assertEquals((long)2L, (long)coordinator.manager.getClusterSize());
            Assert.assertEquals((long)2L, (long)friend.manager.getClusterSize());
            Assert.assertEquals((Object)"secret", (Object)TestUtil.getAttribute(providerCoordinator, "jgroups:type=protocol,cluster=\"clustered\",protocol=ENCRYPT", "store_password"));
            Assert.assertEquals((Object)"secret", (Object)TestUtil.getAttribute(providerFriend, "jgroups:type=protocol,cluster=\"clustered\",protocol=ENCRYPT", "store_password"));
            Assert.assertEquals((Object)"org.jgroups.auth.X509Token", (Object)TestUtil.getAttribute(providerCoordinator, "jgroups:type=protocol,cluster=\"clustered\",protocol=AUTH", "auth_class"));
            Assert.assertEquals((Object)"org.jgroups.auth.X509Token", (Object)TestUtil.getAttribute(providerFriend, "jgroups:type=protocol,cluster=\"clustered\",protocol=AUTH", "auth_class"));
            mcFriend.set("key1", "value1");
            Assert.assertEquals((String)"Could not read replicated pair key1/value1", (Object)"value1", (Object)mcCoordinator.get("key1"));
        }
        finally {
            this.controller.stop("clustered-auth-2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WithRunningServer(value={"clustered-auth-3"})
    @Test
    public void testAlienNodeCannotJoin() throws Exception {
        try {
            this.controller.start("clustered-auth-4");
            Assert.assertEquals((long)1L, (long)this.servers.getServer("clustered-auth-3").getCacheManager("clustered").getClusterSize());
        }
        finally {
            this.controller.stop("clustered-auth-4");
        }
    }
}

