/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.query;

import java.net.URL;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.sampledomain.marshallers.MarshallerRegistration;
import org.infinispan.server.test.query.RemoteQueryTest;
import org.infinispan.server.test.util.RemoteCacheManagerFactory;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@WithRunningServer(value={"remote-query"})
public class RemoteQueryJONRegisterTest
extends RemoteQueryTest {
    @Override
    @Before
    public void setUp() throws Exception {
        this.provider = new MBeanServerConnectionProvider(this.server.getHotrodEndpoint().getInetAddress().getHostName(), 9999);
        this.rcmFactory = new RemoteCacheManagerFactory();
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host(this.server.getHotrodEndpoint().getInetAddress().getHostName()).port(this.server.getHotrodEndpoint().getPort()).marshaller((Marshaller)new ProtoStreamMarshaller());
        this.remoteCacheManager = this.rcmFactory.createManager(clientBuilder);
        this.remoteCache = this.remoteCacheManager.getCache("testcache");
        URL resource = this.getClass().getResource("/bank.protobin");
        ModelControllerClient client = ModelControllerClient.Factory.create((String)this.server.getHotrodEndpoint().getInetAddress().getHostName(), (int)9999);
        ModelNode addProtobufFileOp = RemoteQueryJONRegisterTest.getOperation("local", "upload-proto-file", new ModelNode().add().set("proto-url", resource.toString()));
        ModelNode result = client.execute(addProtobufFileOp);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        client.close();
        MarshallerRegistration.registerMarshallers((SerializationContext)ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.remoteCacheManager));
    }

    protected static PathAddress getCacheContainerAddress(String containerName) {
        return PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"infinispan")}).append("cache-container", containerName);
    }

    protected static ModelNode getOperation(String containerName, String operationName, ModelNode arguments) {
        PathAddress cacheAddress = RemoteQueryJONRegisterTest.getCacheContainerAddress(containerName);
        return Util.getOperation((String)operationName, (PathAddress)cacheAddress, (ModelNode)arguments);
    }
}

