/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.util;

import java.util.ArrayList;
import java.util.Collection;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.server.test.util.RemoteInfinispanMBeans;
import org.infinispan.server.test.util.TestUtil;

public class RemoteCacheManagerFactory {
    private Collection<RemoteCacheManager> managers = new ArrayList<RemoteCacheManager>();

    public RemoteCache<Object, Object> createCache(ConfigurationBuilder configBuilder, String cacheName) {
        return this.createManager(configBuilder).getCache(cacheName);
    }

    public RemoteCache<Object, Object> createCache(RemoteInfinispanMBeans beans) {
        return this.createManager(beans.server).getCache(beans.cacheName);
    }

    public RemoteCacheManager createManager(ConfigurationBuilder configBuilder) {
        return this.addToCollection(new RemoteCacheManager(configBuilder.build()));
    }

    public RemoteCacheManager createManager(RemoteInfinispanMBeans beans) {
        return this.createManager(beans.server);
    }

    public RemoteCacheManager createManager(RemoteInfinispanServer server) {
        return this.addToCollection(TestUtil.createCacheManager(server));
    }

    private RemoteCacheManager addToCollection(RemoteCacheManager rcm) {
        this.managers.add(rcm);
        return rcm;
    }

    public void stopManagers() {
        for (RemoteCacheManager rcm : this.managers) {
            rcm.stop();
        }
    }
}

