/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.hotrod;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.ServerStatistics;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.util.concurrent.NotifyingFuture;
import org.infinispan.server.test.client.hotrod.AbstractRemoteCacheManagerTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public abstract class AbstractRemoteCacheTest {
    private final String TEST_CACHE_NAME = "testcache";
    protected RemoteCache remoteCache;
    protected static RemoteCacheManager remoteCacheManager = null;
    protected final int ASYNC_OPS_ENTRY_LOAD = 100;

    protected abstract List<RemoteInfinispanServer> getServers();

    @Before
    public void initialize() {
        if (remoteCacheManager == null) {
            Configuration config = this.createRemoteCacheManagerConfiguration();
            remoteCacheManager = new RemoteCacheManager(config, true);
        }
        this.remoteCache = remoteCacheManager.getCache("testcache");
        this.assertCacheEmpty();
    }

    @AfterClass
    public static void release() {
        if (remoteCacheManager != null) {
            remoteCacheManager.stop();
        }
    }

    private Configuration createRemoteCacheManagerConfiguration() {
        ConfigurationBuilder config = new ConfigurationBuilder();
        for (RemoteInfinispanServer server : this.getServers()) {
            config.addServer().host(server.getHotrodEndpoint().getInetAddress().getHostName()).port(server.getHotrodEndpoint().getPort());
        }
        config.balancingStrategy("org.infinispan.server.test.client.hotrod.HotRodTestRequestBalancingStrategy").balancingStrategy("org.infinispan.client.hotrod.impl.transport.tcp.RoundRobinBalancingStrategy").forceReturnValues(false).tcpNoDelay(true).pingOnStartup(true).transportFactory("org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory").marshaller("org.infinispan.commons.marshall.jboss.GenericJBossMarshaller").asyncExecutorFactory().factoryClass("org.infinispan.client.hotrod.impl.async.DefaultAsyncExecutorFactory").addExecutorProperty("infinispan.client.hotrod.default_executor_factory.pool_size", "10").addExecutorProperty("infinispan.client.hotrod.default_executor_factory.queue_size", "100000").keySizeEstimate(64).valueSizeEstimate(512);
        if (this.isDistributedMode()) {
            config.consistentHashImpl(1, "org.infinispan.client.hotrod.impl.consistenthash.ConsistentHashV1");
        } else {
            config.consistentHashImpl(2, "org.infinispan.client.hotrod.impl.consistenthash.ConsistentHashV2");
        }
        return config.build();
    }

    private boolean isDistributedMode() {
        return "dist".equals(AbstractRemoteCacheManagerTest.getClusteringMode());
    }

    public void assertCacheEmpty() {
        this.clearServer(0);
        if (!AbstractRemoteCacheManagerTest.isLocalMode()) {
            this.clearServer(1);
        }
    }

    private void clearServer(int serverIndex) {
        while (this.remoteCache.size() != 0) {
            this.remoteCache.clear();
        }
    }

    private long numEntriesOnServer(int serverIndex) {
        return this.getServers().get(serverIndex).getCacheManager(AbstractRemoteCacheManagerTest.isLocalMode() ? "local" : "clustered").getCache("testcache").getNumberOfEntries();
    }

    @Test
    public void testReplaceWithVersionWithLifespan() throws Exception {
        int lifespanInSecs = 1;
        Assert.assertNull((Object)this.remoteCache.replace((Object)"aKey", (Object)"aValue"));
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        VersionedValue valueBinary = this.remoteCache.getVersioned((Object)"aKey");
        Assert.assertTrue((boolean)this.remoteCache.replaceWithVersion((Object)"aKey", (Object)"aNewValue", valueBinary.getVersion(), lifespanInSecs));
        VersionedValue entry2 = this.remoteCache.getVersioned((Object)"aKey");
        Assert.assertNotEquals((long)entry2.getVersion(), (long)valueBinary.getVersion());
        Assert.assertEquals((Object)"aNewValue", (Object)entry2.getValue());
        this.sleepForSecs(lifespanInSecs + 1);
        Assert.assertNull((Object)this.remoteCache.getVersioned((Object)"aKey"));
    }

    @Test
    public void testPut() throws IOException {
        Assert.assertNull((Object)this.remoteCache.put((Object)"aKey", (Object)"aValue"));
        Assert.assertTrue((boolean)this.remoteCache.containsKey((Object)"aKey"));
        Assert.assertEquals((Object)this.remoteCache.get((Object)"aKey"), (Object)"aValue");
    }

    @Test
    public void testPutWithLifespan() {
        long lifespanInSecs = 1L;
        this.remoteCache.put((Object)"lkey", (Object)"value", lifespanInSecs, TimeUnit.SECONDS);
        this.sleepForSecs(lifespanInSecs + 1L);
        Assert.assertNull((Object)this.remoteCache.get((Object)"lkey"));
    }

    @Test
    public void testSize() {
        Assert.assertEquals((long)0L, (long)this.remoteCache.size());
        Assert.assertNull((Object)this.remoteCache.put((Object)"aKey", (Object)"aValue"));
        Assert.assertTrue((boolean)this.remoteCache.containsKey((Object)"aKey"));
        Assert.assertEquals((long)this.remoteCache.size(), (long)1L);
        Assert.assertEquals((long)this.remoteCache.size(), (long)1L);
        Assert.assertNull((Object)this.remoteCache.put((Object)"anotherKey", (Object)"anotherValue"));
        Assert.assertTrue((boolean)this.remoteCache.containsKey((Object)"anotherKey"));
        Assert.assertEquals((long)this.remoteCache.size(), (long)2L);
        Assert.assertNull((Object)this.remoteCache.remove((Object)"anotherKey"));
        Assert.assertTrue((!this.remoteCache.containsKey((Object)"anotherKey") ? 1 : 0) != 0);
        Assert.assertEquals((long)this.remoteCache.size(), (long)1L);
        Assert.assertNull((Object)this.remoteCache.remove((Object)"aKey"));
        Assert.assertTrue((!this.remoteCache.containsKey((Object)"aKey") ? 1 : 0) != 0);
        Assert.assertEquals((long)this.remoteCache.size(), (long)0L);
    }

    @Test
    public void testIsEmpty() throws IOException {
        Assert.assertTrue((boolean)this.remoteCache.isEmpty());
        Assert.assertNull((Object)this.remoteCache.put((Object)"aKey", (Object)"aValue"));
        Assert.assertTrue((boolean)this.remoteCache.containsKey((Object)"aKey"));
        Assert.assertTrue((!this.remoteCache.isEmpty() ? 1 : 0) != 0);
        Assert.assertNull((Object)this.remoteCache.remove((Object)"aKey"));
        Assert.assertTrue((!this.remoteCache.containsKey((Object)"aKey") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.remoteCache.isEmpty());
    }

    @Test
    public void testContains() {
        Assert.assertTrue((!this.remoteCache.containsKey((Object)"aKey") ? 1 : 0) != 0);
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        Assert.assertTrue((boolean)this.remoteCache.containsKey((Object)"aKey"));
    }

    @Test
    public void testWithFlags() throws IOException {
        Assert.assertNull((Object)this.remoteCache.put((Object)"aKey", (Object)"aValue"));
        Assert.assertTrue((boolean)this.remoteCache.containsKey((Object)"aKey"));
        Assert.assertEquals((Object)"aValue", (Object)this.remoteCache.get((Object)"aKey"));
        Assert.assertNull((Object)this.remoteCache.put((Object)"aKey", (Object)"anotherValue"));
        Assert.assertEquals((Object)"anotherValue", (Object)this.remoteCache.get((Object)"aKey"));
        Assert.assertEquals((Object)"anotherValue", (Object)this.remoteCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)"aKey", (Object)"yetAnotherValue"));
    }

    @Test
    public void testBulkOperations() {
        HashMap<String, String> mapOut = new HashMap<String, String>();
        mapOut.put("aKey", "aValue");
        mapOut.put("bKey", "bValue");
        mapOut.put("cKey", "cValue");
        this.remoteCache.putAll(mapOut);
        Map mapIn = this.remoteCache.getBulk();
        Assert.assertEquals((Object)mapIn, mapOut);
    }

    @Test
    public void testBulkOperationsWithLifespan() {
        long lifespanInSecs = 1L;
        Map mapIn = new HashMap();
        HashMap<String, String> mapOut = new HashMap<String, String>();
        mapOut.put("aKey", "aValue");
        mapOut.put("bKey", "bValue");
        mapOut.put("cKey", "cValue");
        this.remoteCache.putAll(mapOut, lifespanInSecs, TimeUnit.SECONDS);
        this.sleepForSecs(lifespanInSecs + 1L);
        mapIn = this.remoteCache.getBulk();
        Assert.assertEquals((long)mapIn.size(), (long)0L);
    }

    @Test
    public void testGetBulkWithLimit() {
        HashMap<String, String> mapOut = new HashMap<String, String>();
        mapOut.put("aKey", "aValue");
        mapOut.put("bKey", "bValue");
        mapOut.put("cKey", "cValue");
        this.remoteCache.putAll(mapOut);
        Map mapIn = this.remoteCache.getBulk(2);
        Assert.assertEquals((long)mapIn.size(), (long)2L);
    }

    @Test
    public void testGetName() {
        Assert.assertEquals((Object)"testcache", (Object)this.remoteCache.getName());
    }

    @Test
    public void testKeySet() {
        this.remoteCache.put((Object)"k1", (Object)"v1");
        this.remoteCache.put((Object)"k2", (Object)"v2");
        this.remoteCache.put((Object)"k3", (Object)"v3");
        HashSet<String> expectedKeySet = new HashSet<String>();
        expectedKeySet.add("k1");
        expectedKeySet.add("k2");
        expectedKeySet.add("k3");
        Assert.assertEquals(expectedKeySet, (Object)this.remoteCache.keySet());
    }

    @Test
    public void testGetWithMetadata() {
        this.remoteCache.put((Object)"k1", (Object)"v1", 10000000L, TimeUnit.MICROSECONDS);
        this.remoteCache.put((Object)"k2", (Object)"v2", 10L, TimeUnit.SECONDS, 10L, TimeUnit.SECONDS);
        MetadataValue k1 = this.remoteCache.getWithMetadata((Object)"k1");
        MetadataValue k2 = this.remoteCache.getWithMetadata((Object)"k2");
        Assert.assertEquals((Object)k1.getValue(), (Object)"v1");
        Assert.assertEquals((long)k1.getLifespan(), (long)10L);
        Assert.assertEquals((long)k1.getMaxIdle(), (long)-1L);
        Assert.assertEquals((Object)k2.getValue(), (Object)"v2");
        Assert.assertEquals((long)k2.getLifespan(), (long)10L);
        Assert.assertEquals((long)k2.getMaxIdle(), (long)10L);
    }

    @Test
    public void testRemoveAsync() throws Exception {
        for (int i = 0; i <= 100; ++i) {
            this.remoteCache.put((Object)("key" + i), (Object)("value" + i));
        }
        HashSet<NotifyingFuture> futures = new HashSet<NotifyingFuture>();
        for (int i = 0; i <= 100; ++i) {
            futures.add(this.remoteCache.removeAsync((Object)("key" + i)));
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)0L, (long)this.numEntriesOnServer(0));
    }

    @Test
    public void testReplaceAsync() throws Exception {
        this.remoteCache.clear();
        for (int i = 0; i <= 100; ++i) {
            this.remoteCache.put((Object)("key" + i), (Object)("value" + i));
        }
        HashSet<NotifyingFuture> futures = new HashSet<NotifyingFuture>();
        for (int i = 0; i <= 100; ++i) {
            futures.add(this.remoteCache.replaceAsync((Object)("key" + i), (Object)("newValue" + i), -1L, TimeUnit.SECONDS, -1L, TimeUnit.SECONDS));
        }
        for (Future future : futures) {
            future.get();
        }
        for (int i = 0; i <= 100; ++i) {
            Assert.assertEquals((Object)("newValue" + i), (Object)this.remoteCache.get((Object)("key" + i)));
        }
    }

    @Test
    public void testGetVersionedCacheEntry() {
        VersionedValue value = this.remoteCache.getVersioned((Object)"aKey");
        Assert.assertNull((String)("expected null but received: " + value), (Object)this.remoteCache.getVersioned((Object)"aKey"));
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        Assert.assertEquals((Object)"aValue", (Object)this.remoteCache.get((Object)"aKey"));
        VersionedValue valueBinary = this.remoteCache.getVersioned((Object)"aKey");
        Assert.assertNotNull((Object)valueBinary);
        Assert.assertEquals((Object)valueBinary.getValue(), (Object)"aValue");
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        VersionedValue entry2 = this.remoteCache.getVersioned((Object)"aKey");
        Assert.assertEquals((Object)entry2.getValue(), (Object)"aValue");
        Assert.assertNotEquals((long)entry2.getVersion(), (long)valueBinary.getVersion());
        Assert.assertNotEquals((Object)valueBinary, (Object)entry2);
        this.remoteCache.put((Object)"aKey", (Object)"anotherValue");
        VersionedValue entry3 = this.remoteCache.getVersioned((Object)"aKey");
        Assert.assertEquals((Object)entry3.getValue(), (Object)"anotherValue");
        Assert.assertNotEquals((long)entry3.getVersion(), (long)entry2.getVersion());
        Assert.assertNotEquals((Object)entry3, (Object)entry2);
    }

    @Test
    public void testReplace() {
        Assert.assertNull((Object)this.remoteCache.replace((Object)"aKey", (Object)"anotherValue"));
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        Assert.assertNull((Object)this.remoteCache.replace((Object)"aKey", (Object)"anotherValue"));
        Assert.assertEquals((Object)this.remoteCache.get((Object)"aKey"), (Object)"anotherValue");
    }

    @Test
    public void testReplaceWithVersion() {
        Assert.assertNull((Object)this.remoteCache.replace((Object)"aKey", (Object)"aValue"));
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        VersionedValue valueBinary = this.remoteCache.getVersioned((Object)"aKey");
        Assert.assertTrue((boolean)this.remoteCache.replaceWithVersion((Object)"aKey", (Object)"aNewValue", valueBinary.getVersion()));
        VersionedValue entry2 = this.remoteCache.getVersioned((Object)"aKey");
        Assert.assertNotEquals((long)entry2.getVersion(), (long)valueBinary.getVersion());
        Assert.assertEquals((Object)entry2.getValue(), (Object)"aNewValue");
        Assert.assertTrue((!this.remoteCache.replaceWithVersion((Object)"aKey", (Object)"aNewValue", valueBinary.getVersion()) ? 1 : 0) != 0);
    }

    @Test
    public void testRemove() throws IOException {
        Assert.assertNull((Object)this.remoteCache.put((Object)"aKey", (Object)"aValue"));
        Assert.assertEquals((Object)this.remoteCache.get((Object)"aKey"), (Object)"aValue");
        Assert.assertNull((Object)this.remoteCache.remove((Object)"aKey"));
        Assert.assertTrue((!this.remoteCache.containsKey((Object)"aKey") ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveWithVersion() {
        Assert.assertTrue((!this.remoteCache.removeWithVersion((Object)"aKey", 12321212L) ? 1 : 0) != 0);
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        VersionedValue valueBinary = this.remoteCache.getVersioned((Object)"aKey");
        Assert.assertTrue((boolean)this.remoteCache.removeWithVersion((Object)"aKey", valueBinary.getVersion()));
        this.remoteCache.put((Object)"aKey", (Object)"aNewValue");
        VersionedValue entry2 = this.remoteCache.getVersioned((Object)"aKey");
        Assert.assertNotEquals((long)entry2.getVersion(), (long)valueBinary.getVersion());
        Assert.assertEquals((Object)entry2.getValue(), (Object)"aNewValue");
        Assert.assertTrue((!this.remoteCache.removeWithVersion((Object)"aKey", valueBinary.getVersion()) ? 1 : 0) != 0);
    }

    @Test
    public void testPutIfAbsent() {
        this.remoteCache.putIfAbsent((Object)"aKey", (Object)"aValue");
        Assert.assertEquals((long)this.remoteCache.size(), (long)1L);
        Assert.assertEquals((Object)this.remoteCache.get((Object)"aKey"), (Object)"aValue");
        Assert.assertNull((Object)this.remoteCache.putIfAbsent((Object)"aKey", (Object)"anotherValue"));
        Assert.assertEquals((Object)this.remoteCache.get((Object)"aKey"), (Object)"aValue");
    }

    @Test
    public void testPutIfAbsentWithLifespan() throws Exception {
        int lifespanInSecs = 1;
        this.remoteCache.putIfAbsent((Object)"aKey", (Object)"aValue", (long)lifespanInSecs, TimeUnit.SECONDS, -1L, TimeUnit.SECONDS);
        Assert.assertEquals((long)1L, (long)this.remoteCache.size());
        Assert.assertEquals((Object)"aValue", (Object)this.remoteCache.get((Object)"aKey"));
        this.sleepForSecs(lifespanInSecs + 1);
        Assert.assertEquals(null, (Object)this.remoteCache.get((Object)"akey"));
        this.remoteCache.putIfAbsent((Object)"aKey", (Object)"aValue");
        Assert.assertEquals((long)1L, (long)this.remoteCache.size());
        Assert.assertEquals((Object)"aValue", (Object)this.remoteCache.get((Object)"aKey"));
        Assert.assertEquals(null, (Object)this.remoteCache.putIfAbsent((Object)"aKey", (Object)"anotherValue", (long)lifespanInSecs, TimeUnit.SECONDS, -1L, TimeUnit.SECONDS));
        this.sleepForSecs(lifespanInSecs + 1);
        Assert.assertEquals((Object)"aValue", (Object)this.remoteCache.get((Object)"aKey"));
    }

    @Test
    public void testClear() {
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        this.remoteCache.put((Object)"aKey2", (Object)"aValue");
        this.remoteCache.clear();
        Assert.assertTrue((!this.remoteCache.containsKey((Object)"aKey") ? 1 : 0) != 0);
        Assert.assertTrue((!this.remoteCache.containsKey((Object)"aKey2") ? 1 : 0) != 0);
    }

    @Test
    public void testGetRemoteCacheManager() {
        RemoteCacheManager manager = null;
        manager = this.remoteCache.getRemoteCacheManager();
        Assert.assertEquals((String)"getRemoteCachemanager() returned incorrect value", (Object)manager, (Object)remoteCacheManager);
    }

    @Test
    public void testStats() {
        ServerStatistics remoteStats = this.remoteCache.stats();
        Assert.assertNotNull((Object)remoteStats);
        System.out.println("named stats = " + remoteStats.getStatsMap());
    }

    @Test
    public void testUnsupportedOperations() {
        try {
            this.remoteCache.remove((Object)"aKey", (Object)"aValue");
            Assert.fail((String)"call to remove() did not raise UnsupportedOperationException ");
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        try {
            this.remoteCache.removeAsync((Object)"aKey", (Object)"aValue");
            Assert.fail((String)"call to removeAsync() did not raise UnsupportedOperationException ");
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        try {
            this.remoteCache.replace((Object)"aKey", (Object)"oldValue", (Object)"newValue");
            Assert.fail((String)"call to replace() did not raise UnsupportedOperationException ");
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        try {
            this.remoteCache.replace((Object)"aKey", (Object)"oldValue", (Object)"newValue", -1L, TimeUnit.SECONDS);
            Assert.fail((String)"call to replace() did not raise UnsupportedOperationException ");
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        try {
            this.remoteCache.replace((Object)"aKey", (Object)"oldValue", (Object)"newValue", -1L, TimeUnit.SECONDS, -1L, TimeUnit.SECONDS);
            Assert.fail((String)"call to replace() did not raise UnsupportedOperationException ");
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        try {
            this.remoteCache.replaceAsync((Object)"aKey", (Object)"oldValue", (Object)"newValue");
            Assert.fail((String)"call to replaceAsync() did not raise UnsupportedOperationException ");
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        try {
            this.remoteCache.replaceAsync((Object)"aKey", (Object)"oldValue", (Object)"newValue", -1L, TimeUnit.SECONDS);
            Assert.fail((String)"call to replaceAsync() did not raise UnsupportedOperationException ");
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        try {
            this.remoteCache.replaceAsync((Object)"aKey", (Object)"oldValue", (Object)"newValue", -1L, TimeUnit.SECONDS, -1L, TimeUnit.SECONDS);
            Assert.fail((String)"call to replaceAsync() did not raise UnsupportedOperationException ");
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        try {
            this.remoteCache.containsValue((Object)"aValue");
            Assert.fail((String)"call to containsValue() did not raise UnsupportedOperationException ");
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        try {
            this.remoteCache.entrySet();
            Assert.fail((String)"call to entrySet() did not raise UnsupportedOperationException ");
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        try {
            this.remoteCache.values();
            Assert.fail((String)"call to values() did not raise UnsupportedOperationException ");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testClearAsync() throws Exception {
        this.fill(this.remoteCache, 100);
        Assert.assertEquals((long)100L, (long)this.numEntriesOnServer(0));
        NotifyingFuture future = this.remoteCache.clearAsync();
        future.get();
        Assert.assertEquals((long)0L, (long)this.numEntriesOnServer(0));
    }

    @Test
    public void testPutAsync() throws Exception {
        HashSet<NotifyingFuture> futures = new HashSet<NotifyingFuture>();
        for (int i = 0; i != 100; ++i) {
            futures.add(this.remoteCache.putAsync((Object)("key" + i), (Object)("value" + i)));
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)100L, (long)this.numEntriesOnServer(0));
        Assert.assertEquals((Object)"value99", (Object)this.remoteCache.get((Object)"key99"));
    }

    @Test
    public void testPutWithLifespanAsync() throws Exception {
        long lifespanInSecs = 10L;
        HashSet<NotifyingFuture> futures = new HashSet<NotifyingFuture>();
        for (int i = 0; i != 100; ++i) {
            futures.add(this.remoteCache.putAsync((Object)("key" + i), (Object)("value" + i), lifespanInSecs, TimeUnit.SECONDS, -1L, TimeUnit.SECONDS));
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)100L, (long)this.numEntriesOnServer(0));
        this.sleepForSecs(lifespanInSecs + 1L);
        for (int i = 0; i != 100; ++i) {
            Assert.assertEquals(null, (Object)this.remoteCache.get((Object)("key" + i)));
        }
    }

    @Test
    public void testPutIfAbsentAsync() throws Exception {
        HashSet<NotifyingFuture> futures = new HashSet<NotifyingFuture>();
        for (int i = 0; i != 100; ++i) {
            futures.add(this.remoteCache.putIfAbsentAsync((Object)("key" + i), (Object)("value" + i)));
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)100L, (long)this.numEntriesOnServer(0));
        Assert.assertEquals((Object)"value99", (Object)this.remoteCache.get((Object)"key99"));
        for (int i = 0; i != 100; ++i) {
            futures.add(this.remoteCache.putIfAbsentAsync((Object)("key" + i), (Object)("newValue" + i)));
        }
        for (Future future : futures) {
            future.get();
        }
        for (int i = 0; i != 100; ++i) {
            Assert.assertEquals((Object)("value" + i), (Object)this.remoteCache.get((Object)("key" + i)));
        }
    }

    @Test
    public void testPutIfAbsentWithLifespanAsync() throws Exception {
        long lifespanInSecs = 2L;
        HashSet<NotifyingFuture> futures = new HashSet<NotifyingFuture>();
        for (int i = 0; i != 100; ++i) {
            futures.add(this.remoteCache.putIfAbsentAsync((Object)("key" + i), (Object)("value" + i), lifespanInSecs, TimeUnit.SECONDS));
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)100L, (long)this.numEntriesOnServer(0));
        Assert.assertEquals((Object)"value99", (Object)this.remoteCache.get((Object)"key99"));
        this.sleepForSecs(lifespanInSecs + 1L);
        for (int i = 0; i != 100; ++i) {
            Assert.assertEquals(null, (Object)this.remoteCache.get((Object)("key" + i)));
        }
    }

    @Test
    public void testReplaceWithVersionWithLifespanAsync() throws Exception {
        int lifespanInSecs = 2;
        Assert.assertNull((Object)this.remoteCache.replace((Object)"aKey", (Object)"aValue"));
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        VersionedValue valueBinary = this.remoteCache.getVersioned((Object)"aKey");
        NotifyingFuture future = this.remoteCache.replaceWithVersionAsync((Object)"aKey", (Object)"aNewValue", valueBinary.getVersion(), lifespanInSecs);
        Assert.assertTrue((boolean)((Boolean)future.get()));
        VersionedValue entry2 = this.remoteCache.getVersioned((Object)"aKey");
        Assert.assertNotEquals((long)entry2.getVersion(), (long)valueBinary.getVersion());
        Assert.assertEquals((Object)"aNewValue", (Object)entry2.getValue());
        this.sleepForSecs(lifespanInSecs + 1);
        Assert.assertNull((Object)this.remoteCache.getVersioned((Object)"aKey"));
    }

    @Test
    public void testGetAsync() throws Exception {
        this.fill(this.remoteCache, 100);
        Assert.assertEquals((long)100L, (long)this.numEntriesOnServer(0));
        HashSet<NotifyingFuture> futures = new HashSet<NotifyingFuture>();
        for (int i = 0; i != 100; ++i) {
            futures.add(this.remoteCache.getAsync((Object)("key" + i)));
        }
        for (Future future : futures) {
            Assert.assertNotNull(future.get());
        }
    }

    @Test
    public void testBulkOperationsAsync() throws Exception {
        Map mapIn = new HashMap();
        HashMap mapOut = new HashMap();
        this.fill(mapOut, 100);
        NotifyingFuture future = this.remoteCache.putAllAsync(mapOut);
        future.get();
        mapIn = this.remoteCache.getBulk();
        Assert.assertEquals(mapOut, mapIn);
    }

    @Test
    public void testBulkOperationsWithLifespanAsync() throws Exception {
        long lifespanInSecs = 3L;
        Map mapIn = new HashMap();
        HashMap mapOut = new HashMap();
        this.fill(mapOut, 100);
        NotifyingFuture future = this.remoteCache.putAllAsync(mapOut, lifespanInSecs, TimeUnit.SECONDS);
        future.get();
        this.sleepForSecs(lifespanInSecs + 2L);
        mapIn = this.remoteCache.getBulk();
        Assert.assertEquals((long)0L, (long)mapIn.size());
    }

    @Test
    public void testReplaceWithVersionAsync() throws Exception {
        Assert.assertNull((Object)this.remoteCache.replace((Object)"aKey", (Object)"aValue"));
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        VersionedValue valueBinary = this.remoteCache.getVersioned((Object)"aKey");
        NotifyingFuture future = this.remoteCache.replaceWithVersionAsync((Object)"aKey", (Object)"aNewValue", valueBinary.getVersion());
        Assert.assertTrue((boolean)((Boolean)future.get()));
        VersionedValue entry2 = this.remoteCache.getVersioned((Object)"aKey");
        Assert.assertNotEquals((long)entry2.getVersion(), (long)valueBinary.getVersion());
        Assert.assertEquals((Object)"aNewValue", (Object)entry2.getValue());
        future = this.remoteCache.replaceWithVersionAsync((Object)"aKey", (Object)"aNewValue", valueBinary.getVersion());
        Assert.assertFalse((boolean)((Boolean)future.get()));
    }

    @Test
    public void testRemoveWithVersionAsync() throws Exception {
        NotifyingFuture future = null;
        future = this.remoteCache.removeWithVersionAsync((Object)"aKey", 12321212L);
        Assert.assertTrue(((Boolean)future.get() == false ? 1 : 0) != 0);
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        VersionedValue valueBinary = this.remoteCache.getVersioned((Object)"aKey");
        future = this.remoteCache.removeWithVersionAsync((Object)"aKey", valueBinary.getVersion());
        Assert.assertTrue((boolean)((Boolean)future.get()));
        this.remoteCache.put((Object)"aKey", (Object)"aNewValue");
        VersionedValue entry2 = this.remoteCache.getVersioned((Object)"aKey");
        Assert.assertNotEquals((long)entry2.getVersion(), (long)valueBinary.getVersion());
        Assert.assertEquals((Object)entry2.getValue(), (Object)"aNewValue");
        future = this.remoteCache.removeWithVersionAsync((Object)"aKey", valueBinary.getVersion());
        Assert.assertTrue(((Boolean)future.get() == false ? 1 : 0) != 0);
    }

    @Ignore
    @Test
    public void testGetVersion() throws Exception {
        Assert.assertEquals((Object)System.getProperty("version.infinispan"), (Object)this.remoteCache.getVersion());
    }

    @Test
    public void testGetProtocolVersion() throws Exception {
        Assert.assertEquals((Object)"HotRod client, protocol version :1.3", (Object)this.remoteCache.getProtocolVersion());
    }

    protected <T extends Map<String, String>> void fill(T map, int entryCount) {
        for (int i = 0; i != entryCount; ++i) {
            map.put((String)("key" + i), (String)("value" + i));
        }
    }

    protected void sleepForSecs(long numSecs) {
        try {
            Thread.sleep(numSecs * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

