/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.clusteredcache;

import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.server.test.category.UnstableTest;
import org.infinispan.server.test.client.memcached.MemcachedClient;
import org.infinispan.server.test.util.TestUtil;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@WithRunningServer(value={"clusteredcache-1", "clusteredcache-2"})
public class ClusteredCacheConfigurationTest {
    @InfinispanResource(value="clusteredcache-1")
    RemoteInfinispanServer server1;
    @InfinispanResource(value="clusteredcache-2")
    RemoteInfinispanServer server2;
    RemoteCacheManager rcm1;
    RemoteCacheManager rcm2;

    @Before
    public void setUp() {
        if (this.rcm1 == null) {
            Configuration conf = new ConfigurationBuilder().addServer().host(this.server1.getHotrodEndpoint().getInetAddress().getHostName()).port(this.server1.getHotrodEndpoint().getPort()).build();
            Configuration conf2 = new ConfigurationBuilder().addServer().host(this.server2.getHotrodEndpoint().getInetAddress().getHostName()).port(this.server2.getHotrodEndpoint().getPort()).build();
            this.rcm1 = new RemoteCacheManager(conf);
            this.rcm2 = new RemoteCacheManager(conf2);
        }
    }

    @Test
    public void testReplicationTimeout() throws Exception {
        RemoteCache rc1 = this.rcm1.getCache("remoteTimeoutCache");
        try {
            StringBuffer sb = new StringBuffer(10000000);
            for (int i = 0; i < 1000000; ++i) {
                sb.append("0123456789");
            }
            rc1.put((Object)"k1", (Object)sb.toString());
            Assert.fail((String)"A timeout exception expected but not thrown");
        }
        catch (HotRodClientException he) {
            Assert.assertTrue((boolean)he.getMessage().contains("TimeoutException"));
        }
    }

    @Test
    public void testNumOwners() throws Exception {
        RemoteCache rc1 = this.rcm1.getCache("numOwners1");
        rc1.put((Object)"entry1", (Object)"value1");
        rc1.put((Object)"entry2", (Object)"value2");
        long server1Entries = this.server1.getCacheManager("clustered").getCache("numOwners1").getNumberOfEntries();
        long server2Entries = this.server2.getCacheManager("clustered").getCache("numOwners1").getNumberOfEntries();
        Assert.assertEquals((long)2L, (long)(server1Entries + server2Entries));
    }

    @Test
    @Category(value={UnstableTest.class})
    public void testQueueFlushIntervalMemcached() throws Exception {
        final MemcachedClient mc1 = new MemcachedClient(this.server1.getMemcachedEndpoint().getInetAddress().getHostName(), this.server1.getMemcachedEndpoint().getPort());
        final MemcachedClient mc2 = new MemcachedClient(this.server2.getMemcachedEndpoint().getInetAddress().getHostName(), this.server2.getMemcachedEndpoint().getPort());
        mc1.set("k1", "v1");
        Assert.assertNotNull((Object)mc1.get("k1"));
        String value = mc2.get("k1");
        if (value == null) {
            TestUtil.eventually(new TestUtil.Condition(){

                @Override
                public boolean isSatisfied() throws Exception {
                    return mc1.get("k1") != null && mc2.get("k1") != null;
                }
            }, 3000L, 10);
        } else {
            mc1.set("k2", "v2");
            Assert.assertNotNull((Object)mc1.get("k2"));
            Assert.assertNull((Object)mc1.get("k2"));
            Thread.sleep(3000L);
            Assert.assertNotNull((Object)mc1.get("k2"));
        }
    }

    @Test
    @Category(value={UnstableTest.class})
    public void testQueueSizeHotrod() throws Exception {
        RemoteCache rc1 = this.rcm1.getCache("queueSizeCache");
        rc1.put((Object)"k1", (Object)"v1");
        rc1.put((Object)"k2", (Object)"v2");
        long server1Entries = this.server1.getCacheManager("clustered").getCache("queueSizeCache").getNumberOfEntries();
        long server2Entries = this.server2.getCacheManager("clustered").getCache("queueSizeCache").getNumberOfEntries();
        Assert.assertTrue((server1Entries + server2Entries == 2L ? 1 : 0) != 0);
        rc1.put((Object)"k3", (Object)"v3");
        rc1.put((Object)"k4", (Object)"v4");
        rc1.put((Object)"k5", (Object)"v5");
        server1Entries = this.server1.getCacheManager("clustered").getCache("queueSizeCache").getNumberOfEntries();
        server2Entries = this.server2.getCacheManager("clustered").getCache("queueSizeCache").getNumberOfEntries();
        Assert.assertTrue((server1Entries + server2Entries == 8L ? 1 : 0) != 0);
    }
}

