/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.cs.custom;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.management.ObjectName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.server.test.category.CacheStore;
import org.infinispan.server.test.util.TestUtil;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={CacheStore.class})
public class CustomCacheStoreTest {
    @InfinispanResource(value="standalone-customcs")
    RemoteInfinispanServer server;
    final int managementPort = 9999;
    final String cacheLoaderMBean = "jboss.infinispan:type=Cache,name=\"default(local)\",manager=\"local\",component=CacheLoader";

    @BeforeClass
    public static void before() {
        String serverDir = System.getProperty("server1.dist");
        File ispnCoreJarDir = new File(serverDir + "/modules/system/layers/base/org/infinispan/main/");
        WildcardFileFilter ispnCoreJarFilter = new WildcardFileFilter("infinispan-core*.jar");
        File ispnCoreJar = ispnCoreJarDir.listFiles((FileFilter)ispnCoreJarFilter)[0];
        String customLoaderClassesDir = System.getProperty("basedir") + "/target/test-classes/org/infinispan/persistence/cluster/";
        File[] csClasses = new File[]{new File(customLoaderClassesDir + "MyCustomCacheStore.class"), new File(customLoaderClassesDir + "MyCustomCacheStoreConfiguration.class"), new File(customLoaderClassesDir + "MyCustomCacheStoreConfigurationBuilder.class")};
        CustomCacheStoreTest.addFilesToZip(ispnCoreJar, csClasses, "org/infinispan/persistence/cluster/");
    }

    @Test
    @WithRunningServer(value={"standalone-customcs"})
    public void test() throws Exception {
        RemoteCacheManager rcm = TestUtil.createCacheManager(this.server);
        RemoteCache rc = rcm.getCache();
        Assert.assertNull((Object)rc.get((Object)"key1"));
        rc.put((Object)"key1", (Object)"value1");
        Assert.assertEquals((Object)"value1", (Object)rc.get((Object)"key1"));
        MBeanServerConnectionProvider provider = new MBeanServerConnectionProvider(this.server.getHotrodEndpoint().getInetAddress().getHostName(), 9999);
        Assert.assertEquals((Object)"[org.infinispan.persistence.cluster.MyCustomCacheStore]", (Object)this.getAttribute(provider, "jboss.infinispan:type=Cache,name=\"default(local)\",manager=\"local\",component=CacheLoader", "stores"));
    }

    private String getAttribute(MBeanServerConnectionProvider provider, String mbean, String attr) throws Exception {
        return provider.getConnection().getAttribute(new ObjectName(mbean), attr).toString();
    }

    public static void addFilesToZip(File source, File[] files, String path) {
        try {
            File tmpZip = new File(source.getAbsolutePath() + ".tmp");
            FileUtils.copyFile((File)source, (File)tmpZip);
            byte[] buffer = new byte[4096];
            ZipInputStream zin = new ZipInputStream(new FileInputStream(tmpZip));
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(source));
            for (int i = 0; i < files.length; ++i) {
                FileInputStream in = new FileInputStream(files[i]);
                out.putNextEntry(new ZipEntry(path + files[i].getName()));
                int read = ((InputStream)in).read(buffer);
                while (read > -1) {
                    out.write(buffer, 0, read);
                    read = ((InputStream)in).read(buffer);
                }
                out.closeEntry();
                ((InputStream)in).close();
            }
            ZipEntry ze = zin.getNextEntry();
            while (ze != null) {
                if (!CustomCacheStoreTest.zipEntryMatch(ze.getName(), files, path)) {
                    out.putNextEntry(ze);
                    int read = zin.read(buffer);
                    while (read > -1) {
                        out.write(buffer, 0, read);
                        read = zin.read(buffer);
                    }
                    out.closeEntry();
                }
                ze = zin.getNextEntry();
            }
            out.close();
            tmpZip.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean zipEntryMatch(String zeName, File[] files, String path) {
        for (int i = 0; i < files.length; ++i) {
            if (!(path + files[i].getName()).equals(zeName)) continue;
            return true;
        }
        return false;
    }
}

