/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.cs.remote;

import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.server.test.category.CacheStore;
import org.infinispan.server.test.client.memcached.MemcachedClient;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={CacheStore.class})
@WithRunningServer(value={"standalone-rcs-remote"})
public class RemoteCacheStoreTest {
    private final String CONTAINER_LOCAL = "standalone-rcs-local";
    private final String CONTAINER_REMOTE = "standalone-rcs-remote";
    public static final String LOCAL_CACHE_MANAGER = "local";
    private final String LOCAL_CACHE_NAME = "memcachedCache";
    private final String READONLY_CACHE_NAME = "readOnlyCache";
    private final String HOTROD_CACHE_NAME = "hotrodCache";
    private MemcachedClient mc;
    RemoteCache<Object, Object> cache;
    @InfinispanResource(value="standalone-rcs-local")
    RemoteInfinispanServer server1;
    @InfinispanResource(value="standalone-rcs-remote")
    RemoteInfinispanServer server2;
    @ArquillianResource
    ContainerController controller;
    RemoteCacheManager rcm1;

    @Before
    public void setUp() throws Exception {
        Configuration conf = new ConfigurationBuilder().addServer().host(this.server2.getHotrodEndpoint().getInetAddress().getHostName()).port(this.server2.getHotrodEndpoint().getPort()).build();
        this.cache = new RemoteCacheManager(conf).getCache();
    }

    @Test
    @WithRunningServer(value={"standalone-rcs-local"})
    public void testReadOnly() throws Exception {
        Configuration conf = new ConfigurationBuilder().addServer().host(this.server1.getHotrodEndpoint().getInetAddress().getHostName()).port(this.server1.getHotrodEndpoint().getPort()).build();
        this.rcm1 = new RemoteCacheManager(conf);
        RemoteCache rc1 = this.rcm1.getCache("readOnlyCache");
        rc1.put((Object)"k1", (Object)"v1");
        rc1.put((Object)"k2", (Object)"v2");
        rc1.put((Object)"k3", (Object)"v3");
        Assert.assertEquals((long)0L, (long)this.server2.getCacheManager(LOCAL_CACHE_MANAGER).getDefaultCache().getNumberOfEntries());
        Assert.assertEquals((long)2L, (long)this.server1.getCacheManager(LOCAL_CACHE_MANAGER).getCache("readOnlyCache").getNumberOfEntries());
        Assert.assertNull((Object)rc1.get((Object)"k1"));
        Assert.assertEquals((Object)"v2", (Object)rc1.get((Object)"k2"));
        Assert.assertEquals((Object)"v3", (Object)rc1.get((Object)"k3"));
    }

    @Test
    @WithRunningServer(value={"standalone-rcs-local"})
    public void testPassivateAfterEviction() throws Exception {
        this.mc = new MemcachedClient(this.server1.getMemcachedEndpoint().getInetAddress().getHostName(), this.server1.getMemcachedEndpoint().getPort());
        this.assertCleanCacheAndStore();
        this.mc.set("k1", "v1");
        this.mc.set("k2", "v2");
        Assert.assertEquals((long)0L, (long)this.server2.getCacheManager(LOCAL_CACHE_MANAGER).getDefaultCache().getNumberOfEntries());
        this.mc.set("k3", "v3");
        Assert.assertEquals((long)2L, (long)this.server1.getCacheManager(LOCAL_CACHE_MANAGER).getCache("memcachedCache").getNumberOfEntries());
        Assert.assertEquals((long)1L, (long)this.server2.getCacheManager(LOCAL_CACHE_MANAGER).getDefaultCache().getNumberOfEntries());
        Assert.assertEquals((Object)"v1", (Object)this.mc.get("k1"));
        Assert.assertEquals((Object)"v2", (Object)this.mc.get("k2"));
        Assert.assertEquals((Object)"v3", (Object)this.mc.get("k3"));
        this.mc.delete("k1");
        this.mc.delete("k2");
        this.mc.delete("k3");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @WithRunningServer(value={"standalone-rcs-local"})
    public void testSocketTimeoutForRemoteStore() throws Exception {
        Configuration conf = new ConfigurationBuilder().addServer().host(this.server1.getHotrodEndpoint().getInetAddress().getHostName()).port(this.server1.getHotrodEndpoint().getPort()).build();
        this.rcm1 = new RemoteCacheManager(conf);
        RemoteCache rc1 = this.rcm1.getCache("hotrodCache");
        try {
            this.rcm1.getCache("hotrodCache").clear();
            StringBuffer sb = new StringBuffer(30000000);
            for (int i = 0; i < 3000000; ++i) {
                sb.append("0123456789");
            }
            Assert.assertEquals((long)0L, (long)this.server1.getCacheManager(LOCAL_CACHE_MANAGER).getCache("hotrodCache").getNumberOfEntries());
            rc1.put((Object)"k1", (Object)sb.toString());
            rc1.put((Object)"k2", (Object)sb.toString());
            Assert.assertEquals((Object)sb.toString(), (Object)rc1.get((Object)"k1"));
            Assert.assertEquals((Object)sb.toString(), (Object)rc1.get((Object)"k2"));
            Assert.assertEquals((long)2L, (long)this.server1.getCacheManager(LOCAL_CACHE_MANAGER).getCache("hotrodCache").getNumberOfEntries());
            rc1.put((Object)"k3", (Object)sb.toString());
            Assert.fail((String)"Socket timeout for remote store was set to 1 millis and so a SocketTimeoutException was expected but not thrown.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("SocketTimeoutException"));
        }
        finally {
            this.controller.kill("standalone-rcs-local");
        }
    }

    private void assertCleanCacheAndStore() throws Exception {
        this.mc.delete("k1");
        this.mc.delete("k2");
        this.mc.delete("k3");
        this.cache.clear();
        Assert.assertEquals((long)0L, (long)this.server1.getCacheManager(LOCAL_CACHE_MANAGER).getCache("memcachedCache").getNumberOfEntries());
        Assert.assertEquals((long)0L, (long)this.server2.getCacheManager(LOCAL_CACHE_MANAGER).getDefaultCache().getNumberOfEntries());
    }
}

