/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.eviction;

import java.util.Arrays;
import java.util.List;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.server.test.category.UnstableTest;
import org.infinispan.server.test.util.TestUtil;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@WithRunningServer(value={"eviction"})
public class EvictionStrategyTest {
    @InfinispanResource(value="eviction")
    RemoteInfinispanServer server1;
    private static RemoteCacheManager remoteCacheManager;

    @Before
    public void setUp() {
        if (remoteCacheManager == null) {
            remoteCacheManager = TestUtil.createCacheManager(this.server1);
        }
    }

    @Test
    public void testEvictionStrategyNone() {
        RemoteCache rc = remoteCacheManager.getCache("none");
        rc.clear();
        this.storeKeys((RemoteCache<String, String>)rc, "A", "B", "C");
        rc.put((Object)"keyD", (Object)"D");
        Assert.assertTrue((boolean)"A".equals(rc.get((Object)"keyA")));
        Assert.assertTrue((boolean)"B".equals(rc.get((Object)"keyB")));
        Assert.assertTrue((boolean)"C".equals(rc.get((Object)"keyC")));
        Assert.assertTrue((boolean)"D".equals(rc.get((Object)"keyD")));
    }

    @Test
    @Category(value={UnstableTest.class})
    public void testEvictionStrategyLRU() {
        RemoteCache rc = remoteCacheManager.getCache("lru");
        rc.clear();
        this.storeKeys((RemoteCache<String, String>)rc, "A", "B", "C");
        Assert.assertTrue((boolean)"B".equals(rc.get((Object)"keyB")));
        Assert.assertTrue((boolean)"A".equals(rc.get((Object)"keyA")));
        rc.put((Object)"keyD", (Object)"D");
        Assert.assertTrue((boolean)"A".equals(rc.get((Object)"keyA")));
        Assert.assertTrue((boolean)"B".equals(rc.get((Object)"keyB")));
        Assert.assertTrue((boolean)"D".equals(rc.get((Object)"keyD")));
        Assert.assertNull((Object)rc.get((Object)"keyC"));
    }

    private void storeKeys(RemoteCache<String, String> rc, String ... values) {
        this.storeKeys(rc, Arrays.asList(values));
    }

    private void storeKeys(RemoteCache<String, String> rc, List<String> values) {
        for (String value : values) {
            rc.put((Object)("key" + value), (Object)value);
        }
    }
}

