/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.jmxmanagement.suppress.statetransfer;

import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.server.test.jmxmanagement.suppress.statetransfer.AbstractStateTransferSuppressTest;
import org.infinispan.server.test.util.RemoteCacheManagerFactory;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class StateTransferSuppressForHotrodTest
extends AbstractStateTransferSuppressTest {
    private static final String CACHE_MANAGER_NAME = "clustered";
    private static final String CACHE_NAME = "default";
    private RemoteCacheManagerFactory rcmFactory;
    private RemoteCache cache1;
    private RemoteCache cache2;

    @Override
    protected void prepare() {
        this.rcmFactory = new RemoteCacheManagerFactory();
        this.cache1 = this.rcmFactory.createCache(this.mbean(0));
        this.cache2 = this.rcmFactory.createCache(this.mbean(1));
        this.providers.add(new MBeanServerConnectionProvider(this.server(0).getHotrodEndpoint().getInetAddress().getHostName(), 9999));
        this.providers.add(new MBeanServerConnectionProvider(this.server(1).getHotrodEndpoint().getInetAddress().getHostName(), 10099));
    }

    @Override
    protected void destroy() {
        if (null != this.rcmFactory) {
            this.rcmFactory.stopManagers();
        }
        this.rcmFactory = null;
    }

    @Override
    protected void putDataIntoCache(int count) {
        for (int i = 0; i < count; ++i) {
            this.cache1.put((Object)("key" + i), (Object)("value" + i));
        }
        Assert.assertTrue((String)"The size of both caches should be equal.", (this.cache1.size() == this.cache2.size() ? 1 : 0) != 0);
        Assert.assertEquals((long)count, (long)this.cache1.size());
        Assert.assertEquals((long)count, (long)this.cache2.size());
    }

    @Override
    protected String getCacheManagerName() {
        return CACHE_MANAGER_NAME;
    }

    @Override
    protected String getCacheName() {
        return CACHE_NAME;
    }

    @Override
    protected void createNewProvider() {
        this.providers.add(new MBeanServerConnectionProvider(this.server(2).getHotrodEndpoint().getInetAddress().getHostName(), 10199));
    }
}

