/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.l1;

import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.server.test.client.memcached.MemcachedClient;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@WithRunningServer(value={"l1-1", "l1-2"})
public class L1CachingTestCase {
    final String CONTAINER1 = "l1-1";
    final String CONTAINER2 = "l1-2";
    @InfinispanResource(value="l1-1")
    RemoteInfinispanServer server1;
    @InfinispanResource(value="l1-2")
    RemoteInfinispanServer server2;
    static final String ENCODING = "UTF-8";
    private MemcachedClient mc1;
    private MemcachedClient mc2;

    @Before
    public void setUp() throws Exception {
        this.mc1 = new MemcachedClient(ENCODING, this.server1.getMemcachedEndpoint().getInetAddress().getHostName(), this.server1.getMemcachedEndpoint().getPort(), 10000);
        this.mc2 = new MemcachedClient(ENCODING, this.server2.getMemcachedEndpoint().getInetAddress().getHostName(), this.server2.getMemcachedEndpoint().getPort(), 10000);
        this.mc1.delete("KeyA");
        this.mc2.delete("KeyA");
        this.mc1.delete("KeyB");
        this.mc2.delete("KeyB");
        this.mc2.delete("KeyBB");
        this.mc2.delete("KeyBB");
        this.mc1.delete("KeyC");
        this.mc2.delete("KeyC");
    }

    @After
    public void tearDown() throws Exception {
        if (this.mc1 != null) {
            this.mc1.close();
        }
        if (this.mc2 != null) {
            this.mc2.close();
        }
    }

    @Test
    public void testL1CachingEnabled() throws Exception {
        this.mc1.set("KeyA", "A");
        this.mc1.set("KeyB", "B");
        this.mc1.set("KeyC", "C");
        Assert.assertTrue((String)"Distribution of entries is wrong (at least unexpected).", (this.server1.getCacheManager("clustered").getCache("memcachedCache").getNumberOfEntries() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"Distribution of entries is wrong (at least unexpected).", (this.server2.getCacheManager("clustered").getCache("memcachedCache").getNumberOfEntries() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((String)"More entries in caches than expected.", (long)3L, (long)(this.server1.getCacheManager("clustered").getCache("memcachedCache").getNumberOfEntries() + this.server2.getCacheManager("clustered").getCache("memcachedCache").getNumberOfEntries()));
        Assert.assertTrue((boolean)"A".equals(this.mc2.get("KeyA")));
        Assert.assertTrue((boolean)"B".equals(this.mc2.get("KeyB")));
        Assert.assertTrue((boolean)"C".equals(this.mc2.get("KeyC")));
        Assert.assertEquals((String)"Number of hits on server 1 is wrong.", (long)0L, (long)this.server1.getCacheManager("clustered").getCache("memcachedCache").getHits());
        Assert.assertEquals((String)"Number of hits on server 2 is wrong.", (long)3L, (long)this.server2.getCacheManager("clustered").getCache("memcachedCache").getHits());
        Assert.assertEquals((String)"Number of stores on server 1 is wrong.", (long)3L, (long)this.server1.getCacheManager("clustered").getCache("memcachedCache").getStores());
        Assert.assertEquals((String)"Number of stores on server 2 is wrong.", (long)0L, (long)this.server2.getCacheManager("clustered").getCache("memcachedCache").getStores());
        Assert.assertTrue((String)"The are no entries in L1 cache! L1 seems to be disabled! Check TRACE [org.infinispan.factories.ComponentRegistry] output.", (this.server1.getCacheManager("clustered").getCache("memcachedCache").getNumberOfEntries() + this.server2.getCacheManager("clustered").getCache("memcachedCache").getNumberOfEntries() > 3L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)"A".equals(this.mc1.get("KeyA")));
        Assert.assertTrue((boolean)"B".equals(this.mc1.get("KeyB")));
        Assert.assertTrue((boolean)"C".equals(this.mc1.get("KeyC")));
        Assert.assertEquals((String)"Number of hits on server 1 is wrong.", (long)3L, (long)this.server1.getCacheManager("clustered").getCache("memcachedCache").getHits());
        Assert.assertEquals((String)"Number of hits on server 2 is wrong.", (long)3L, (long)this.server2.getCacheManager("clustered").getCache("memcachedCache").getHits());
        Assert.assertEquals((String)"Number of stores on server 1 is wrong.", (long)3L, (long)this.server1.getCacheManager("clustered").getCache("memcachedCache").getStores());
        Assert.assertEquals((String)"Number of stores on server 2 is wrong.", (long)0L, (long)this.server2.getCacheManager("clustered").getCache("memcachedCache").getStores());
        Assert.assertEquals((String)"The are no entries in L1 cache! L1 seems to be disabled! Check TRACE [org.infinispan.factories.ComponentRegistry] output.", (long)6L, (long)(this.server1.getCacheManager("clustered").getCache("memcachedCache").getNumberOfEntries() + this.server2.getCacheManager("clustered").getCache("memcachedCache").getNumberOfEntries()));
    }
}

