/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.rest.security;

import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.server.test.client.rest.RESTHelper;
import org.jboss.arquillian.container.test.api.Config;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class RESTBasicSecurityTest {
    private static final String SERVER_CONFIG_PROPERTY = "serverConfig";
    private static final String CONFIG_READ_WRITE_SECURED = "testsuite/rest-sec-basic-rw.xml";
    private static final String TEST_USER_NAME = "testuser";
    private static final String TEST_USER_PASSWORD = "testpassword";
    private static final String KEY_D = "d";
    private static final String CONTAINER1 = "rest-security-basic";
    @InfinispanResource(value="rest-security-basic")
    RemoteInfinispanServer server1;
    @ArquillianResource
    ContainerController controller;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @InSequence(value=1)
    public void testSecuredWriteOperations() throws Exception {
        try {
            this.controller.start(CONTAINER1);
            RESTHelper.addServer(this.server1.getRESTEndpoint().getInetAddress().getHostName(), this.server1.getRESTEndpoint().getContextPath());
            RESTHelper.setCredentials(TEST_USER_NAME, TEST_USER_PASSWORD);
            RESTHelper.put(RESTHelper.fullPathKey("a"), "data", "application/text", 200);
            RESTHelper.clearCredentials();
            RESTHelper.put(RESTHelper.fullPathKey("b"), "data", "application/text", 401);
            RESTHelper.setCredentials(TEST_USER_NAME, TEST_USER_PASSWORD);
            RESTHelper.post(RESTHelper.fullPathKey("c"), "data", "application/text", 200);
            RESTHelper.clearCredentials();
            RESTHelper.post(RESTHelper.fullPathKey(KEY_D), "data", "application/text", 401);
            RESTHelper.get(RESTHelper.fullPathKey("a"), "data");
            RESTHelper.head(RESTHelper.fullPathKey("a"), 200);
            RESTHelper.delete(RESTHelper.fullPathKey("a"), 401, new Object[0]);
            RESTHelper.setCredentials(TEST_USER_NAME, TEST_USER_PASSWORD);
            RESTHelper.delete(RESTHelper.fullPathKey("a"), 200, new Object[0]);
            RESTHelper.delete(RESTHelper.fullPathKey("c"), 200, new Object[0]);
            RESTHelper.clearCredentials();
        }
        finally {
            this.controller.stop(CONTAINER1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @InSequence(value=2)
    public void testSecuredReadWriteOperations() throws Exception {
        try {
            this.controller.start(CONTAINER1, new Config().add(SERVER_CONFIG_PROPERTY, CONFIG_READ_WRITE_SECURED).map());
            RESTHelper.setCredentials(TEST_USER_NAME, TEST_USER_PASSWORD);
            RESTHelper.put(RESTHelper.fullPathKey("a"), "data", "application/text", 200);
            RESTHelper.clearCredentials();
            RESTHelper.put(RESTHelper.fullPathKey("b"), "data", "application/text", 401);
            RESTHelper.setCredentials(TEST_USER_NAME, TEST_USER_PASSWORD);
            RESTHelper.post(RESTHelper.fullPathKey("c"), "data", "application/text", 200);
            RESTHelper.clearCredentials();
            RESTHelper.post(RESTHelper.fullPathKey(KEY_D), "data", "application/text", 401);
            RESTHelper.get(RESTHelper.fullPathKey("a"), 401);
            RESTHelper.setCredentials(TEST_USER_NAME, TEST_USER_PASSWORD);
            RESTHelper.get(RESTHelper.fullPathKey("a"), "data");
            RESTHelper.clearCredentials();
            RESTHelper.head(RESTHelper.fullPathKey("a"), 401);
            RESTHelper.setCredentials(TEST_USER_NAME, TEST_USER_PASSWORD);
            RESTHelper.head(RESTHelper.fullPathKey("a"), 200);
            RESTHelper.clearCredentials();
            RESTHelper.delete(RESTHelper.fullPathKey("a"), 401, new Object[0]);
            RESTHelper.setCredentials(TEST_USER_NAME, TEST_USER_PASSWORD);
            RESTHelper.delete(RESTHelper.fullPathKey("a"), 200, new Object[0]);
            RESTHelper.delete(RESTHelper.fullPathKey("c"), 200, new Object[0]);
            RESTHelper.clearCredentials();
        }
        finally {
            this.controller.stop(CONTAINER1);
        }
    }
}

