/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.cachecontainer;

import java.util.Scanner;
import javax.management.ObjectName;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@WithRunningServer(value={@RunningServer(name="cachecontainer")})
public class CacheContainerTest {
    @InfinispanResource(value="cachecontainer")
    RemoteInfinispanServer server1;
    final int managementPort = 9999;
    final String dumpServicesBean = "jboss.msc:type=container,name=jboss-as";
    final String dumpServicesOp = "dumpServicesToString";
    RemoteCacheManager rcm1;
    RemoteCacheManager rcm2;
    MBeanServerConnectionProvider provider;

    @Before
    public void setUp() {
        if (this.rcm1 == null) {
            this.provider = new MBeanServerConnectionProvider(this.server1.getHotrodEndpoint().getInetAddress().getHostName(), 9999);
            Configuration conf = new ConfigurationBuilder().addServer().host(this.server1.getHotrodEndpoint().getInetAddress().getHostName()).port(this.server1.getHotrodEndpoint().getPort()).build();
            Configuration conf2 = new ConfigurationBuilder().addServer().host(this.server1.getHotrodEndpoint("hotrodconnector2").getInetAddress().getHostName()).port(this.server1.getHotrodEndpoint("hotrodconnector2").getPort()).build();
            this.rcm1 = new RemoteCacheManager(conf);
            this.rcm2 = new RemoteCacheManager(conf2);
        }
    }

    @Test
    public void testEndpointConfiguration() throws Exception {
        RemoteCache cache1 = this.rcm1.getCache("default");
        RemoteCache cache2 = this.rcm2.getCache("default");
        cache1.put((Object)"key", (Object)"value");
        cache2.put((Object)"key2", (Object)"value2");
        Assert.assertTrue((1L == this.server1.getCacheManager("default").getCache("default").getNumberOfEntries() ? 1 : 0) != 0);
        Assert.assertTrue((1L == this.server1.getCacheManager("special-cache-container").getCache("default").getNumberOfEntries() ? 1 : 0) != 0);
        cache1.remove((Object)"key");
        cache2.remove((Object)"key2");
    }

    @Test
    public void testDefaultCacheAttribute() throws Exception {
        RemoteCache cache = this.rcm2.getCache();
        cache.put((Object)"key", (Object)"value");
        Assert.assertTrue((1L == this.server1.getCacheManager("special-cache-container").getCache("special-cache").getNumberOfEntries() ? 1 : 0) != 0);
        Assert.assertTrue((0L == this.server1.getCacheManager("special-cache-container").getCache("default").getNumberOfEntries() ? 1 : 0) != 0);
        cache.remove((Object)"key");
    }

    @Test
    public void testExecutorAttributesAndStartMode() throws Exception {
        String services = this.provider.getConnection().invoke(new ObjectName("jboss.msc:type=container,name=jboss-as"), "dumpServicesToString", null, null).toString();
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        String executorPrefix = "jboss.thread.executor.";
        Scanner s = new Scanner(services).useDelimiter("\n");
        try {
            while (true) {
                String dependencies;
                String line;
                if ((line = s.nextLine()).contains("Service \"jboss.infinispan.default.config\"") && line.contains("dependencies:") && (dependencies = line.substring(line.indexOf("dependencies:"))).contains("jboss.thread.executor.test-infinispan-repl-queue") && dependencies.contains("jboss.thread.executor.test-infinispan-listener") && dependencies.contains("jboss.thread.executor.test-infinispan-eviction")) {
                    b1 = true;
                }
                if (line.contains("Service \"jboss.infinispan.special-cache-container\"") && line.contains("mode ACTIVE state UP")) {
                    b2 = true;
                }
                if (!line.contains("Service \"jboss.infinispan.default\"") || !line.contains("mode ON_DEMAND state UP")) continue;
                b3 = true;
            }
        }
        catch (Exception e) {
            Assert.assertTrue((b1 && b2 && b3 ? 1 : 0) != 0);
            return;
        }
    }
}

