/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.hotrod.osgi;

import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.sampledomain.Address;
import org.infinispan.protostream.sampledomain.User;
import org.infinispan.protostream.sampledomain.marshallers.AccountMarshaller;
import org.infinispan.protostream.sampledomain.marshallers.AddressMarshaller;
import org.infinispan.protostream.sampledomain.marshallers.GenderMarshaller;
import org.infinispan.protostream.sampledomain.marshallers.LimitsMarshaller;
import org.infinispan.protostream.sampledomain.marshallers.TransactionMarshaller;
import org.infinispan.protostream.sampledomain.marshallers.UserMarshaller;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.server.test.category.Osgi;
import org.infinispan.server.test.util.osgi.KarafTestSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.options.MavenUrlReference;
import org.ops4j.pax.exam.options.RawUrlReference;
import org.ops4j.pax.exam.options.UrlReference;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerClass;

@RunWith(value=PaxExam.class)
@Category(value={Osgi.class})
@ExamReactorStrategy(value={PerClass.class})
public class RemoteCacheOsgiTest
extends KarafTestSupport {
    private final String SERVER_HOST = "localhost";
    private final int HOTROD_PORT = 11222;
    private final String DEFAULT_CACHE = "notindexed";
    private final String INDEXED_CACHE = "testcache";
    private final String KARAF_VERSION = System.getProperty("version.karaf", "2.3.3");
    private final String RESOURCES_DIR = System.getProperty("resources.dir", System.getProperty("java.io.tmpdir"));
    private ConfigurationBuilder builder;
    private RemoteCacheManager manager;

    @Configuration
    public Option[] config() throws Exception {
        return new Option[]{KarafDistributionOption.karafDistributionConfiguration().frameworkUrl((MavenUrlReference)CoreOptions.maven().groupId("org.apache.karaf").artifactId("apache-karaf").type("zip").version(this.KARAF_VERSION)).karafVersion(this.KARAF_VERSION), KarafDistributionOption.features((UrlReference)CoreOptions.maven().groupId("org.infinispan").artifactId("infinispan-client-hotrod").type("xml").classifier("features").versionAsInProject(), (String[])new String[]{"hotrod-client-with-query"}), KarafDistributionOption.features((UrlReference)new RawUrlReference("file:///" + this.RESOURCES_DIR.replace("\\", "/") + "/test-features.xml"), (String[])new String[]{"query-sample-domain"}), KarafDistributionOption.editConfigurationFileExtend((String)"etc/jre.properties", (String)"jre-1.7", (String)"sun.misc"), KarafDistributionOption.editConfigurationFileExtend((String)"etc/jre.properties", (String)"jre-1.6", (String)"sun.misc"), KarafDistributionOption.keepRuntimeFolder()};
    }

    @Before
    public void setUp() {
        this.builder = new ConfigurationBuilder();
        this.builder.addServer().host("localhost").port(11222);
    }

    @After
    public void tearDown() {
        if (this.manager != null) {
            this.manager.stop();
        }
    }

    @Test
    public void testCustomObjectPutGet() {
        Person p = new Person("Martin");
        this.manager = new RemoteCacheManager(this.builder.build());
        RemoteCache cache = this.manager.getCache("notindexed");
        cache.put((Object)"k1", (Object)p);
        Assert.assertEquals((Object)p, (Object)cache.get((Object)"k1"));
    }

    @Test
    public void testAttributeQuery() throws Exception {
        this.builder.marshaller((Marshaller)new ProtoStreamMarshaller());
        this.manager = new RemoteCacheManager(this.builder.build());
        RemoteCache cache = this.manager.getCache("testcache");
        SerializationContext ctx = ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.manager);
        URL resourceUrl = this.bundleContext.getBundle().getResource("/sample_bank_account/bank.protobin");
        ctx.registerProtofile(resourceUrl.openStream());
        ctx.registerMarshaller((BaseMarshaller)new UserMarshaller());
        ctx.registerMarshaller((BaseMarshaller)new GenderMarshaller());
        ctx.registerMarshaller((BaseMarshaller)new AddressMarshaller());
        ctx.registerMarshaller((BaseMarshaller)new AccountMarshaller());
        ctx.registerMarshaller((BaseMarshaller)new LimitsMarshaller());
        ctx.registerMarshaller((BaseMarshaller)new TransactionMarshaller());
        cache.put((Object)1, (Object)this.createUser1());
        cache.put((Object)2, (Object)this.createUser2());
        User fromCache = (User)cache.get((Object)1);
        this.assertUser(fromCache);
        QueryFactory qf = Search.getQueryFactory((RemoteCache)cache);
        Query query = qf.from(User.class).having("name").eq((Object)"Tom").toBuilder().build();
        List list = query.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(User.class, ((User)list.get(0)).getClass());
        this.assertUser((User)list.get(0));
    }

    private User createUser1() {
        User user = new User();
        user.setId(1);
        user.setName("Tom");
        user.setSurname("Cat");
        user.setGender(User.Gender.MALE);
        user.setAccountIds(Collections.singletonList(12));
        Address address = new Address();
        address.setStreet("Dark Alley");
        address.setPostCode("1234");
        user.setAddresses(Collections.singletonList(address));
        return user;
    }

    private User createUser2() {
        User user = new User();
        user.setId(1);
        user.setName("Adrian");
        user.setSurname("Nistor");
        user.setGender(User.Gender.MALE);
        Address address = new Address();
        address.setStreet("Old Street");
        address.setPostCode("XYZ");
        user.setAddresses(Collections.singletonList(address));
        return user;
    }

    private void assertUser(User user) {
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((long)1L, (long)user.getId());
        Assert.assertEquals((Object)"Tom", (Object)user.getName());
        Assert.assertEquals((Object)"Cat", (Object)user.getSurname());
        Assert.assertEquals((Object)User.Gender.MALE, (Object)user.getGender());
        Assert.assertNotNull((Object)user.getAccountIds());
        Assert.assertEquals((long)1L, (long)user.getAccountIds().size());
        Assert.assertEquals((long)12L, (long)((Integer)user.getAccountIds().get(0)).intValue());
        Assert.assertNotNull((Object)user.getAddresses());
        Assert.assertEquals((long)1L, (long)user.getAddresses().size());
        Assert.assertEquals((Object)"Dark Alley", (Object)((Address)user.getAddresses().get(0)).getStreet());
        Assert.assertEquals((Object)"1234", (Object)((Address)user.getAddresses().get(0)).getPostCode());
    }

    static class Person
    implements Serializable {
        final String name;

        public Person(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            return this.name.equals(person.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

