/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.rest;

import java.net.URI;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.server.test.category.RESTClustered;
import org.infinispan.server.test.category.UnstableClientClusteredTest;
import org.infinispan.server.test.client.rest.RESTHelper;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={RESTClustered.class, UnstableClientClusteredTest.class})
public class RESTAsyncTest {
    @InfinispanResource(value="container1")
    RemoteInfinispanServer server1;
    @InfinispanResource(value="container2")
    RemoteInfinispanServer server2;

    @Before
    public void setUp() throws Exception {
        RESTHelper.addServer(this.server1.getRESTEndpoint().getInetAddress().getHostName(), this.server1.getRESTEndpoint().getContextPath());
        RESTHelper.addServer(this.server2.getRESTEndpoint().getInetAddress().getHostName(), this.server2.getRESTEndpoint().getContextPath());
        RESTHelper.delete(RESTHelper.fullPathKey("a"));
        RESTHelper.head(RESTHelper.fullPathKey("a"), 404);
    }

    @After
    public void tearDown() throws Exception {
        RESTHelper.delete(RESTHelper.fullPathKey(null));
    }

    @Test
    public void testPutOperation() throws Exception {
        URI fullPathKey = RESTHelper.fullPathKey("a");
        int NUM_OPERATIONS = 1000;
        String initialXML = "<hey>ho</hey>";
        StringBuilder initial = new StringBuilder(initialXML);
        for (int i = 0; i < 200; ++i) {
            initial.append("expanding");
        }
        initialXML = initial.toString();
        long t1 = System.currentTimeMillis();
        for (int i = 0; i < NUM_OPERATIONS; ++i) {
            RESTHelper.put(fullPathKey, initialXML, "application/octet-stream", 200, "performAsync", "false");
        }
        long putSyncTime = System.currentTimeMillis() - t1;
        RESTHelper.delete(fullPathKey);
        t1 = System.currentTimeMillis();
        for (int i = 0; i < NUM_OPERATIONS; ++i) {
            RESTHelper.put(fullPathKey, initialXML, "application/octet-stream", 200, "performAsync", "true");
        }
        long putAsyncTime = System.currentTimeMillis() - t1;
        Assert.assertTrue((String)("PUT : async- " + putAsyncTime + ", sync- " + putSyncTime), (putAsyncTime < putSyncTime ? 1 : 0) != 0);
        RESTHelper.get(fullPathKey, initialXML, 200, true, "performAsync", "true");
    }

    @Test
    public void testDeleteOperation() throws Exception {
        int i;
        int NUM_OPERATIONS = 15;
        int SIZE = 900;
        byte[] bytes = new byte[SIZE];
        for (i = 0; i < SIZE; ++i) {
            bytes[i] = (byte)(i % 10);
        }
        for (i = 0; i < NUM_OPERATIONS; ++i) {
            RESTHelper.put(RESTHelper.fullPathKey(String.valueOf(i)), bytes, "application/octet-stream", 200, "performAsync", "false");
        }
        for (i = 0; i < NUM_OPERATIONS; ++i) {
            RESTHelper.delete(RESTHelper.fullPathKey(String.valueOf(i)), 200, "performAsync", "true");
        }
        for (i = 0; i < NUM_OPERATIONS; ++i) {
            RESTHelper.get(RESTHelper.fullPathKey(String.valueOf(i)), null, 404, true, "performAsync", "true");
        }
        RESTHelper.put(RESTHelper.fullPathKey("a"), "a", "application/octet-stream");
        RESTHelper.put(RESTHelper.fullPathKey("b"), "b", "application/octet-stream");
        RESTHelper.delete(RESTHelper.fullPathKey(null), 200, "performAsync", "true");
        Assert.assertEquals((long)404L, (long)RESTHelper.get(RESTHelper.fullPathKey("a"), 404).getStatusLine().getStatusCode());
        Assert.assertEquals((long)404L, (long)RESTHelper.get(RESTHelper.fullPathKey("b"), 404).getStatusLine().getStatusCode());
    }
}

