/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.rest;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;

public class RESTHelper {
    public static final String KEY_A = "a";
    public static final String KEY_B = "b";
    public static final String KEY_C = "c";
    private static final String DATE_PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static int port = 8080;
    private static List<Server> servers = new ArrayList<Server>();
    private static CredentialsProvider credsProvider = new BasicCredentialsProvider();
    public static CloseableHttpClient client = HttpClients.custom().setDefaultCredentialsProvider(credsProvider).build();

    public static void addServer(String hostname, String restServerPath) {
        servers.add(new Server(hostname, restServerPath));
    }

    public static void addServer(String hostname, String port, String restServerPath) {
        RESTHelper.port = Integer.parseInt(port);
        servers.add(new Server(hostname, restServerPath));
    }

    public static String addDay(String aDate, int days) throws Exception {
        SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN_RFC1123, Locale.US);
        Date date = format.parse(aDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return format.format(cal.getTime());
    }

    public static HttpResponse head(URI uri) throws Exception {
        return RESTHelper.head(uri, 200);
    }

    public static HttpResponse headWithoutClose(URI uri) throws Exception {
        return RESTHelper.head(uri, 200);
    }

    public static HttpResponse head(URI uri, int expectedCode) throws Exception {
        return RESTHelper.head(uri, expectedCode, new String[0][0]);
    }

    public static HttpResponse headWithoutClose(URI uri, int expectedCode) throws Exception {
        return RESTHelper.head(uri, expectedCode, new String[0][0]);
    }

    public static HttpResponse headWithout(URI uri, int expectedCode, String[][] headers) throws Exception {
        HttpHead head = new HttpHead(uri);
        for (String[] eachHeader : headers) {
            head.setHeader(eachHeader[0], eachHeader[1]);
        }
        CloseableHttpResponse resp = client.execute((HttpUriRequest)head);
        Assert.assertEquals((long)expectedCode, (long)resp.getStatusLine().getStatusCode());
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse head(URI uri, int expectedCode, String[][] headers) throws Exception {
        HttpHead head = new HttpHead(uri);
        CloseableHttpResponse resp = null;
        try {
            for (String[] eachHeader : headers) {
                head.setHeader(eachHeader[0], eachHeader[1]);
            }
            resp = client.execute((HttpUriRequest)head);
        }
        finally {
            EntityUtils.consume((HttpEntity)resp.getEntity());
        }
        Assert.assertEquals((long)expectedCode, (long)resp.getStatusLine().getStatusCode());
        return resp;
    }

    public static HttpResponse get(URI uri) throws Exception {
        return RESTHelper.get(uri, 200);
    }

    public static HttpResponse getWithoutClose(URI uri) throws Exception {
        return RESTHelper.getWithoutClose(uri, 200);
    }

    public static HttpResponse get(URI uri, String expectedResponseBody) throws Exception {
        return RESTHelper.get(uri, expectedResponseBody, 200, true, new Object[0]);
    }

    public static HttpResponse getWithoutClose(URI uri, String expectedResponseBody) throws Exception {
        return RESTHelper.get(uri, expectedResponseBody, 200, false, new Object[0]);
    }

    public static HttpResponse get(URI uri, int expectedCode) throws Exception {
        return RESTHelper.get(uri, null, expectedCode, true, new Object[0]);
    }

    public static HttpResponse getWithoutClose(URI uri, int expectedCode) throws Exception {
        return RESTHelper.get(uri, null, expectedCode, false, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse get(URI uri, String expectedResponseBody, int expectedCode, boolean closeConnection, Object ... headers) throws Exception {
        HttpGet get = new HttpGet(uri);
        if (headers.length % 2 != 0) {
            throw new IllegalArgumentException("bad headers argument");
        }
        for (int i = 0; i < headers.length; i += 2) {
            get.setHeader((String)headers[i], (String)headers[i + 1]);
        }
        CloseableHttpResponse resp = client.execute((HttpUriRequest)get);
        try {
            Assert.assertEquals((long)expectedCode, (long)resp.getStatusLine().getStatusCode());
            if (expectedResponseBody != null) {
                Assert.assertEquals((Object)expectedResponseBody, (Object)EntityUtils.toString((HttpEntity)resp.getEntity()));
            }
        }
        finally {
            if (closeConnection) {
                EntityUtils.consume((HttpEntity)resp.getEntity());
            }
        }
        return resp;
    }

    public static HttpResponse put(URI uri, Object data, String contentType) throws Exception {
        return RESTHelper.put(uri, data, contentType, 200);
    }

    public static HttpResponse put(URI uri, Object data, String contentType, int expectedCode) throws Exception {
        return RESTHelper.put(uri, data, contentType, expectedCode, new Object[0]);
    }

    public static HttpResponse put(URI uri, Object data, String contentType, int expectedCode, Object ... headers) throws Exception {
        HttpPut put = new HttpPut(uri);
        if (data instanceof String) {
            put.setEntity((HttpEntity)new StringEntity((String)data, "UTF-8"));
        } else if (data instanceof byte[]) {
            byte[] byteData = (byte[])data;
            ByteArrayInputStream bs = new ByteArrayInputStream(byteData);
            put.setEntity((HttpEntity)new InputStreamEntity((InputStream)bs, (long)byteData.length));
        } else {
            throw new IllegalArgumentException("Unknown data type for PUT method");
        }
        put.setHeader("Content-Type", contentType);
        if (headers.length % 2 != 0) {
            throw new IllegalArgumentException("bad headers argument");
        }
        for (int i = 0; i < headers.length; i += 2) {
            put.setHeader((String)headers[i], (String)headers[i + 1]);
        }
        CloseableHttpResponse resp = client.execute((HttpUriRequest)put);
        EntityUtils.consume((HttpEntity)resp.getEntity());
        Assert.assertEquals((long)expectedCode, (long)resp.getStatusLine().getStatusCode());
        return resp;
    }

    public static void setCredentials(String username, String password) {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
        credsProvider.setCredentials(new AuthScope(servers.get(0).getHostname(), port), (Credentials)credentials);
    }

    public static void clearCredentials() {
        credsProvider.clear();
    }

    public static HttpResponse post(URI uri, Object data, String contentType) throws Exception {
        return RESTHelper.post(uri, data, contentType, 200);
    }

    public static HttpResponse post(URI uri, Object data, String contentType, int expectedCode) throws Exception {
        return RESTHelper.post(uri, data, contentType, expectedCode, new Object[0]);
    }

    public static HttpResponse post(URI uri, Object data, String contentType, int expectedCode, Object ... headers) throws Exception {
        HttpPost post = new HttpPost(uri);
        if (data instanceof String) {
            post.setEntity((HttpEntity)new StringEntity((String)data, "UTF-8"));
        } else if (data instanceof byte[]) {
            byte[] byteData = (byte[])data;
            ByteArrayInputStream bs = new ByteArrayInputStream(byteData);
            post.setEntity((HttpEntity)new InputStreamEntity((InputStream)bs, (long)byteData.length));
        } else {
            throw new IllegalArgumentException("Unknown data type for POST method");
        }
        post.setHeader("Content-Type", contentType);
        if (headers.length % 2 != 0) {
            throw new IllegalArgumentException("bad headers argument");
        }
        for (int i = 0; i < headers.length; i += 2) {
            post.setHeader((String)headers[i], (String)headers[i + 1]);
        }
        CloseableHttpResponse resp = client.execute((HttpUriRequest)post);
        EntityUtils.consume((HttpEntity)resp.getEntity());
        Assert.assertEquals((long)expectedCode, (long)resp.getStatusLine().getStatusCode());
        return resp;
    }

    public static HttpResponse delete(URI uri) throws Exception {
        HttpDelete delete = new HttpDelete(uri);
        CloseableHttpResponse resp = client.execute((HttpUriRequest)delete);
        EntityUtils.consume((HttpEntity)resp.getEntity());
        return resp;
    }

    public static HttpResponse delete(URI uri, int expectedCode, Object ... headers) throws Exception {
        HttpDelete delete = new HttpDelete(uri);
        if (headers.length % 2 != 0) {
            throw new IllegalArgumentException("bad headers argument");
        }
        for (int i = 0; i < headers.length; i += 2) {
            delete.setHeader((String)headers[i], (String)headers[i + 1]);
        }
        CloseableHttpResponse resp = client.execute((HttpUriRequest)delete);
        EntityUtils.consume((HttpEntity)resp.getEntity());
        Assert.assertEquals((long)expectedCode, (long)resp.getStatusLine().getStatusCode());
        return resp;
    }

    public static URI fullPathKey(int server, String cache, String key, int offset) {
        StringBuilder queryBuilder = new StringBuilder(servers.get(server).getRestServerPath() + "/" + cache);
        if (key != null) {
            queryBuilder.append("/").append(key);
        }
        String query = queryBuilder.toString();
        String hostname = servers.get(server).getHostname();
        int connectionPort = port + offset;
        try {
            URL url = new URL("http", hostname, connectionPort, query);
            try {
                return new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), null);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static URI fullPathKey(int server, String key) {
        return RESTHelper.fullPathKey(server, "___defaultcache", key, 0);
    }

    public static URI fullPathKey(int server, String key, int portOffset) {
        return RESTHelper.fullPathKey(server, "___defaultcache", key, portOffset);
    }

    public static URI fullPathKey(String key) {
        return RESTHelper.fullPathKey(0, key);
    }

    public static URI fullPathKey(String cache, String key) {
        return RESTHelper.fullPathKey(0, cache, key, 0);
    }

    public static URI fullPathKey(String cache, String key, int portOffset) {
        return RESTHelper.fullPathKey(0, cache, key, portOffset);
    }

    public static class Server {
        private String hostname;
        private String restServerPath;

        public Server(String hostname, String restServerPath) {
            this.hostname = hostname;
            this.restServerPath = restServerPath;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getRestServerPath() {
            return this.restServerPath;
        }
    }
}

