/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.cs.jdbc;

import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.server.test.client.memcached.MemcachedClient;
import org.infinispan.server.test.util.DBServer;
import org.infinispan.server.test.util.RemoteCacheManagerFactory;
import org.infinispan.server.test.util.RemoteInfinispanMBeans;
import org.infinispan.server.test.util.TestUtil;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public abstract class AbstractJdbcStoreSinglenodeTest {
    protected final String CONTAINER = "jdbc-cachestore-1";
    private final String ID_COLUMN_NAME = "id";
    private final String DATA_COLUMN_NAME = "datum";
    protected static DBServer dbServer = DBServer.create();
    private static RemoteCacheManagerFactory rcmFactory;
    protected RemoteCache cache;
    protected RemoteInfinispanMBeans mbeans;
    protected MemcachedClient mc;
    @ArquillianResource
    protected ContainerController controller;
    @InfinispanResource(value="jdbc-cachestore-1")
    protected RemoteInfinispanServer server;

    @BeforeClass
    public static void startup() {
        rcmFactory = new RemoteCacheManagerFactory();
    }

    @AfterClass
    public static void cleanup() {
        try {
            if (AbstractJdbcStoreSinglenodeTest.dbServer.bucketTable != null && AbstractJdbcStoreSinglenodeTest.dbServer.bucketTable.getConnectionUrl().contains("db2")) {
                AbstractJdbcStoreSinglenodeTest.dbServer.bucketTable.dropTable();
                AbstractJdbcStoreSinglenodeTest.dbServer.stringTable.dropTable();
            }
        }
        catch (Exception e) {
            System.out.println("Couldn't drop the tables: ");
            e.printStackTrace();
        }
        if (rcmFactory != null) {
            rcmFactory.stopManagers();
        }
        rcmFactory = null;
    }

    @Before
    public void setUp() throws Exception {
        AbstractJdbcStoreSinglenodeTest.dbServer.connectionUrl = System.getProperty("connection.url");
        AbstractJdbcStoreSinglenodeTest.dbServer.username = System.getProperty("username");
        AbstractJdbcStoreSinglenodeTest.dbServer.password = System.getProperty("password");
        AbstractJdbcStoreSinglenodeTest.dbServer.bucketTableName = this.bucketTableName();
        AbstractJdbcStoreSinglenodeTest.dbServer.stringTableName = this.stringTableName();
        String driver = System.getProperty("driver.class");
        if (AbstractJdbcStoreSinglenodeTest.dbServer.bucketTableName != null) {
            AbstractJdbcStoreSinglenodeTest.dbServer.bucketTable = new DBServer.TableManipulation(driver, dbServer, AbstractJdbcStoreSinglenodeTest.dbServer.bucketTableName, "id", "datum");
        }
        if (AbstractJdbcStoreSinglenodeTest.dbServer.stringTableName != null) {
            AbstractJdbcStoreSinglenodeTest.dbServer.stringTable = new DBServer.TableManipulation(driver, dbServer, AbstractJdbcStoreSinglenodeTest.dbServer.stringTableName, "id", "datum");
        }
        this.mbeans = TestUtil.createMBeans(this.server, "jdbc-cachestore-1", this.cacheName(), this.managerName());
    }

    protected RemoteCache<Object, Object> createCache(RemoteInfinispanMBeans mbeans) {
        return rcmFactory.createCache(mbeans);
    }

    protected abstract String bucketTableName();

    protected abstract String stringTableName();

    protected abstract String managerName();

    protected abstract String cacheName();
}

