/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.cs.jdbc.async;

import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.server.test.category.CacheStore;
import org.infinispan.server.test.cs.jdbc.AbstractJdbcStoreSinglenodeTest;
import org.infinispan.server.test.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={CacheStore.class})
public class AsyncStringBasedStoreSinglenodeTest
extends AbstractJdbcStoreSinglenodeTest {
    private final String CONFIG_STRING_ASYNC = "testsuite/jdbc-string-async.xml";
    private final String TABLE_NAME_PREFIX = "STRING_ASYNC";
    private final String CACHE_NAME = "memcachedCache";
    private final String MANAGER_NAME = "local";

    @Test
    @WithRunningServer(value={@RunningServer(name="jdbc-cachestore-1", config="testsuite/jdbc-string-async.xml")})
    public void testPutRemove() throws Exception {
        int i;
        this.mc = TestUtil.createMemcachedClient(this.server);
        int numEntries = 1000;
        String keyPrefix = "testPutRemove-k-";
        String valuePrefix = "testPutRemove-k-";
        for (i = 0; i != numEntries; ++i) {
            this.mc.set(keyPrefix + i, valuePrefix + i);
        }
        for (i = 0; i != numEntries; ++i) {
            if (!AsyncStringBasedStoreSinglenodeTest.dbServer.stringTable.exists()) {
                System.out.println("Table does not exist");
            }
            Assert.assertNotNull((String)("Key " + keyPrefix + i + " was not found in DB in " + 15000L + " ms"), (Object)AsyncStringBasedStoreSinglenodeTest.dbServer.stringTable.getValueByKeyAwait(keyPrefix + i));
        }
        for (i = 0; i != numEntries; ++i) {
            this.mc.delete(keyPrefix + i);
        }
        long limit = System.currentTimeMillis() + 15000L;
        while (!AsyncStringBasedStoreSinglenodeTest.dbServer.stringTable.getAllRows().isEmpty()) {
            if (System.currentTimeMillis() <= limit) continue;
            throw new RuntimeException("Timeout exceeded. The DB table is still not empty");
        }
    }

    @Override
    protected String bucketTableName() {
        return null;
    }

    @Override
    protected String stringTableName() {
        return "STRING_ASYNC_memcachedCache";
    }

    @Override
    protected String managerName() {
        return "local";
    }

    @Override
    protected String cacheName() {
        return "memcachedCache";
    }
}

