/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.cs.jdbc.binary;

import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.server.test.category.CacheStore;
import org.infinispan.server.test.cs.jdbc.AbstractJdbcStoreSinglenodeTest;
import org.infinispan.server.test.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={CacheStore.class})
public class BinaryStorePassivationDisabledSinglenodeTest
extends AbstractJdbcStoreSinglenodeTest {
    private final String TABLE_NAME_PREFIX = "BINARY_NO_PASSIVATION";
    private final String CACHE_NAME = "defaultx/xx";
    private final String MANAGER_NAME = "local";
    private final String CONFIG_BINARY_NO_PASSIVATION = "testsuite/jdbc-binary-no-passivation.xml";

    @Test
    @WithRunningServer(value={@RunningServer(name="jdbc-cachestore-1", config="testsuite/jdbc-binary-no-passivation.xml")})
    public void testFailoverWithPassivationDisabled() throws Exception {
        String key1 = "key1";
        String key2 = "myBestPersonalKeyWhichHasNeverBeenBetter";
        this.cache = this.createCache(this.mbeans);
        this.assertCleanCacheAndStoreHotrod();
        this.cache.put((Object)key1, (Object)"v1");
        this.cache.put((Object)key2, (Object)"v2");
        byte[] k1Stored = TestUtil.getRealKeyStored(key1, this.cache);
        byte[] k2Stored = TestUtil.getRealKeyStored(key2, this.cache);
        BinaryStorePassivationDisabledSinglenodeTest.dbServer.bucketTable.waitForTableCreation();
        Assert.assertEquals((long)2L, (long)BinaryStorePassivationDisabledSinglenodeTest.dbServer.bucketTable.getAllRows().size());
        Assert.assertNotNull((Object)BinaryStorePassivationDisabledSinglenodeTest.dbServer.bucketTable.getBucketByKey(k1Stored));
        Assert.assertNotNull((Object)BinaryStorePassivationDisabledSinglenodeTest.dbServer.bucketTable.getBucketByKey(k2Stored));
        this.controller.stop("jdbc-cachestore-1");
        this.controller.start("jdbc-cachestore-1");
        this.cache = this.createCache(this.mbeans);
        Assert.assertEquals((Object)"v1", (Object)this.cache.get((Object)key1));
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="jdbc-cachestore-1", config="testsuite/jdbc-binary-no-passivation.xml")})
    public void testPreloadWithoutPurge() throws Exception {
        String key1 = "key1";
        String key2 = "myBestPersonalKeyWhichHasNeverBeenBetter";
        this.cache = this.createCache(this.mbeans);
        this.assertCleanCacheAndStoreHotrod();
        this.cache.put((Object)key1, (Object)"v1");
        this.cache.put((Object)key2, (Object)"v2");
        byte[] k1Stored = TestUtil.getRealKeyStored(key1, this.cache);
        byte[] k2Stored = TestUtil.getRealKeyStored(key2, this.cache);
        this.controller.stop("jdbc-cachestore-1");
        this.controller.start("jdbc-cachestore-1");
        TestUtil.eventually(new TestUtil.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return 2L == BinaryStorePassivationDisabledSinglenodeTest.this.server.getCacheManager("local").getCache("defaultx/xx").getNumberOfEntries();
            }
        }, 10000L);
        Assert.assertEquals((long)2L, (long)BinaryStorePassivationDisabledSinglenodeTest.dbServer.bucketTable.getAllRows().size());
        Assert.assertNotNull((Object)BinaryStorePassivationDisabledSinglenodeTest.dbServer.bucketTable.getBucketByKey(k1Stored));
        Assert.assertNotNull((Object)BinaryStorePassivationDisabledSinglenodeTest.dbServer.bucketTable.getBucketByKey(k2Stored));
    }

    protected void assertCleanCacheAndStoreHotrod() throws Exception {
        this.cache.clear();
        if (BinaryStorePassivationDisabledSinglenodeTest.dbServer.bucketTable.exists() && !BinaryStorePassivationDisabledSinglenodeTest.dbServer.bucketTable.getAllRows().isEmpty()) {
            BinaryStorePassivationDisabledSinglenodeTest.dbServer.bucketTable.deleteAllRows();
            TestUtil.eventually(new TestUtil.Condition(){

                @Override
                public boolean isSatisfied() throws Exception {
                    return dbServer.bucketTable.getAllRows().isEmpty();
                }
            }, 10000L);
        }
    }

    @Override
    public String bucketTableName() {
        return "BINARY_NO_PASSIVATION_defaultx/xx";
    }

    @Override
    protected String stringTableName() {
        return null;
    }

    @Override
    protected String managerName() {
        return "local";
    }

    @Override
    protected String cacheName() {
        return "defaultx/xx";
    }
}

