/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.cs.jdbc.mixed;

import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.server.test.category.CacheStore;
import org.infinispan.server.test.cs.jdbc.AbstractJdbcStoreSinglenodeTest;
import org.infinispan.server.test.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={CacheStore.class})
public class MixedStorePassivationEnabledSinglenodeTest
extends AbstractJdbcStoreSinglenodeTest {
    private final String CONFIG_MIXED_WITH_PASSIVATION = "testsuite/jdbc-mixed-with-passivation.xml";
    private final String STRING_TABLE_NAME_PREFIX = "MIXED_WITH_PASSIVATION_STR";
    private final String BUCKET_TABLE_NAME_PREFIX = "MIXED_WITH_PASSIVATION_BKT";
    private final String CACHE_NAME = "memcachedCache";
    private final String MANAGER_NAME = "local";

    @Test
    @WithRunningServer(value={@RunningServer(name="jdbc-cachestore-1", config="testsuite/jdbc-mixed-with-passivation.xml")})
    public void testPassivateAfterEviction() throws Exception {
        this.mc = TestUtil.createMemcachedClient(this.server);
        this.assertCleanCacheAndStore();
        this.mc.set("k1", "v1");
        this.mc.set("k2", "v2");
        System.out.println("Available tables: " + MixedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.getTableNames());
        Assert.assertTrue((!MixedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.exists() || MixedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.getAllRows().isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((!MixedStorePassivationEnabledSinglenodeTest.dbServer.bucketTable.exists() || MixedStorePassivationEnabledSinglenodeTest.dbServer.bucketTable.getAllRows().isEmpty() ? 1 : 0) != 0);
        this.mc.set("k3", "v3");
        Assert.assertEquals((long)2L, (long)this.server.getCacheManager("local").getCache("memcachedCache").getNumberOfEntries());
        Assert.assertEquals((long)1L, (long)MixedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.getAllRows().size());
        Assert.assertTrue((!MixedStorePassivationEnabledSinglenodeTest.dbServer.bucketTable.exists() || MixedStorePassivationEnabledSinglenodeTest.dbServer.bucketTable.getAllRows().isEmpty() ? 1 : 0) != 0);
        this.mc.get("k1");
        Assert.assertEquals((long)2L, (long)this.server.getCacheManager("local").getCache("memcachedCache").getNumberOfEntries());
        Assert.assertNotNull((Object)MixedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.getValueByKey("k2"));
        Assert.assertEquals((long)1L, (long)MixedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.getAllRows().size());
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="jdbc-cachestore-1", config="testsuite/jdbc-mixed-with-passivation.xml")})
    public void testFailoverWithoutPreload() throws Exception {
        this.mc = TestUtil.createMemcachedClient(this.server);
        this.assertCleanCacheAndStore();
        this.mc.set("k1", "v1");
        this.mc.set("k2", "v2");
        System.out.println("Available tables: " + MixedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.getTableNames());
        Assert.assertTrue((!MixedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.exists() || MixedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.getAllRows().isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((!MixedStorePassivationEnabledSinglenodeTest.dbServer.bucketTable.exists() || MixedStorePassivationEnabledSinglenodeTest.dbServer.bucketTable.getAllRows().isEmpty() ? 1 : 0) != 0);
        this.mc.set("k3", "v3");
        MixedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.waitForTableCreation();
        Assert.assertTrue((0 < MixedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.getAllRows().size() ? 1 : 0) != 0);
        Assert.assertTrue((!MixedStorePassivationEnabledSinglenodeTest.dbServer.bucketTable.exists() || MixedStorePassivationEnabledSinglenodeTest.dbServer.bucketTable.getAllRows().isEmpty() ? 1 : 0) != 0);
        this.controller.stop("jdbc-cachestore-1");
        this.controller.start("jdbc-cachestore-1");
        this.mc = TestUtil.createMemcachedClient(this.server);
        Assert.assertEquals((long)0L, (long)this.server.getCacheManager("local").getCache("memcachedCache").getNumberOfEntries());
        Assert.assertEquals((long)3L, (long)MixedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.getAllRows().size());
        Assert.assertTrue((boolean)MixedStorePassivationEnabledSinglenodeTest.dbServer.bucketTable.getAllRows().isEmpty());
        Assert.assertEquals((Object)"v1", (Object)this.mc.get("k1"));
    }

    private void assertCleanCacheAndStore() throws Exception {
        this.mc.delete("k1");
        this.mc.delete("k2");
        this.mc.delete("k3");
        if (MixedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.exists() && !MixedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.getAllRows().isEmpty()) {
            MixedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.deleteAllRows();
            TestUtil.eventually(new TestUtil.Condition(){

                @Override
                public boolean isSatisfied() throws Exception {
                    return dbServer.stringTable.getAllRows().isEmpty();
                }
            }, 10000L);
        }
    }

    @Override
    protected String bucketTableName() {
        return "MIXED_WITH_PASSIVATION_BKT_memcachedCache";
    }

    @Override
    protected String stringTableName() {
        return "MIXED_WITH_PASSIVATION_STR_memcachedCache";
    }

    @Override
    protected String managerName() {
        return "local";
    }

    @Override
    protected String cacheName() {
        return "memcachedCache";
    }
}

