/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.cs.jdbc.string;

import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.server.test.category.CacheStore;
import org.infinispan.server.test.cs.jdbc.AbstractJdbcStoreSinglenodeTest;
import org.infinispan.server.test.util.RemoteInfinispanMBeans;
import org.infinispan.server.test.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={CacheStore.class})
public class StringBasedStorePassivationDisabledSinglenodeTest
extends AbstractJdbcStoreSinglenodeTest {
    private final String CONFIG_STRING_NO_PASSIVATION = "testsuite/jdbc-string-no-passivation.xml";
    private final String TABLE_NAME_PREFIX = "STRING_NO_PASSIVATION";
    private static final String MANAGER_NAME = "local";
    private final String CACHE_NAME_STRING = "memcachedCache";
    private final String CACHE_NAME_BUCKET = "default";

    @Test
    @WithRunningServer(value={@RunningServer(name="jdbc-cachestore-1", config="testsuite/jdbc-string-no-passivation.xml")})
    public void testFailoverWithPassivationDisabled() throws Exception {
        this.mc = TestUtil.createMemcachedClient(this.server);
        this.assertCleanCacheAndStore();
        this.mc.set("k1", "v1");
        this.mc.set("k2", "v2");
        Assert.assertNotNull((Object)StringBasedStorePassivationDisabledSinglenodeTest.dbServer.stringTable.getValueByKey("k1"));
        Assert.assertNotNull((Object)StringBasedStorePassivationDisabledSinglenodeTest.dbServer.stringTable.getValueByKey("k2"));
        this.controller.stop("jdbc-cachestore-1");
        this.controller.start("jdbc-cachestore-1");
        this.mc = TestUtil.createMemcachedClient(this.server);
        Assert.assertEquals((Object)"v1", (Object)this.mc.get("k1"));
        Assert.assertEquals((Object)"v2", (Object)this.mc.get("k2"));
        this.mc.delete("k1");
        Assert.assertNull((Object)StringBasedStorePassivationDisabledSinglenodeTest.dbServer.stringTable.getValueByKey("k1"));
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="jdbc-cachestore-1", config="testsuite/jdbc-string-no-passivation.xml")})
    public void testPreloadWithoutPurge() throws Exception {
        this.mc = TestUtil.createMemcachedClient(this.server);
        this.assertCleanCacheAndStore();
        this.mc.set("k1", "v1");
        this.mc.set("k2", "v2");
        Assert.assertNotNull((Object)StringBasedStorePassivationDisabledSinglenodeTest.dbServer.stringTable.getValueByKey("k1"));
        Assert.assertNotNull((Object)StringBasedStorePassivationDisabledSinglenodeTest.dbServer.stringTable.getValueByKey("k2"));
        this.controller.stop("jdbc-cachestore-1");
        this.controller.start("jdbc-cachestore-1");
        Assert.assertEquals((long)2L, (long)this.server.getCacheManager(MANAGER_NAME).getCache("memcachedCache").getNumberOfEntries());
        Assert.assertNotNull((Object)StringBasedStorePassivationDisabledSinglenodeTest.dbServer.stringTable.getValueByKey("k1"));
        Assert.assertNotNull((Object)StringBasedStorePassivationDisabledSinglenodeTest.dbServer.stringTable.getValueByKey("k2"));
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="jdbc-cachestore-1", config="testsuite/jdbc-string-no-passivation.xml")})
    public void testStoreDataWithHotRodClient() throws Exception {
        RemoteInfinispanMBeans mbeans = TestUtil.createMBeans(this.server, "jdbc-cachestore-1", "default", MANAGER_NAME);
        this.cache = this.createCache(mbeans);
        this.assertCleanCacheAndStoreHotrod();
        Double doubleKey = 10.0;
        Double doubleValue = 20.0;
        this.cache.clear();
        Assert.assertEquals((long)0L, (long)this.server.getCacheManager(MANAGER_NAME).getCache("default").getNumberOfEntries());
        Assert.assertTrue((boolean)StringBasedStorePassivationDisabledSinglenodeTest.dbServer.bucketTable.getAllRows().isEmpty());
        this.cache.put((Object)doubleKey, (Object)doubleValue);
        Assert.assertEquals((long)1L, (long)StringBasedStorePassivationDisabledSinglenodeTest.dbServer.bucketTable.getAllRows().size());
        this.controller.stop("jdbc-cachestore-1");
        this.controller.start("jdbc-cachestore-1");
        this.cache = this.createCache(mbeans);
        Assert.assertEquals((long)1L, (long)StringBasedStorePassivationDisabledSinglenodeTest.dbServer.bucketTable.getAllRows().size());
        Assert.assertEquals((Object)doubleValue, (Object)this.cache.get((Object)doubleKey));
    }

    private void assertCleanCacheAndStore() throws Exception {
        this.mc.delete("k1");
        this.mc.delete("k2");
        if (StringBasedStorePassivationDisabledSinglenodeTest.dbServer.stringTable.exists() && !StringBasedStorePassivationDisabledSinglenodeTest.dbServer.stringTable.getAllRows().isEmpty()) {
            StringBasedStorePassivationDisabledSinglenodeTest.dbServer.stringTable.deleteAllRows();
            TestUtil.eventually(new TestUtil.Condition(){

                @Override
                public boolean isSatisfied() throws Exception {
                    return dbServer.stringTable.getAllRows().isEmpty();
                }
            }, 10000L);
        }
        if (StringBasedStorePassivationDisabledSinglenodeTest.dbServer.bucketTable.exists() && !StringBasedStorePassivationDisabledSinglenodeTest.dbServer.bucketTable.getAllRows().isEmpty()) {
            StringBasedStorePassivationDisabledSinglenodeTest.dbServer.bucketTable.deleteAllRows();
            TestUtil.eventually(new TestUtil.Condition(){

                @Override
                public boolean isSatisfied() throws Exception {
                    return dbServer.bucketTable.getAllRows().isEmpty();
                }
            }, 10000L);
        }
    }

    protected void assertCleanCacheAndStoreHotrod() throws Exception {
        this.cache.clear();
        if (StringBasedStorePassivationDisabledSinglenodeTest.dbServer.bucketTable.exists() && !StringBasedStorePassivationDisabledSinglenodeTest.dbServer.bucketTable.getAllRows().isEmpty()) {
            StringBasedStorePassivationDisabledSinglenodeTest.dbServer.bucketTable.deleteAllRows();
            TestUtil.eventually(new TestUtil.Condition(){

                @Override
                public boolean isSatisfied() throws Exception {
                    return dbServer.bucketTable.getAllRows().isEmpty();
                }
            }, 10000L);
        }
    }

    @Override
    protected String bucketTableName() {
        return "STRING_NO_PASSIVATION_default";
    }

    @Override
    protected String stringTableName() {
        return "STRING_NO_PASSIVATION_memcachedCache";
    }

    @Override
    protected String managerName() {
        return MANAGER_NAME;
    }

    @Override
    protected String cacheName() {
        return "memcachedCache";
    }
}

