/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.cs.jdbc.string;

import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.server.test.category.CacheStore;
import org.infinispan.server.test.cs.jdbc.AbstractJdbcStoreSinglenodeTest;
import org.infinispan.server.test.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={CacheStore.class})
public class StringBasedStorePassivationEnabledSinglenodeTest
extends AbstractJdbcStoreSinglenodeTest {
    private final String CONFIG_STRING_WITH_PASSIVATION = "testsuite/jdbc-string-with-passivation.xml";
    private final String TABLE_NAME_PREFIX = "STRING_WITH_PASSIVATION";
    private final String CACHE_NAME = "memcachedCache";
    private final String MANAGER_NAME = "local";

    @Test
    @WithRunningServer(value={@RunningServer(name="jdbc-cachestore-1", config="testsuite/jdbc-string-with-passivation.xml")})
    public void testPassivateAfterEviction() throws Exception {
        this.mc = TestUtil.createMemcachedClient(this.server);
        this.assertCleanCacheAndStore();
        this.mc.set("k1", "v1");
        this.mc.set("k2", "v2");
        Assert.assertTrue((!StringBasedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.exists() || StringBasedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.getValueByKey("k1") == null ? 1 : 0) != 0);
        Assert.assertTrue((!StringBasedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.exists() || StringBasedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.getValueByKey("k2") == null ? 1 : 0) != 0);
        this.mc.set("k3", "v3");
        Assert.assertEquals((Object)"v3", (Object)this.mc.get("k3"));
        Assert.assertTrue((2L >= this.server.getCacheManager("local").getCache("memcachedCache").getNumberOfEntries() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)StringBasedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.getValueByKey("k1"));
        this.mc.get("k1");
        Assert.assertTrue((2L >= this.server.getCacheManager("local").getCache("memcachedCache").getNumberOfEntries() ? 1 : 0) != 0);
        Assert.assertNull((Object)StringBasedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.getValueByKey("k1"));
        Assert.assertNotNull((Object)StringBasedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.getValueByKey("k2"));
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="jdbc-cachestore-1", config="testsuite/jdbc-string-with-passivation.xml")})
    public void testSoftRestartWithoutPreload() throws Exception {
        this.mc = TestUtil.createMemcachedClient(this.server);
        this.assertCleanCacheAndStore();
        this.mc.set("k1", "v1");
        this.mc.set("k2", "v2");
        Assert.assertTrue((!StringBasedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.exists() || StringBasedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.getValueByKey("k1") == null ? 1 : 0) != 0);
        Assert.assertTrue((!StringBasedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.exists() || StringBasedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.getValueByKey("k2") == null ? 1 : 0) != 0);
        this.mc.set("k3", "v3");
        Assert.assertTrue((2L >= this.server.getCacheManager("local").getCache("memcachedCache").getNumberOfEntries() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)StringBasedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.getValueByKey("k1"));
        this.controller.stop("jdbc-cachestore-1");
        this.controller.start("jdbc-cachestore-1");
        this.mc = TestUtil.createMemcachedClient(this.server);
        Assert.assertEquals((long)0L, (long)this.server.getCacheManager("local").getCache("memcachedCache").getNumberOfEntries());
        Assert.assertTrue((!StringBasedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.getAllRows().isEmpty() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)StringBasedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.getValueByKey("k1"));
        Assert.assertEquals((Object)"v1", (Object)this.mc.get("k1"));
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="jdbc-cachestore-1", config="testsuite/jdbc-string-with-passivation.xml")})
    public void testFailoverWithoutPreload() throws Exception {
        this.mc = TestUtil.createMemcachedClient(this.server);
        this.assertCleanCacheAndStore();
        this.mc.set("k1", "v1");
        this.mc.set("k2", "v2");
        Assert.assertTrue((!StringBasedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.exists() || StringBasedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.getValueByKey("k1") == null ? 1 : 0) != 0);
        Assert.assertTrue((!StringBasedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.exists() || StringBasedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.getValueByKey("k2") == null ? 1 : 0) != 0);
        this.mc.set("k3", "v3");
        Assert.assertTrue((2L >= this.server.getCacheManager("local").getCache("memcachedCache").getNumberOfEntries() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)StringBasedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.getValueByKey("k1"));
        this.controller.kill("jdbc-cachestore-1");
        this.controller.start("jdbc-cachestore-1");
        this.mc = TestUtil.createMemcachedClient(this.server);
        Assert.assertEquals((long)0L, (long)this.server.getCacheManager("local").getCache("memcachedCache").getNumberOfEntries());
        Assert.assertTrue((!StringBasedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.getAllRows().isEmpty() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)StringBasedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.getValueByKey("k1"));
        Assert.assertEquals((Object)"v1", (Object)this.mc.get("k1"));
    }

    private void assertCleanCacheAndStore() throws Exception {
        this.mc.delete("k1");
        this.mc.delete("k2");
        this.mc.delete("k3");
        if (StringBasedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.exists() && !StringBasedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.getAllRows().isEmpty()) {
            StringBasedStorePassivationEnabledSinglenodeTest.dbServer.stringTable.deleteAllRows();
            TestUtil.eventually(new TestUtil.Condition(){

                @Override
                public boolean isSatisfied() throws Exception {
                    return dbServer.stringTable.getAllRows().isEmpty();
                }
            }, 10000L);
        }
    }

    @Override
    protected String bucketTableName() {
        return null;
    }

    @Override
    protected String stringTableName() {
        return "STRING_WITH_PASSIVATION_memcachedCache";
    }

    @Override
    protected String managerName() {
        return "local";
    }

    @Override
    protected String cacheName() {
        return "memcachedCache";
    }
}

