/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.expiration;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.server.test.client.rest.RESTHelper;
import org.infinispan.server.test.util.TestUtil;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@WithRunningServer(value={@RunningServer(name="expiration-1"), @RunningServer(name="expiration-2")})
public class ExpirationTest {
    @InfinispanResource(value="expiration-1")
    RemoteInfinispanServer server1;
    @InfinispanResource(value="expiration-2")
    RemoteInfinispanServer server2;

    @Test
    public void testRESTExpiration() throws Exception {
        RESTHelper.addServer(this.server1.getRESTEndpoint().getInetAddress().getHostName(), this.server1.getRESTEndpoint().getContextPath());
        RESTHelper.addServer(this.server2.getRESTEndpoint().getInetAddress().getHostName(), this.server2.getRESTEndpoint().getContextPath());
        URI key1Path = RESTHelper.fullPathKey(0, "k1");
        URI key2Path = RESTHelper.fullPathKey(1, "k2");
        URI key3Path = RESTHelper.fullPathKey(0, "k3");
        URI key4Path = RESTHelper.fullPathKey(0, "k4");
        Assert.assertEquals((long)2L, (long)this.server1.getCacheManager("clustered").getClusterSize());
        RESTHelper.post(key1Path, "v1", "application/text", 200, "Content-Type", "application/text", "timeToLiveSeconds", "3", "maxIdleTimeSeconds", "3");
        RESTHelper.post(key2Path, "v2", "application/text", 200, "Content-Type", "application/text");
        RESTHelper.post(key3Path, "v3", "application/text", 200, "Content-Type", "application/text", "timeToLiveSeconds", "0", "maxIdleTimeSeconds", "0");
        RESTHelper.post(key4Path, "v4", "application/text", 200, "Content-Type", "application/text", "timeToLiveSeconds", "0", "maxIdleTimeSeconds", "2");
        Thread.sleep(1000L);
        RESTHelper.get(key1Path, "v1");
        RESTHelper.get(key3Path, "v3");
        RESTHelper.get(key4Path, "v4");
        Thread.sleep(1100L);
        RESTHelper.get(key1Path, "v1");
        RESTHelper.head(key3Path, 404);
        RESTHelper.head(key4Path, 404);
        Thread.sleep(1000L);
        RESTHelper.head(key1Path, 404);
        RESTHelper.get(key2Path, "v2");
    }

    @Test
    public void testHotRodExpiration() throws Exception {
        RemoteCacheManager rcm1 = TestUtil.createCacheManager(this.server1);
        RemoteCacheManager rcm2 = TestUtil.createCacheManager(this.server2);
        RemoteCache c = rcm1.getCache("hotrodExpiration");
        RemoteCache c2 = rcm2.getCache("hotrodExpiration");
        c.put((Object)"key1", (Object)"value1");
        c2.put((Object)"key1_c2", (Object)"value1_c2");
        c.put((Object)"key2", (Object)"value2", 4000L, TimeUnit.MILLISECONDS, 4000L, TimeUnit.MILLISECONDS);
        c2.put((Object)"key2_c2", (Object)"value2_c2", 4000L, TimeUnit.MILLISECONDS, 4000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((String)"key1 should be in cache.", (Object)"value1", (Object)c.get((Object)"key1"));
        Assert.assertEquals((String)"key1_c2 should be in cache2.", (Object)"value1_c2", (Object)c2.get((Object)"key1_c2"));
        Thread.sleep(3000L);
        Assert.assertTrue((String)"key1 should be expired already.", (c.get((Object)"key1") == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"key1_c2 should be expired already.", (c2.get((Object)"key1_c2") == null ? 1 : 0) != 0);
        Assert.assertEquals((String)"key2 should still be in the cache.", (Object)"value2", (Object)c.get((Object)"key2"));
        Assert.assertEquals((String)"key2_c2 should still be in the cache.", (Object)"value2_c2", (Object)c2.get((Object)"key2_c2"));
        Thread.sleep(2000L);
        Assert.assertTrue((String)"key2 should be expired already.", (c.get((Object)"key2") == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"key2_c2 should be expired already.", (c2.get((Object)"key2_c2") == null ? 1 : 0) != 0);
    }
}

