/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.jmxmanagement.suppress.statetransfer;

import org.apache.log4j.Logger;
import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.server.test.client.memcached.MemcachedClient;
import org.infinispan.server.test.jmxmanagement.suppress.statetransfer.AbstractStateTransferSuppressTest;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class StateTransferSuppressForMemcacheTest
extends AbstractStateTransferSuppressTest {
    private static final String CACHE_MANAGER_NAME = "clustered";
    private static final String CACHE_NAME = "memcachedCache";
    private static final Logger log = Logger.getLogger(StateTransferSuppressForMemcacheTest.class);
    private MemcachedClient mc;

    @Override
    protected void prepare() {
        try {
            this.mc = new MemcachedClient("UTF-8", this.server(0).getMemcachedEndpoint().getInetAddress().getHostName(), this.server(0).getMemcachedEndpoint().getPort(), this.server(0).getMemcachedEndpoint().getPort());
            this.providers.add(new MBeanServerConnectionProvider(this.server(0).getMemcachedEndpoint().getInetAddress().getHostName(), 9999));
            this.providers.add(new MBeanServerConnectionProvider(this.server(1).getMemcachedEndpoint().getInetAddress().getHostName(), 10099));
        }
        catch (Exception ex) {
            log.warn((Object)"prepare() method throws exception", (Throwable)ex);
        }
    }

    @Override
    protected void destroy() {
    }

    @Override
    protected void putDataIntoCache(int count) {
        try {
            for (int i = 0; i < count; ++i) {
                this.mc.set("key" + i, "value" + i);
            }
            long num1 = this.server(0).getCacheManager(this.getCacheManagerName()).getCache(this.getCacheName()).getNumberOfEntries();
            long num2 = this.server(1).getCacheManager(this.getCacheManagerName()).getCache(this.getCacheName()).getNumberOfEntries();
            Assert.assertEquals((String)"The size of both caches should be equal.", (long)num1, (long)num2);
            Assert.assertEquals((long)count, (long)num1);
            Assert.assertEquals((long)count, (long)num2);
        }
        catch (Exception ex) {
            log.error((Object)"putDataIntoCache() throws exception", (Throwable)ex);
        }
    }

    @Override
    protected String getCacheManagerName() {
        return CACHE_MANAGER_NAME;
    }

    @Override
    protected String getCacheName() {
        return CACHE_NAME;
    }

    @Override
    protected void createNewProvider() {
        this.providers.add(new MBeanServerConnectionProvider(this.server(2).getMemcachedEndpoint().getInetAddress().getHostName(), 10199));
    }
}

