/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.query;

import java.io.IOException;
import java.io.InputStream;
import javax.management.ObjectName;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.sampledomain.User;
import org.infinispan.protostream.sampledomain.marshallers.MarshallerRegistration;
import org.infinispan.server.test.util.RemoteCacheManagerFactory;
import org.infinispan.server.test.util.TestUtil;
import org.junit.After;
import org.junit.Before;

public abstract class RemoteQueryBaseTest {
    protected final String cacheContainerName;
    protected final String cacheName;
    protected RemoteCacheManager remoteCacheManager;
    protected RemoteCache<Integer, User> remoteCache;
    protected MBeanServerConnectionProvider jmxConnectionProvider;
    protected RemoteCacheManagerFactory rcmFactory;

    protected RemoteQueryBaseTest(String cacheContainerName, String cacheName) {
        this.cacheContainerName = cacheContainerName;
        this.cacheName = cacheName;
    }

    protected abstract RemoteInfinispanServer getServer();

    @Before
    public void setUp() throws Exception {
        this.jmxConnectionProvider = new MBeanServerConnectionProvider(this.getServer().getHotrodEndpoint().getInetAddress().getHostName(), 9999);
        this.rcmFactory = new RemoteCacheManagerFactory();
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host(this.getServer().getHotrodEndpoint().getInetAddress().getHostName()).port(this.getServer().getHotrodEndpoint().getPort()).marshaller((Marshaller)new ProtoStreamMarshaller());
        this.remoteCacheManager = this.rcmFactory.createManager(clientBuilder);
        this.remoteCache = this.remoteCacheManager.getCache(this.cacheName);
        String mbean = "jboss.infinispan:type=RemoteQuery,name=" + ObjectName.quote(this.cacheContainerName) + ",component=ProtobufMetadataManager";
        byte[] descriptor = this.readClasspathResource("/sample_bank_account/bank.protobin");
        TestUtil.invokeOperation(this.jmxConnectionProvider, mbean, "registerProtofile", new Object[]{descriptor}, new String[]{byte[].class.getName()});
        MarshallerRegistration.registerMarshallers((SerializationContext)ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.remoteCacheManager));
    }

    @After
    public void tearDown() {
        if (this.remoteCache != null) {
            this.remoteCache.clear();
        }
        if (this.rcmFactory != null) {
            this.rcmFactory.stopManagers();
        }
        this.rcmFactory = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readClasspathResource(String resourcePath) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(resourcePath);
        try {
            byte[] byArray = Util.readStream((InputStream)is);
            return byArray;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

